REM HEADER
REM   $Header: wfrefchk.sql 26.1 2003/02/17 17:34:01 rwunderl ship $
REM ***********************************************************************
REM   NAME
REM       wfrefchk.sql - WorkFlow Primary,Unique and Foreign Key constraint
REM                      checker
REM
REM   DESCRIPTION
REM       Checks for all invalid workflow data that is missing primary
REM       key data for a foreign key
REM       
REM   USAGE
REM       sqlplus <usr>/<passwd>@db @wfrefchk
REM ********************************************************************

spool wfrefchk.out

/*
** Core constraints (objects in wfcorec.sql)
*/
/*
** 'WF_ITEM_TYPES_PK violations'
*/
SELECT   NAME
FROM     WF_ITEM_TYPES 
GROUP BY NAME
HAVING   COUNT(*) > 1;

/*
** 'WF_ITEM_TYPES_TL_PK violations'
*/
SELECT   NAME, LANGUAGE
FROM     WF_ITEM_TYPES_TL 
GROUP BY NAME, LANGUAGE
HAVING   COUNT(*) > 1;

/*
** 'WF_ITEM_TYPES_TL_U2 violations'
*/
SELECT   DISPLAY_NAME, LANGUAGE
FROM     WF_ITEM_TYPES_TL 
GROUP BY DISPLAY_NAME, LANGUAGE
HAVING   COUNT(*) > 1;

/*
** 'WF_ITEM_ATTRIBUTES_PK violations'
*/
SELECT   NAME, ITEM_TYPE
FROM     WF_ITEM_ATTRIBUTES
GROUP BY NAME, ITEM_TYPE
HAVING   COUNT(*) > 1;

/*
** 'WF_ITEM_ATTRIBUTES_TL_PK violations'
*/
SELECT   NAME, ITEM_TYPE, LANGUAGE
FROM     WF_ITEM_ATTRIBUTES_TL
GROUP BY NAME, ITEM_TYPE, LANGUAGE
HAVING   COUNT(*) > 1;

/*
** 'WF_ITEM_ATTRIBUTES_TL_U2 violations'
*/
SELECT   DISPLAY_NAME, ITEM_TYPE, LANGUAGE
FROM     WF_ITEM_ATTRIBUTES_TL 
GROUP BY DISPLAY_NAME, ITEM_TYPE, LANGUAGE
HAVING   COUNT(*) > 1;

/*
** 'WF_LOOKUP_TYPES_TL_PK violations'
*/
SELECT   LOOKUP_TYPE, LANGUAGE
FROM     WF_LOOKUP_TYPES_TL
GROUP BY LOOKUP_TYPE, LANGUAGE
HAVING   COUNT(*) > 1;

/*
** 'WF_LOOKUP_TYPES_TL_U2 violations'
*/
SELECT   DISPLAY_NAME, LANGUAGE
FROM     WF_LOOKUP_TYPES_TL
GROUP BY DISPLAY_NAME, LANGUAGE
HAVING   COUNT(*) > 1;

/*
** 'WF_LOOKUPS_TL_PK violations'
*/
SELECT   LOOKUP_CODE, LOOKUP_TYPE, LANGUAGE
FROM     WF_LOOKUPS_TL
GROUP BY LOOKUP_CODE, LOOKUP_TYPE, LANGUAGE
HAVING   COUNT(*) > 1;

/*
** 'WF_LOOKUPS_TL_U2 violations'
*/
SELECT   MEANING, LOOKUP_TYPE, LANGUAGE
FROM     WF_LOOKUPS_TL
GROUP BY MEANING, LOOKUP_TYPE, LANGUAGE
HAVING   COUNT(*) > 1;

/*
** 'WF_RESOURCES_PK violations'
*/
SELECT   NAME, TYPE, LANGUAGE
FROM     WF_RESOURCES
GROUP BY NAME, TYPE, LANGUAGE
HAVING   COUNT(*) > 1;

/*
** 'WF_ITEM_ATTRIBUTES_FK1 violations'
*/
SELECT   WFIA.ITEM_TYPE
FROM     WF_ITEM_ATTRIBUTES WFIA
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ITEM_TYPES WFIT
   WHERE  WFIA.ITEM_TYPE = WFIT.NAME);

/*
** 'WF_ITEM_ATTRIBUTES_TL_FK1 violations'
*/
SELECT   WFIATL.NAME, WFIATL.ITEM_TYPE
FROM     WF_ITEM_ATTRIBUTES_TL WFIATL
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ITEM_ATTRIBUTES WFIA
   WHERE  WFIA.ITEM_TYPE = WFIATL.ITEM_TYPE
   AND    WFIA.NAME = WFIATL.NAME);

/*
** 'WF_LOOKUP_TYPES_TL_FK1 violations'
*/
SELECT   WFLTTL.ITEM_TYPE, WFLTTL.LOOKUP_TYPE, WFLTTL.DISPLAY_NAME 
FROM     WF_LOOKUP_TYPES_TL  WFLTTL
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ITEM_TYPES WFIT
   WHERE  WFLTTL.ITEM_TYPE = WFIT.NAME);

/*
** 'WF_LOOKUPS_TL_FK1 violations'
*/
SELECT   WFLTL.LOOKUP_TYPE,  WFLTL.LANGUAGE
FROM     WF_LOOKUPS_TL  WFLTL
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_LOOKUP_TYPES_TL WFLTTL
   WHERE  WFLTTL.LOOKUP_TYPE = WFLTL.LOOKUP_TYPE
   AND    WFLTTL.LANGUAGE = WFLTL.LANGUAGE);

/*
** Notification constraints (objects in wfntfc.sql)
*/
/*
** 'WF_MESSAGES_PK violations'
*/
SELECT   NAME, TYPE
FROM     WF_MESSAGES
GROUP BY NAME, TYPE
HAVING   COUNT(*) > 1;


/*
** 'WF_MESSAGES_TL_PK violations'
*/
SELECT   NAME, TYPE, LANGUAGE
FROM     WF_MESSAGES_TL
GROUP BY NAME, TYPE, LANGUAGE
HAVING   COUNT(*) > 1;

/*
** 'WF_MESSAGE_ATTRIBUTES_PK violations'
*/
SELECT MESSAGE_NAME, MESSAGE_TYPE, NAME
FROM   WF_MESSAGE_ATTRIBUTES 
GROUP BY MESSAGE_NAME, MESSAGE_TYPE, NAME
HAVING COUNT(*) > 1;

/*
** 'WF_MESSAGE_ATTRIBUTES_U2 violations'
*/
SELECT MESSAGE_NAME, MESSAGE_TYPE, SEQUENCE
FROM   WF_MESSAGE_ATTRIBUTES 
GROUP BY MESSAGE_NAME, MESSAGE_TYPE, SEQUENCE
HAVING COUNT(*) > 1;

/*
** 'WF_MESSAGE_ATTRIBUTES_TL_PK violations'
*/
SELECT MESSAGE_NAME, MESSAGE_TYPE, NAME, LANGUAGE
FROM   WF_MESSAGE_ATTRIBUTES_TL 
GROUP BY MESSAGE_NAME, MESSAGE_TYPE, NAME, LANGUAGE
HAVING COUNT(*) > 1;

/*
** 'WF_MESSAGE_ATTRIBUTES_TL_U2 violations'
*/
SELECT MESSAGE_NAME, MESSAGE_TYPE, DISPLAY_NAME, LANGUAGE
FROM   WF_MESSAGE_ATTRIBUTES_TL 
GROUP BY MESSAGE_NAME, MESSAGE_TYPE, DISPLAY_NAME, LANGUAGE
HAVING COUNT(*) > 1;

/*
** 'WF_NOTIFICATIONS_PK violations'
*/
SELECT NOTIFICATION_ID
FROM   WF_NOTIFICATIONS 
GROUP BY NOTIFICATION_ID
HAVING COUNT(*) > 1;

/*
** 'WF_NOTIFICATIONS_ATTR_PK violations'
*/
SELECT NOTIFICATION_ID, NAME
FROM   WF_NOTIFICATION_ATTRIBUTES 
GROUP BY NOTIFICATION_ID, NAME
HAVING COUNT(*) > 1;

/*
** 'WF_ROUTING_RULES_PK violations'
*/
SELECT RULE_ID
FROM   WF_ROUTING_RULES   
GROUP BY RULE_ID
HAVING COUNT(*) > 1;

/*
** 'WF_ROUTING_RULE_ATTRIBUTES_PK violations'
*/
SELECT RULE_ID, NAME, TYPE
FROM   WF_ROUTING_RULE_ATTRIBUTES   
GROUP BY RULE_ID, NAME, TYPE
HAVING COUNT(*) > 1;

/*
** 'WF_ROUTING_RULE_ATTRIBUTES_FK1 violations'
*/
SELECT    WFRRA.RULE_ID
FROM     WF_ROUTING_RULE_ATTRIBUTES WFRRA
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ROUTING_RULES WFRR
   WHERE  WFRR.RULE_ID = WFRRA.RULE_ID);

/*
** 'WF_MESSAGES_TL_FK1 violations'
*/
SELECT   WFMTL.NAME, WFMTL.TYPE
FROM     WF_MESSAGES_TL WFMTL
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_MESSAGES WFM
   WHERE  WFM.NAME = WFMTL.NAME
   AND    WFM.TYPE = WFMTL.TYPE);

/*
** 'WF_MESSAGE_ATTRIBUTES_FK1 violations'
*/
SELECT   WFMATL.MESSAGE_NAME, WFMATL.MESSAGE_TYPE, WFMATL.NAME
FROM     WF_MESSAGE_ATTRIBUTES_TL WFMATL
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_MESSAGE_ATTRIBUTES WFMA
   WHERE  WFMATL.MESSAGE_NAME = WFMA.MESSAGE_NAME
   AND    WFMATL.MESSAGE_TYPE = WFMA.MESSAGE_TYPE
   AND    WFMATL.NAME = WFMA.NAME);


/*
** 'WF_NOTIFICATIONS_FK1 violations'
*/
SELECT   WFN.MESSAGE_NAME, WFN.MESSAGE_TYPE
FROM     WF_NOTIFICATIONS WFN
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_MESSAGES WFM
   WHERE  WFM.NAME = WFN.MESSAGE_NAME
   AND    WFM.TYPE = WFN.MESSAGE_TYPE);

/*
** 'WF_NOTIFICATION_ATTR_FK1 violations'
*/
SELECT   WFNA.NOTIFICATION_ID
FROM     WF_NOTIFICATION_ATTRIBUTES WFNA
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_NOTIFICATIONS WFN
   WHERE  WFN.NOTIFICATION_ID = WFNA.NOTIFICATION_ID);


/*
** Engine constraints (objects in wfengc.sql)
*/

/*
** 'WF_ACTIVITIES_PK violations'
*/
SELECT NAME, ITEM_TYPE, VERSION
FROM   WF_ACTIVITIES 
GROUP BY NAME, ITEM_TYPE, VERSION
HAVING COUNT(*) > 1;

/*
** 'WF_ACTIVITIES_TL_PK violations'
*/
SELECT NAME, ITEM_TYPE, VERSION, LANGUAGE
FROM   WF_ACTIVITIES_TL 
GROUP BY NAME, ITEM_TYPE, VERSION, LANGUAGE
HAVING COUNT(*) > 1;

/*
** 'WF_ACTIVITY_ATTRIBUTES_PK violations'
*/
SELECT NAME, ACTIVITY_NAME, ACTIVITY_ITEM_TYPE, ACTIVITY_VERSION
FROM   WF_ACTIVITY_ATTRIBUTES 
GROUP BY NAME, ACTIVITY_NAME, ACTIVITY_ITEM_TYPE, ACTIVITY_VERSION
HAVING COUNT(*) > 1;

/*
** 'WF_ACTIVITY_ATTRIBUTES_TL_PK violations'
*/
SELECT NAME, ACTIVITY_NAME, ACTIVITY_ITEM_TYPE, ACTIVITY_VERSION, LANGUAGE
FROM   WF_ACTIVITY_ATTRIBUTES_TL 
GROUP BY NAME, ACTIVITY_NAME, ACTIVITY_ITEM_TYPE, ACTIVITY_VERSION, LANGUAGE
HAVING COUNT(*) > 1;

/*
** 'WF_ACTIVITY_ATTRIBUTES_TL_U2 violations'
*/
SELECT DISPLAY_NAME, ACTIVITY_NAME, ACTIVITY_ITEM_TYPE, ACTIVITY_VERSION,            LANGUAGE
FROM   WF_ACTIVITY_ATTRIBUTES_TL 
GROUP BY DISPLAY_NAME, ACTIVITY_NAME, ACTIVITY_ITEM_TYPE, ACTIVITY_VERSION,            LANGUAGE
HAVING COUNT(*) > 1;

/*
** 'WF_PROCESS_ACTIVITIES_PK violations'
*/
SELECT INSTANCE_ID
FROM   WF_PROCESS_ACTIVITIES 
GROUP BY INSTANCE_ID
HAVING COUNT(*) > 1;

/*
** 'WF_PROCESS_ACTIVITIES_U2 violations'
*/
SELECT INSTANCE_LABEL, PROCESS_NAME, PROCESS_ITEM_TYPE, PROCESS_VERSION
FROM   WF_PROCESS_ACTIVITIES 
GROUP BY INSTANCE_LABEL, PROCESS_NAME, PROCESS_ITEM_TYPE, PROCESS_VERSION
HAVING COUNT(*) > 1;

/*
** 'WF_ACTIVITY_ATTR_VALUES_PK violations'
*/
SELECT PROCESS_ACTIVITY_ID, NAME
FROM   WF_ACTIVITY_ATTR_VALUES 
GROUP BY PROCESS_ACTIVITY_ID, NAME
HAVING COUNT(*) > 1;

/*
** 'WF_ACTIVITY_TRANSITIONS_PK violations'
*/
SELECT FROM_PROCESS_ACTIVITY, RESULT_CODE, TO_PROCESS_ACTIVITY
FROM   WF_ACTIVITY_TRANSITIONS
GROUP BY FROM_PROCESS_ACTIVITY, RESULT_CODE, TO_PROCESS_ACTIVITY
HAVING COUNT(*) > 1;

/*
** 'WF_ITEMS_PK violations'
*/
SELECT ITEM_KEY, ITEM_TYPE
FROM   WF_ITEMS 
GROUP BY ITEM_KEY, ITEM_TYPE
HAVING COUNT(*) > 1;

/*
** 'WF_ITEM_ATTRIBUTE_VALUES_PK violations'
*/
SELECT ITEM_KEY, ITEM_TYPE, NAME
FROM   WF_ITEM_ATTRIBUTE_VALUES 
GROUP BY ITEM_KEY, ITEM_TYPE, NAME
HAVING COUNT(*) > 1;

/*
** '    WF_ITEM_ACTIVITY_STATUSES_PK violations'
*/
SELECT ITEM_KEY, ITEM_TYPE, PROCESS_ACTIVITY
FROM   WF_ITEM_ACTIVITY_STATUSES 
GROUP BY ITEM_KEY, ITEM_TYPE, PROCESS_ACTIVITY
HAVING COUNT(*) > 1;


/*
** 'WF_ACTIVITIES_FK1 violations'
*/
SELECT   WFA.ITEM_TYPE, WFA.NAME
FROM     WF_ACTIVITIES WFA
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ITEM_TYPES WFIT
   WHERE  WFA.ITEM_TYPE = WFIT.NAME);

/*
** 'WF_ACTIVITIES_FK3 violations'
*/
SELECT   WFA.MESSAGE, WFA.ITEM_TYPE
FROM     WF_ACTIVITIES WFA
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_MESSAGES WFM
   WHERE  WFM.NAME = WFA.MESSAGE
   AND    WFM.TYPE = WFA.ITEM_TYPE)
AND    WFA.MESSAGE IS NOT NULL;

/*
** 'WF_ACTIVITY_ATTRIBUTES_FK1 violations'
*/
SELECT   WFAA.ACTIVITY_NAME, WFAA.ACTIVITY_ITEM_TYPE, WFAA.ACTIVITY_VERSION
FROM     WF_ACTIVITY_ATTRIBUTES WFAA
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ACTIVITIES WFA 
   WHERE  WFA.NAME = WFAA.ACTIVITY_NAME
   AND    WFA.ITEM_TYPE = WFAA.ACTIVITY_ITEM_TYPE
   AND    WFA.VERSION = WFAA.ACTIVITY_VERSION);

/*
** 'WF_ACTIVITY_ATTRIBUTES_TL_FK1 violations'
*/
SELECT   WFAATL.NAME, WFAATL.ACTIVITY_NAME, WFAATL.ACTIVITY_ITEM_TYPE, 
         WFAATL.ACTIVITY_VERSION
FROM     WF_ACTIVITY_ATTRIBUTES_TL WFAATL
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ACTIVITY_ATTRIBUTES WFAA
   WHERE  WFAA.NAME = WFAATL.NAME
   AND    WFAA.ACTIVITY_NAME = WFAATL.ACTIVITY_NAME
   AND    WFAA.ACTIVITY_ITEM_TYPE = WFAATL.ACTIVITY_ITEM_TYPE
   AND    WFAA.ACTIVITY_VERSION = WFAATL.ACTIVITY_VERSION);

/*
** 'WF_PROCESS_ACTIVITIES_FK1 violations'
*/
SELECT   WFPA.PROCESS_NAME, WFPA.PROCESS_ITEM_TYPE, WFPA.PROCESS_VERSION
FROM     WF_PROCESS_ACTIVITIES WFPA
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ACTIVITIES WFA 
   WHERE  WFA.NAME = WFPA.PROCESS_NAME
   AND    WFA.ITEM_TYPE = WFPA.PROCESS_ITEM_TYPE
   AND    WFA.VERSION = WFPA.PROCESS_VERSION);


/*
** 'WF_ACTIVITY_ATTR_VALUES_FK1 violations'
*/
SELECT   WFAAV.PROCESS_ACTIVITY_ID
FROM     WF_ACTIVITY_ATTR_VALUES WFAAV
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_PROCESS_ACTIVITIES WFPA
   WHERE  WFPA.INSTANCE_ID = WFAAV.PROCESS_ACTIVITY_ID);

/*
** 'WF_ACTIVITY_TRANSITIONS_FK1 violations'
*/
SELECT   WFAT.FROM_PROCESS_ACTIVITY
FROM     WF_ACTIVITY_TRANSITIONS WFAT
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_PROCESS_ACTIVITIES WFPA
   WHERE  WFPA.INSTANCE_ID = WFAT.FROM_PROCESS_ACTIVITY);

/*
** 'WF_ACTIVITY_TRANSITIONS_FK2 violations'
*/
SELECT   WFAT.TO_PROCESS_ACTIVITY
FROM     WF_ACTIVITY_TRANSITIONS WFAT
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_PROCESS_ACTIVITIES WFPA
   WHERE  WFPA.INSTANCE_ID = WFAT.TO_PROCESS_ACTIVITY);


/*
** 'WF_ITEMS_FK1 violations'
*/
SELECT   WFI.ROOT_ACTIVITY, WFI.ITEM_TYPE, WFI.ROOT_ACTIVITY_VERSION
FROM     WF_ITEMS WFI
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ACTIVITIES WFA
   WHERE  WFA.NAME = WFI.ROOT_ACTIVITY
   AND    WFA.ITEM_TYPE = WFI.ITEM_TYPE
   AND    WFA.VERSION = WFI.ROOT_ACTIVITY_VERSION);

/*
** 'WF_ITEM_ATTRIBUTE_VALUES_FK1 violations'
*/
SELECT   WFIAV.ITEM_KEY, WFIAV.ITEM_TYPE
FROM     WF_ITEM_ATTRIBUTE_VALUES WFIAV
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ITEMS WFI
   WHERE  WFI.ITEM_TYPE = WFIAV.ITEM_TYPE
   AND    WFI.ITEM_KEY  = WFIAV.ITEM_KEY);

/*
** 'WF_ITEM_ACTIVITY_STATUSES_FK1 violations'
*/
SELECT   WFIAS.ITEM_KEY, WFIAS.ITEM_TYPE
FROM     WF_ITEM_ACTIVITY_STATUSES WFIAS
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ITEMS WFI
   WHERE  WFI.ITEM_TYPE = WFIAS.ITEM_TYPE
   AND    WFI.ITEM_KEY  = WFIAS.ITEM_KEY);

/*
** 'WF_ITEM_ACTIVITY_STATUSES_FK2 violations'
*/
SELECT   WFIAS.PROCESS_ACTIVITY
FROM     WF_ITEM_ACTIVITY_STATUSES WFIAS
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_PROCESS_ACTIVITIES WFPA
   WHERE  WFPA.INSTANCE_ID = WFIAS.PROCESS_ACTIVITY);

/*
** 'WF_ITEM_ACTIVITY_STATUSES_FK3 violations'
*/
SELECT   WFIAS.NOTIFICATION_ID
FROM     WF_ITEM_ACTIVITY_STATUSES WFIAS
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_NOTIFICATIONS WFN
   WHERE  WFN.NOTIFICATION_ID = WFIAS.NOTIFICATION_ID)
AND      WFIAS.NOTIFICATION_ID IS NOT NULL;

/*
** 'WF_ITEM_ACTIVITY_STATUS_H_FK1 violations'
*/
SELECT   WFIASH.ITEM_KEY, WFIASH.ITEM_TYPE
FROM     WF_ITEM_ACTIVITY_STATUSES_H WFIASH
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_ITEMS WFI
   WHERE  WFI.ITEM_TYPE = WFIASH.ITEM_TYPE
   AND    WFI.ITEM_KEY = WFIASH.ITEM_KEY);


/*
** 'WF_ITEM_ACTIVITY_STATUS_H_FK2 violations'
*/
SELECT   WFIASH.PROCESS_ACTIVITY
FROM     WF_ITEM_ACTIVITY_STATUSES_H WFIASH
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_PROCESS_ACTIVITIES WFPA
   WHERE  WFPA.INSTANCE_ID = WFIASH.PROCESS_ACTIVITY);

/*
** 'WF_ITEM_ACTIVITY_STATUS_H_FK3 violations'
*/
SELECT   WFIASH.NOTIFICATION_ID
FROM     WF_ITEM_ACTIVITY_STATUSES_H WFIASH
WHERE    NOT EXISTS
  (SELECT 1
   FROM   WF_NOTIFICATIONS WFN
   WHERE  WFN.NOTIFICATION_ID = WFIASH.NOTIFICATION_ID)
AND WFIASH.NOTIFICATION_ID IS NOT NULL;


/*
** Local directory constrainst (Objects in wfdirc.sql)
*/
/*
** 'WF_LOCAL_LANGUAGES_PK violations'
*/
SELECT CODE
FROM   WF_LOCAL_LANGUAGES 
GROUP BY CODE
HAVING COUNT(*) > 1;

/*
** 'WF_LOCAL_LANGUAGES_U1 violations'
*/
SELECT DISPLAY_NAME
FROM   WF_LOCAL_LANGUAGES 
GROUP BY DISPLAY_NAME
HAVING COUNT(*) > 1;

/*
** 'WF_LOCAL_LANGUAGES_U2 violations'
*/
SELECT NLS_LANGUAGE
FROM   WF_LOCAL_LANGUAGES 
GROUP BY NLS_LANGUAGE
HAVING COUNT(*) > 1;

/*
** 'WF_LOCAL_USERS_PK violations' (OBSOLETE)
**SELECT NAME
**FROM   WF_LOCAL_USERS 
**GROUP BY NAME
**HAVING COUNT(*) > 1;
**
**
** 'WF_LOCAL_USERS_U1 violations'
**SELECT DISPLAY_NAME
**FROM   WF_LOCAL_USERS 
**GROUP BY DISPLAY_NAME
**HAVING COUNT(*) > 1;
*/

/*
** 'WF_LOCAL_ROLES_PK violations'
*/
SELECT NAME
FROM   WF_LOCAL_ROLES 
GROUP BY NAME
HAVING COUNT(*) > 1;

/*
** 'WF_LOCAL_ROLES_U1 violations'
*/
SELECT DISPLAY_NAME
FROM   WF_LOCAL_ROLES 
GROUP BY DISPLAY_NAME
HAVING COUNT(*) > 1;

spool off;
