rem HEADER
rem   $Header: wfretry.sql 26.1 2001/11/05 20:14:07 ctilley ship $
rem NAME
rem   wfretry.sql - WorkFlow Handle error'ed activity
rem USAGE
rem   @wfretry <item_type> <item_key>
rem DESCRIPTION
rem   Displays a list of errored activityes for the indicated item.
rem   Type in the name of the activity, and command to skip, retry, or reset.
rem
rem   dbdrv: none

set verify off

define item_type='&1'
define item_key='&2'

prompt  Select from list of error activities
select  pa.instance_label Label,
        ias.activity_result_code Result
from    wf_item_activity_statuses ias,
        wf_process_activities pa
where   ias.item_type = '&item_type'
and     ias.item_key  = '&item_key'
and     ias.process_activity = pa.instance_id
and     ias.activity_status = 'ERROR'
/
accept activity prompt "Label: "

prompt SKIP, RETRY or RESET activity? 
accept comflag prompt "Command: "

prompt Result of activity if command is SKIP
accept result prompt "Result: "

begin
    Wf_Engine.HandleError('&item_type', '&item_key', '&activity', 
                          '&comflag', '&result');
end;
/
set verify on

commit;
exit;
