/* $Header: wfsdupld.sql 26.4 2001/11/05 20:20:48 ctilley ship $ */
/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wfsdupld.sql
 |
 | DESCRIPTION
 |   Uploads Event System Seeddata XML File	
 |   Parameter 1: Directory:          <ORACLE_HOME>/wf/res 
 |   Parameter 2: Filename Override : <can leave null> 
 |
 |
 | NOTES
 *=======================================================================*/

rem  dbdrv: none

whenever sqlerror exit failure rollback;
set verify off
--
define directory='&1'
define filename='&2'
--
declare
  l_directory 		varchar2(240) := '&DIRECTORY';
  l_filename		varchar2(240) := nvl('&FILENAME','wfevt.xml');
begin
  -- Set the NLS_LANGUAGE
  dbms_session.set_nls('NLS_LANGUAGE','AMERICAN');

  wf_event_synchronize_pkg.uploadfile(l_directory, l_filename);
end;
/
commit;
exit;
