/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.driver.VarnumAccessor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public abstract class OracleStatement
implements oracle.jdbc.internal.OracleStatement,
ScrollRsetStatement {
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    static final byte IS_UNINITIALIZED = -1;
    static final byte IS_SELECT = 0;
    static final byte IS_PLSQL_BLOCK = 1;
    static final byte IS_DML = 2;
    static final byte IS_OTHER = 3;
    static final byte IS_CALL_BLOCK = 4;
    int cursorId;
    int numberOfDefinePositions;
    int definesBatchSize;
    Accessor[] accessors;
    int defineByteSubRange;
    int defineCharSubRange;
    int defineIndicatorSubRange;
    int defineLengthSubRange;
    byte[] defineBytes;
    char[] defineChars;
    short[] defineIndicators;
    boolean described = false;
    boolean describedWithNames = false;
    int rowsProcessed;
    int cachedDefineByteSize = 0;
    int cachedDefineCharSize = 0;
    int cachedDefineIndicatorSize = 0;
    OracleStatement children;
    OracleStatement nextChild;
    OracleStatement next;
    OracleStatement prev;
    long c_state;
    int numberOfBindPositions;
    byte[] bindBytes;
    char[] bindChars;
    short[] bindIndicators;
    int bindByteOffset;
    int bindCharOffset;
    int bindIndicatorOffset;
    int bindByteSubRange;
    int bindCharSubRange;
    int bindIndicatorSubRange;
    Accessor[] outBindAccessors;
    InputStream[][] parameterStream;
    int firstRowInBatch;
    boolean hasIbtBind = false;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    int ibtBindByteOffset;
    int ibtBindCharOffset;
    int ibtBindIndicatorOffset;
    int ibtBindIndicatorSize;
    byte[] tmpByteArray;
    int sizeTmpByteArray = 0;
    byte[] tmpBindsByteArray;
    boolean needToSendOalToFetch = false;
    int[] definedColumnType = null;
    int[] definedColumnSize = null;
    int[] definedColumnFormOfUse = null;
    T4CTTIoac[] oacdefSent = null;
    int[] nbPostPonedColumns = null;
    int[][] indexOfPostPonedColumn = null;
    int accessorByteOffset = 0;
    int accessorCharOffset = 0;
    int accessorShortOffset = 0;
    static final int VALID_ROWS_UNINIT = -999;
    PhysicalConnection connection;
    OracleInputStream streamList;
    OracleInputStream nextStream;
    OracleResultSetImpl currentResultSet;
    boolean processEscapes;
    boolean convertNcharLiterals;
    int queryTimeout;
    int batch;
    int currentRank;
    int currentRow;
    int validRows;
    int maxFieldSize;
    int maxRows;
    int totalRowsVisited;
    int rowPrefetch;
    int rowPrefetchInLastFetch = -1;
    int defaultRowPrefetch;
    boolean rowPrefetchChanged;
    boolean gotLastBatch;
    boolean clearParameters;
    boolean closed;
    boolean sqlStringChanged;
    OracleSql sqlObject;
    boolean needToParse;
    boolean needToPrepareDefineBuffer;
    boolean columnsDefinedByUser;
    byte sqlKind;
    int autoRollback;
    int defaultFetchDirection;
    boolean autoRefetch;
    boolean serverCursor;
    boolean fixedString = false;
    boolean noMoreUpdateCounts = false;
    boolean isExecuting = false;
    static final byte EXECUTE_NONE = -1;
    static final byte EXECUTE_QUERY = 1;
    static final byte EXECUTE_UPDATE = 2;
    static final byte EXECUTE_NORMAL = 3;
    byte executionType = (byte)-1;
    OracleResultSet scrollRset;
    oracle.jdbc.OracleResultSetCache rsetCache;
    int userRsetType;
    int realRsetType;
    boolean needToAddIdentifier;
    SQLWarning sqlWarning;
    int cacheState = 1;
    int creationState = 0;
    boolean isOpen = false;
    int statementType = 0;
    boolean columnSetNull = false;
    int[] returnParamMeta;
    static final int DMLR_METADATA_PREFIX_SIZE = 3;
    static final int DMLR_METADATA_NUM_OF_RETURN_PARAMS = 0;
    static final int DMLR_METADATA_ROW_BIND_BYTES = 1;
    static final int DMLR_METADATA_ROW_BIND_CHARS = 2;
    static final int DMLR_METADATA_TYPE_OFFSET = 0;
    static final int DMLR_METADATA_IS_CHAR_TYPE_OFFSET = 1;
    static final int DMLR_METADATA_BIND_SIZE_OFFSET = 2;
    static final int DMLR_METADATA_PER_POSITION_SIZE = 3;
    Accessor[] returnParamAccessors;
    boolean returnParamsFetched;
    int rowsDmlReturned;
    int numReturnParams;
    byte[] returnParamBytes;
    char[] returnParamChars;
    short[] returnParamIndicators;
    int returnParamRowBytes;
    int returnParamRowChars;
    OracleReturnResultSet returnResultSet;
    boolean isAutoGeneratedKey;
    AutoKeyInfo autoKeyInfo;
    TimeZone defaultTZ = null;
    Calendar defaultCalendar = null;
    int lastIndex;
    Vector m_batchItems = new Vector();
    ArrayList tempClobsToFree = null;
    ArrayList tempBlobsToFree = null;
    ArrayList oldTempClobsToFree = null;
    ArrayList oldTempBlobsToFree = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:36:25_PST_2008";

    OracleStatement(PhysicalConnection physicalConnection, int n, int n2) throws SQLException {
        this(physicalConnection, n, n2, -1, -1);
    }

    OracleStatement(PhysicalConnection physicalConnection, int n, int n2, int n3, int n4) throws SQLException {
        this.connection = physicalConnection;
        this.connection.needLine();
        this.connection.registerHeartbeat();
        this.connection.addStatement(this);
        this.sqlObject = new OracleSql(this.connection.conversion);
        this.sqlObject.isV8Compatible = this.connection.v8Compatible;
        this.processEscapes = this.connection.processEscapes;
        this.convertNcharLiterals = this.connection.convertNcharLiterals;
        this.autoRollback = 2;
        this.gotLastBatch = false;
        this.closed = false;
        this.clearParameters = true;
        this.serverCursor = false;
        this.needToAddIdentifier = false;
        this.defaultFetchDirection = 1000;
        this.fixedString = this.connection.getDefaultFixedString();
        this.rowPrefetchChanged = false;
        this.rowPrefetch = n2;
        this.defaultRowPrefetch = n2;
        this.batch = n;
        this.autoRefetch = this.connection.getDefaultAutoRefetch();
        this.sqlStringChanged = true;
        this.needToParse = true;
        this.needToPrepareDefineBuffer = true;
        this.columnsDefinedByUser = false;
        if (n3 != -1 || n4 != -1) {
            this.realRsetType = 0;
            this.userRsetType = ResultSetUtil.getRsetTypeCode(n3, n4);
            this.needToAddIdentifier = ResultSetUtil.needIdentifier(this.userRsetType);
        } else {
            this.userRsetType = 1;
            this.realRsetType = 1;
        }
    }

    public synchronized void addBatch(String string) throws SQLException {
        this.addBatchItem(string);
    }

    void addBatchItem(String string) {
        this.m_batchItems.addElement(string);
    }

    void addChild(OracleStatement oracleStatement) {
        oracleStatement.nextChild = this.children;
        this.children = oracleStatement;
    }

    void addToOldTempLobsToFree(BLOB bLOB) {
        if (this.oldTempBlobsToFree == null) {
            this.oldTempBlobsToFree = new ArrayList();
        }
        this.oldTempBlobsToFree.add(bLOB);
    }

    void addToOldTempLobsToFree(CLOB cLOB) {
        if (this.oldTempClobsToFree == null) {
            this.oldTempClobsToFree = new ArrayList();
        }
        this.oldTempClobsToFree.add(cLOB);
    }

    void addToTempLobsToFree(BLOB bLOB) {
        if (this.tempBlobsToFree == null) {
            this.tempBlobsToFree = new ArrayList();
        }
        this.tempBlobsToFree.add(bLOB);
    }

    void addToTempLobsToFree(CLOB cLOB) {
        if (this.tempClobsToFree == null) {
            this.tempClobsToFree = new ArrayList();
        }
        this.tempClobsToFree.add(cLOB);
    }

    void adjustGotLastBatch() {
    }

    Accessor allocateAccessor(int n, int n2, int n3, int n4, short s, String string, boolean bl) throws SQLException {
        switch (n) {
            case 96: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new CharAccessor(this, n4, s, n2, bl);
            }
            case 8: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (!bl) {
                    return new LongAccessor(this, n3, n4, s, n2);
                }
            }
            case 1: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new VarcharAccessor(this, n4, s, n2, bl);
            }
            case 2: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new NumberAccessor(this, n4, s, n2, bl);
            }
            case 6: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new VarnumAccessor(this, n4, s, n2, bl);
            }
            case 24: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (!bl) {
                    return new LongRawAccessor(this, n3, n4, s, n2);
                }
            }
            case 23: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (bl) {
                    return new OutRawAccessor(this, n4, s, n2);
                }
                return new RawAccessor(this, n4, s, n2, false);
            }
            case 100: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BinaryFloatAccessor(this, n4, s, n2, bl);
            }
            case 101: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BinaryDoubleAccessor(this, n4, s, n2, bl);
            }
            case 104: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new RowidAccessor(this, n4, s, n2, bl);
            }
            case 102: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new ResultSetAccessor(this, n4, s, n2, bl);
            }
            case 12: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new DateAccessor(this, n4, s, n2, bl);
            }
            case 113: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BlobAccessor(this, n4, s, n2, bl);
            }
            case 112: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new ClobAccessor(this, n4, s, n2, bl);
            }
            case 114: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BfileAccessor(this, n4, s, n2, bl);
            }
            case 109: {
                if (string == null) {
                    if (bl) {
                        DatabaseError.throwSqlException(12, "sqlType=" + n2);
                    } else {
                        DatabaseError.throwSqlException(60, "Unable to resolve type \"null\"");
                    }
                }
                NamedTypeAccessor namedTypeAccessor = new NamedTypeAccessor(this, string, s, n2, bl);
                ((Accessor)namedTypeAccessor).initMetadata();
                return namedTypeAccessor;
            }
            case 111: {
                if (string == null) {
                    if (bl) {
                        DatabaseError.throwSqlException(12, "sqlType=" + n2);
                    } else {
                        DatabaseError.throwSqlException(60, "Unable to resolve type \"null\"");
                    }
                }
                RefTypeAccessor refTypeAccessor = new RefTypeAccessor(this, string, s, n2, bl);
                ((Accessor)refTypeAccessor).initMetadata();
                return refTypeAccessor;
            }
            case 180: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (this.connection.v8Compatible) {
                    return new DateAccessor(this, n4, s, n2, bl);
                }
                return new TimestampAccessor(this, n4, s, n2, bl);
            }
            case 181: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new TimestamptzAccessor(this, n4, s, n2, bl);
            }
            case 231: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new TimestampltzAccessor(this, n4, s, n2, bl);
            }
            case 182: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new IntervalymAccessor(this, n4, s, n2, bl);
            }
            case 183: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new IntervaldsAccessor(this, n4, s, n2, bl);
            }
            case 995: {
                DatabaseError.throwSqlException(89);
            }
        }
        DatabaseError.throwSqlException(4);
        return null;
    }

    void allocateDmlReturnStorage() {
        if (this.rowsDmlReturned == 0) {
            return;
        }
        int n = this.returnParamRowBytes * this.rowsDmlReturned;
        int n2 = this.returnParamRowChars * this.rowsDmlReturned;
        int n3 = 2 * this.numReturnParams * this.rowsDmlReturned;
        this.returnParamBytes = new byte[n];
        this.returnParamChars = new char[n2];
        this.returnParamIndicators = new short[n3];
        int n4 = 0;
        while (n4 < this.numberOfBindPositions) {
            Accessor accessor = this.returnParamAccessors[n4];
            if (accessor != null && (accessor.internalType == 111 || accessor.internalType == 109)) {
                TypeAccessor typeAccessor = (TypeAccessor)accessor;
                if (typeAccessor.pickledBytes == null || typeAccessor.pickledBytes.length < this.rowsDmlReturned) {
                    typeAccessor.pickledBytes = new byte[this.rowsDmlReturned][];
                }
            }
            ++n4;
        }
    }

    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new RowidAccessor(this, 128, 1, -8, false);
    }

    void allocateTmpByteArray() {
    }

    protected void alwaysOnClose() throws SQLException {
        OracleStatement oracleStatement = this.children;
        while (oracleStatement != null) {
            OracleStatement oracleStatement2 = oracleStatement.nextChild;
            oracleStatement.close();
            oracleStatement = oracleStatement2;
        }
        this.closed = true;
        if (!this.connection.isClosed()) {
            this.connection.needLine();
            if (this.currentResultSet != null) {
                this.currentResultSet.internal_close(false);
                this.currentResultSet = null;
            }
            if (this.scrollRset != null) {
                this.scrollRset.close();
                this.scrollRset = null;
            }
            if (this.returnResultSet != null) {
                this.returnResultSet.close();
                this.returnResultSet = null;
            }
        }
        this.clearWarnings();
        this.m_batchItems = null;
    }

    private void autoKeyRegisterReturnParams() throws SQLException {
        this.initializeIndicatorSubRange();
        int n = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
        int n2 = n + 2 * this.numberOfBindPositions;
        this.bindIndicators = new short[n2];
        int n3 = this.bindIndicatorSubRange;
        this.bindIndicators[n3] = (short)this.numberOfBindPositions;
        this.bindIndicators[n3 + 1] = 0;
        this.bindIndicators[n3 + 2] = 1;
        this.bindIndicators[n3 + 3] = 0;
        this.bindIndicators[n3 + 4] = 1;
        n3 += 5;
        short[] sArray = this.autoKeyInfo.tableFormOfUses;
        int[] nArray = this.autoKeyInfo.columnIndexes;
        int n4 = 0;
        while (n4 < this.numberOfBindPositions) {
            this.bindIndicators[n3] = 994;
            short s = 0;
            if (sArray != null && nArray != null && sArray[nArray[n4] - 1] == 2) {
                this.bindIndicators[n3 + 9] = s = 2;
            }
            n3 += 10;
            this.checkTypeForAutoKey(this.autoKeyInfo.returnTypes[n4]);
            String string = null;
            if (this.autoKeyInfo.returnTypes[n4] == 111) {
                string = this.autoKeyInfo.tableTypeNames[nArray[n4] - 1];
            }
            this.registerReturnParameterInternal(n4, this.autoKeyInfo.returnTypes[n4], this.autoKeyInfo.returnTypes[n4], -1, s, string);
            ++n4;
        }
    }

    public void cancel() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.connection.statementHoldingLine != null) {
            this.freeLine();
        } else if (this.isExecuting) {
            this.connection.doCancel();
        }
        this.connection.releaseLineForCancel();
    }

    boolean checkAccessorsUsable() throws SQLException {
        int n = this.accessors.length;
        if (n < this.numberOfDefinePositions) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < this.numberOfDefinePositions) {
            Accessor accessor = this.accessors[n2];
            if (accessor == null || accessor.externalType == 0) {
                bl = false;
            } else {
                bl2 = true;
            }
            ++n2;
        }
        if (bl) {
            bl3 = true;
        } else if (bl2) {
            DatabaseError.throwSqlException(21);
        } else {
            this.columnsDefinedByUser = false;
        }
        return bl3;
    }

    void checkIfJdbcBatchExists() throws SQLException {
        if (this.getBatchSize() > 0) {
            DatabaseError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    final void checkTypeForAutoKey(int n) throws SQLException {
        if (n == 109) {
            DatabaseError.throwSqlException(5);
        }
    }

    void checkValidRowsStatus() throws SQLException {
        if (this.validRows == -2) {
            this.validRows = 1;
            this.connection.holdLine(this);
            OracleInputStream oracleInputStream = this.streamList;
            while (oracleInputStream != null) {
                if (oracleInputStream.hasBeenOpen) {
                    oracleInputStream = oracleInputStream.accessor.initForNewRow();
                }
                oracleInputStream.closed = false;
                oracleInputStream.hasBeenOpen = true;
                oracleInputStream = oracleInputStream.nextStream;
            }
            this.nextStream = this.streamList;
        } else if (this.sqlKind == 0) {
            if (this.validRows < this.rowPrefetch) {
                this.gotLastBatch = true;
            }
        } else if (this.sqlKind != 1 && this.sqlKind != 4) {
            this.rowsProcessed = this.validRows;
        }
    }

    void check_row_prefetch_changed() throws SQLException {
        if (this.rowPrefetchChanged) {
            if (this.streamList == null) {
                this.prepareAccessors();
                this.needToPrepareDefineBuffer = true;
            }
            this.rowPrefetchChanged = false;
        }
    }

    void cleanAllTempLobs() {
        this.cleanTempClobs(this.tempClobsToFree);
        this.tempClobsToFree = null;
        this.cleanTempBlobs(this.tempBlobsToFree);
        this.tempBlobsToFree = null;
        this.cleanTempClobs(this.oldTempClobsToFree);
        this.oldTempClobsToFree = null;
        this.cleanTempBlobs(this.oldTempBlobsToFree);
        this.oldTempBlobsToFree = null;
    }

    void cleanOldTempLobs() {
        this.cleanTempClobs(this.oldTempClobsToFree);
        this.cleanTempBlobs(this.oldTempBlobsToFree);
        this.oldTempClobsToFree = this.tempClobsToFree;
        this.tempClobsToFree = null;
        this.oldTempBlobsToFree = this.tempBlobsToFree;
        this.tempBlobsToFree = null;
    }

    void cleanTempBlobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                try {
                    ((BLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    void cleanTempClobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                try {
                    ((CLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    void cleanupDefines() {
        if (this.accessors != null) {
            int n = 0;
            while (n < this.accessors.length) {
                this.accessors[n] = null;
                ++n;
            }
        }
        this.accessors = null;
        if (this.defineBytes != null) {
            this.defineBytes = null;
        }
        if (this.defineChars != null) {
            this.defineChars = null;
        }
        if (this.defineIndicators != null) {
            this.defineIndicators = null;
        }
    }

    public synchronized void clearBatch() throws SQLException {
        this.clearBatchItems();
    }

    void clearBatchItems() {
        this.m_batchItems.removeAllElements();
    }

    public synchronized void clearDefines() throws SQLException {
        this.freeLine();
        this.streamList = null;
        this.columnsDefinedByUser = false;
        this.needToPrepareDefineBuffer = true;
        this.numberOfDefinePositions = 0;
        this.definesBatchSize = 0;
        this.described = false;
        this.describedWithNames = false;
        this.cleanupDefines();
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.closeOrCache(null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void closeLeaveCursorOpen() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (this.closed) {
                    return;
                }
                this.hardClose(false);
            }
            return;
        }
    }

    protected void closeOrCache(String string) throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.statementType != 0 && this.cacheState != 0 && this.cacheState != 3 && this.connection.isStatementCacheInitialized()) {
            if (string == null) {
                if (this.connection.getImplicitCachingEnabled()) {
                    this.connection.cacheImplicitStatement((OraclePreparedStatement)this, this.sqlObject.getOriginalSql(), this.statementType, this.userRsetType);
                } else {
                    this.cacheState = 0;
                    this.hardClose();
                }
            } else if (this.connection.getExplicitCachingEnabled()) {
                this.connection.cacheExplicitStatement((OraclePreparedStatement)this, string);
            } else {
                this.cacheState = 0;
                this.hardClose();
            }
        } else {
            this.hardClose();
        }
    }

    abstract void closeQuery() throws SQLException;

    void closeUsedStreams(int n) throws SQLException {
        while (this.nextStream != null && this.nextStream.columnIndex < n) {
            try {
                this.nextStream.close();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
            this.nextStream = this.nextStream.nextStream;
        }
    }

    public void closeWithKey(String string) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    void continueReadRow(int n) throws SQLException {
        throw new SQLException("continueReadRow is only implemented by the T4C statements.");
    }

    public int copyBinds(Statement statement, int n) throws SQLException {
        return 0;
    }

    public synchronized int creationState() {
        return this.creationState;
    }

    public synchronized void defineColumnType(int n, int n2) throws SQLException {
        this.defineColumnTypeInternal(n, n2, 0, true, null);
    }

    public void defineColumnType(int n, int n2, int n3) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, false, null);
    }

    public void defineColumnType(int n, int n2, int n3, short s) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, s, false, null);
    }

    public void defineColumnType(int n, int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.defineColumnTypeInternal(n, n2, 0, true, string);
            }
        }
    }

    public synchronized void defineColumnTypeBytes(int n, int n2, int n3) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, false, null);
    }

    public void defineColumnTypeChars(int n, int n2, int n3) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, false, null);
    }

    void defineColumnTypeInternal(int n, int n2, int n3, short s, boolean bl, String string) throws SQLException {
        int n4;
        if (this.connection.disableDefineColumnType) {
            return;
        }
        if (n < 1) {
            DatabaseError.throwSqlException(3);
        }
        if (n2 == 0) {
            DatabaseError.throwSqlException(4);
        }
        int n5 = n - 1;
        int n6 = this.maxFieldSize;
        if (bl) {
            if (n2 == 1 || n2 == 12) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
            }
        } else {
            if (n3 < 0) {
                DatabaseError.throwSqlException(53);
            }
            if (n6 == 0 || n3 < n6) {
                n6 = n3;
            }
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            DatabaseError.throwSqlException(28);
        }
        if (!this.columnsDefinedByUser) {
            this.clearDefines();
            this.columnsDefinedByUser = true;
        }
        if (this.numberOfDefinePositions < n) {
            if (this.accessors == null || this.accessors.length < n) {
                Accessor[] accessorArray = new Accessor[n << 1];
                if (this.accessors != null) {
                    System.arraycopy(this.accessors, 0, accessorArray, 0, this.numberOfDefinePositions);
                }
                this.accessors = accessorArray;
            }
            this.numberOfDefinePositions = n;
        }
        if (!((n4 = this.getInternalType(n2)) != 109 && n4 != 111 || string != null && !string.equals(""))) {
            DatabaseError.throwSqlException(60, "Invalid arguments");
        }
        Accessor accessor = this.accessors[n5];
        boolean bl2 = true;
        if (accessor != null) {
            int n7 = accessor.useForDataAccessIfPossible(n4, n2, n6, string);
            if (n7 == 0) {
                s = accessor.formOfUse;
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n7 == 1) {
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n7 == 2) {
                bl2 = false;
            }
        }
        if (bl2) {
            this.needToPrepareDefineBuffer = true;
        }
        if (accessor == null) {
            this.accessors[n5] = this.allocateAccessor(n4, n2, n, n6, s, string, false);
            this.described = false;
            this.describedWithNames = false;
        }
    }

    void defineColumnTypeInternal(int n, int n2, int n3, boolean bl, String string) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, (short)1, bl, string);
    }

    void describe() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (!this.described) {
                    this.doDescribe(false);
                }
            }
        }
    }

    abstract void doClose() throws SQLException;

    abstract void doDescribe(boolean var1) throws SQLException;

    void doExecuteWithTimeout() throws SQLException {
        block19: {
            try {
                block20: {
                    this.cleanOldTempLobs();
                    this.connection.registerHeartbeat();
                    this.rowsProcessed = 0;
                    if (this.sqlKind == 0) {
                        if (this.connection.j2ee13Compliant && this.executionType == 2) {
                            DatabaseError.throwSqlException(129);
                        }
                        this.connection.needLine();
                        if (!this.isOpen) {
                            this.connection.open(this);
                            this.isOpen = true;
                        }
                        if (this.queryTimeout != 0) {
                            try {
                                this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                                this.executeMaybeDescribe();
                            }
                            finally {
                                Object var2_1 = null;
                                this.connection.getTimeout().cancelTimeout();
                            }
                        } else {
                            this.executeMaybeDescribe();
                        }
                        this.checkValidRowsStatus();
                        if (this.serverCursor) {
                            this.adjustGotLastBatch();
                        }
                        break block19;
                    }
                    if (this.connection.j2ee13Compliant && this.sqlKind != 1 && this.sqlKind != 4 && this.executionType == 1) {
                        DatabaseError.throwSqlException(128);
                    }
                    ++this.currentRank;
                    if (this.currentRank < this.batch) break block19;
                    try {
                        try {
                            this.connection.needLine();
                            if (!this.isOpen) {
                                this.connection.open(this);
                                this.isOpen = true;
                            }
                            if (this.queryTimeout != 0) {
                                this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                            }
                            this.isExecuting = true;
                            this.executeForRows(false);
                        }
                        catch (SQLException sQLException) {
                            this.needToParse = true;
                            this.resetCurrentRowBinders();
                            throw sQLException;
                        }
                        Object var2_3 = null;
                        if (this.queryTimeout == 0) break block20;
                    }
                    catch (Throwable throwable) {
                        Object var2_4 = null;
                        if (this.queryTimeout != 0) {
                            this.connection.getTimeout().cancelTimeout();
                        }
                        this.currentRank = 0;
                        this.isExecuting = false;
                        this.checkValidRowsStatus();
                        throw throwable;
                    }
                    this.connection.getTimeout().cancelTimeout();
                }
                this.currentRank = 0;
                this.isExecuting = false;
                this.checkValidRowsStatus();
            }
            catch (SQLException sQLException) {
                this.resetOnExceptionDuringExecute();
                throw sQLException;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void doScrollExecuteCommon() throws SQLException {
        block13: {
            if (this.scrollRset != null) {
                this.scrollRset.close();
                this.scrollRset = null;
            }
            if (this.sqlKind != 0) {
                this.doExecuteWithTimeout();
                return;
            }
            if (!this.needToAddIdentifier) {
                this.doExecuteWithTimeout();
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.realRsetType = this.userRsetType;
            } else {
                block14: {
                    try {
                        this.sqlObject.setIncludeRowid(true);
                        this.needToParse = true;
                        this.prepareForNewResults(true, false);
                        if (this.columnsDefinedByUser) {
                            var1_1 = this.accessors;
                            if (this.accessors == null || this.accessors.length <= this.numberOfDefinePositions) {
                                this.accessors = new Accessor[this.numberOfDefinePositions + 1];
                            }
                            if (var1_1 != null) {
                                var2_3 = this.numberOfDefinePositions;
                                while (var2_3 > 0) {
                                    this.accessors[var2_3] = var3_5 = var1_1[var2_3 - 1];
                                    if (var3_5.isColumnNumberAware) {
                                        var3_5.updateColumnNumber(var2_3);
                                    }
                                    --var2_3;
                                }
                            }
                            this.allocateRowidAccessor();
                            ++this.numberOfDefinePositions;
                        }
                        this.doExecuteWithTimeout();
                        this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                        this.realRsetType = this.userRsetType;
                        break block13;
                    }
                    catch (SQLException var1_2) {
                        this.realRsetType = this.userRsetType > 3 ? 3 : 1;
                        this.sqlObject.setIncludeRowid(false);
                        this.needToParse = true;
                        this.prepareForNewResults(true, false);
                        if (!this.columnsDefinedByUser) break block14;
                        this.needToPrepareDefineBuffer = true;
                        --this.numberOfDefinePositions;
                        System.arraycopy(this.accessors, 1, this.accessors, 0, this.numberOfDefinePositions);
                        this.accessors[this.numberOfDefinePositions] = null;
                        var2_4 = 0;
                        ** while (var2_4 < this.numberOfDefinePositions)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var3_6 = this.accessors[var2_4];
                        if (var3_6.isColumnNumberAware) {
                            var3_6.updateColumnNumber(var2_4);
                        }
                        ++var2_4;
                        continue;
                    }
                }
                this.doExecuteWithTimeout();
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 91, var1_2.getMessage());
            }
        }
        this.scrollRset = ResultSetUtil.createScrollResultSet(this, this.currentResultSet, this.realRsetType);
    }

    OracleResultSet doScrollStmtExecuteQuery() throws SQLException {
        this.doScrollExecuteCommon();
        return this.scrollRset;
    }

    void endOfResultSet(boolean bl) throws SQLException {
        if (!bl) {
            this.prepareForNewResults(false, false);
        }
        this.clearDefines();
        this.rowPrefetchInLastFetch = -1;
    }

    final void ensureOpen() throws SQLException {
        if (this.connection.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.setNonAutoKey();
                return this.executeInternal(string);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(String string, int n) throws SQLException {
        if (n == 2) return this.execute(string);
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.execute(string);
        }
        if (n != 1) {
            DatabaseError.throwSqlException(68);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(string);
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = 1;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                return this.executeInternal(string2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.execute(string);
        }
        if (nArray == null || nArray.length == 0) {
            DatabaseError.throwSqlException(68);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(string, nArray);
                this.connection.doDescribeTable(this.autoKeyInfo);
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = nArray.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                return this.executeInternal(string2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.execute(string);
        }
        if (stringArray == null || stringArray.length == 0) {
            DatabaseError.throwSqlException(68);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(string, stringArray);
                this.connection.doDescribeTable(this.autoKeyInfo);
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = stringArray.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                return this.executeInternal(string2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                int[] nArray;
                block25: {
                    this.cleanOldTempLobs();
                    int n = 0;
                    int n2 = this.getBatchSize();
                    if (n2 <= 0) {
                        return new int[0];
                    }
                    nArray = new int[n2];
                    this.ensureOpen();
                    this.prepareForNewResults(true, true);
                    int n3 = this.numberOfDefinePositions;
                    String string = this.sqlObject.getOriginalSql();
                    byte by = this.sqlKind;
                    this.noMoreUpdateCounts = false;
                    int n4 = 0;
                    try {
                        try {
                            this.connection.registerHeartbeat();
                            this.connection.needLine();
                            n = 0;
                            while (n < n2) {
                                int n5;
                                block24: {
                                    Object var17_16;
                                    this.sqlObject.initialize(this.getBatchItem(n));
                                    this.sqlKind = this.sqlObject.getSqlKind();
                                    this.needToParse = true;
                                    this.numberOfDefinePositions = 0;
                                    this.rowsProcessed = 0;
                                    this.currentRank = 1;
                                    if (this.sqlKind == 0) {
                                        DatabaseError.throwBatchUpdateException(80, "invalid SELECT batch command " + n, n, nArray);
                                    }
                                    if (!this.isOpen) {
                                        this.connection.open(this);
                                        this.isOpen = true;
                                    }
                                    n5 = -1;
                                    try {
                                        try {
                                            if (this.queryTimeout != 0) {
                                                this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                                            }
                                            this.isExecuting = true;
                                            this.executeForRows(false);
                                            if (this.validRows > 0) {
                                                n4 += this.validRows;
                                            }
                                            n5 = this.validRows;
                                        }
                                        catch (SQLException sQLException) {
                                            this.needToParse = true;
                                            this.resetCurrentRowBinders();
                                            throw sQLException;
                                        }
                                        var17_16 = null;
                                        if (this.queryTimeout == 0) break block24;
                                    }
                                    catch (Throwable throwable) {
                                        var17_16 = null;
                                        if (this.queryTimeout != 0) {
                                            this.connection.getTimeout().cancelTimeout();
                                        }
                                        this.validRows = n4;
                                        this.checkValidRowsStatus();
                                        this.isExecuting = false;
                                        throw throwable;
                                    }
                                    this.connection.getTimeout().cancelTimeout();
                                }
                                this.validRows = n4;
                                this.checkValidRowsStatus();
                                this.isExecuting = false;
                                nArray[n] = n5;
                                if (nArray[n] < 0) {
                                    DatabaseError.throwBatchUpdateException(81, "command return value " + nArray[n], n, nArray);
                                }
                                ++n;
                            }
                        }
                        catch (SQLException sQLException) {
                            if (sQLException instanceof BatchUpdateException) {
                                throw sQLException;
                            }
                            DatabaseError.throwBatchUpdateException(81, sQLException.getMessage(), n, nArray);
                        }
                        Object var14_21 = null;
                        this.clearBatchItems();
                        this.numberOfDefinePositions = n3;
                        if (string == null) break block25;
                    }
                    catch (Throwable throwable) {
                        Object var14_22 = null;
                        this.clearBatchItems();
                        this.numberOfDefinePositions = n3;
                        if (string != null) {
                            this.sqlObject.initialize(string);
                            this.sqlKind = by;
                        }
                        this.currentRank = 0;
                        throw throwable;
                    }
                    this.sqlObject.initialize(string);
                    this.sqlKind = by;
                }
                this.currentRank = 0;
                this.connection.registerHeartbeat();
                return nArray;
            }
        }
    }

    abstract void executeForDescribe() throws SQLException;

    abstract void executeForRows(boolean var1) throws SQLException;

    boolean executeInternal(String string) throws SQLException {
        boolean bl;
        try {
            this.executionType = (byte)3;
            this.noMoreUpdateCounts = false;
            this.ensureOpen();
            this.checkIfJdbcBatchExists();
            this.sendBatch();
            this.sqlObject.initialize(string);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.needToParse = true;
            this.prepareForNewResults(true, true);
            if (this.userRsetType == 1) {
                this.doExecuteWithTimeout();
            } else {
                this.doScrollStmtExecuteQuery();
            }
            bl = this.sqlKind == 0;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.executionType = (byte)-1;
            throw throwable;
        }
        this.executionType = (byte)-1;
        return bl;
    }

    void executeMaybeDescribe() throws SQLException {
        if (this.rowPrefetchChanged) {
            if (this.streamList == null && this.rowPrefetch != this.definesBatchSize) {
                this.needToPrepareDefineBuffer = true;
            }
            this.rowPrefetchChanged = false;
        }
        if (!this.needToPrepareDefineBuffer) {
            if (this.accessors == null) {
                this.needToPrepareDefineBuffer = true;
            } else if (this.columnsDefinedByUser) {
                this.needToPrepareDefineBuffer = this.checkAccessorsUsable() ^ true;
            }
        }
        boolean bl = false;
        try {
            try {
                this.isExecuting = true;
                if (this.needToPrepareDefineBuffer) {
                    if (!this.columnsDefinedByUser) {
                        this.executeForDescribe();
                        bl = true;
                    }
                    this.prepareAccessors();
                }
                int n = this.accessors.length;
                int n2 = this.numberOfDefinePositions;
                while (n2 < n) {
                    Accessor accessor = this.accessors[n2];
                    if (accessor != null) {
                        accessor.rowSpaceIndicator = null;
                    }
                    ++n2;
                }
                this.executeForRows(bl);
            }
            catch (SQLException sQLException) {
                this.needToParse = true;
                throw sQLException;
            }
            Object var3_6 = null;
            this.isExecuting = false;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.isExecuting = false;
            throw throwable;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        OracleResultSet oracleResultSet = null;
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                block9: {
                    try {
                        this.executionType = 1;
                        this.noMoreUpdateCounts = false;
                        this.ensureOpen();
                        this.checkIfJdbcBatchExists();
                        this.sendBatch();
                        this.sqlObject.initialize(string);
                        this.sqlKind = this.sqlObject.getSqlKind();
                        this.needToParse = true;
                        this.prepareForNewResults(true, true);
                        if (this.userRsetType == 1) {
                            this.doExecuteWithTimeout();
                            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                            oracleResultSet = this.currentResultSet;
                            break block9;
                        }
                        oracleResultSet = this.doScrollStmtExecuteQuery();
                        if (oracleResultSet != null) break block9;
                        this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                        oracleResultSet = this.currentResultSet;
                    }
                    catch (Throwable throwable) {
                        Object var8_6 = null;
                        this.executionType = (byte)-1;
                        throw throwable;
                    }
                }
                Object var8_5 = null;
                this.executionType = (byte)-1;
            }
        }
        return oracleResultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.setNonAutoKey();
                return this.executeUpdateInternal(string);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate(String string, int n) throws SQLException {
        if (n == 2) return this.executeUpdate(string);
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.executeUpdate(string);
        }
        if (n != 1) {
            DatabaseError.throwSqlException(68);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(string);
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = 1;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                return this.executeUpdateInternal(string2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.executeUpdate(string);
        }
        if (nArray == null || nArray.length == 0) {
            DatabaseError.throwSqlException(68);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(string, nArray);
                this.connection.doDescribeTable(this.autoKeyInfo);
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = nArray.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                return this.executeUpdateInternal(string2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.executeUpdate(string);
        }
        if (stringArray == null || stringArray.length == 0) {
            DatabaseError.throwSqlException(68);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(string, stringArray);
                this.connection.doDescribeTable(this.autoKeyInfo);
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = stringArray.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                return this.executeUpdateInternal(string2);
            }
        }
    }

    int executeUpdateInternal(String string) throws SQLException {
        int n;
        try {
            if (this.executionType == -1) {
                this.executionType = (byte)2;
            }
            this.noMoreUpdateCounts = false;
            this.ensureOpen();
            this.checkIfJdbcBatchExists();
            this.sendBatch();
            this.sqlObject.initialize(string);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.needToParse = true;
            this.prepareForNewResults(true, true);
            if (this.userRsetType == 1) {
                this.doExecuteWithTimeout();
            } else {
                this.doScrollStmtExecuteQuery();
            }
            n = this.validRows;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.executionType = (byte)-1;
            throw throwable;
        }
        this.executionType = (byte)-1;
        return n;
    }

    abstract void fetch() throws SQLException;

    void fetchDmlReturnParams() throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    void foundPlsqlCompilerWarning() throws SQLException {
        SQLWarning sQLWarning = DatabaseError.newSqlWarning("Found Plsql compiler warnings.", "99999", 24439);
        if (this.sqlWarning != null) {
            this.sqlWarning.setNextWarning(sQLWarning);
        } else {
            this.sqlWarning = sQLWarning;
        }
    }

    void freeLine() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    public boolean getAutoRefetch() throws SQLException {
        return this.autoRefetch;
    }

    String getBatchItem(int n) {
        return (String)this.m_batchItems.elementAt(n);
    }

    int getBatchSize() {
        return this.m_batchItems.size();
    }

    int getColumnIndex(String string) throws SQLException {
        if (!this.describedWithNames) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.doDescribe(true);
                    this.described = true;
                    this.describedWithNames = true;
                }
            }
        }
        int n = 0;
        while (n < this.numberOfDefinePositions) {
            if (this.accessors[n].columnName.equalsIgnoreCase(string)) {
                return n + 1;
            }
            ++n;
        }
        DatabaseError.throwSqlException(6);
        return 0;
    }

    public Connection getConnection() throws SQLException {
        return this.connection.getWrapper();
    }

    Calendar getDefaultCalendar() {
        if (this.defaultCalendar == null) {
            this.defaultCalendar = Calendar.getInstance(this.getDefaultTimeZone());
        }
        return this.defaultCalendar;
    }

    TimeZone getDefaultTimeZone() {
        if (this.defaultTZ == null) {
            this.defaultTZ = TimeZone.getDefault();
        }
        return this.defaultTZ;
    }

    Accessor[] getDescription() throws SQLException {
        if (!this.described) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.doDescribe(false);
                    this.described = true;
                }
            }
        }
        return this.accessors;
    }

    Accessor[] getDescriptionWithNames() throws SQLException {
        if (!this.describedWithNames) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.doDescribe(true);
                    this.described = true;
                    this.describedWithNames = true;
                }
            }
        }
        return this.accessors;
    }

    public int getFetchDirection() throws SQLException {
        return this.defaultFetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.getPrefetchInternal(true);
    }

    public boolean getFixedString() {
        return this.fixedString;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (!this.isAutoGeneratedKey) {
            DatabaseError.throwSqlException(90);
        }
        if (this.returnParamAccessors == null || this.numReturnParams == 0) {
            DatabaseError.throwSqlException(144);
        }
        if (this.returnResultSet == null) {
            this.returnResultSet = new OracleReturnResultSet(this);
        }
        return this.returnResultSet;
    }

    int getInternalType(int n) throws SQLException {
        int n2 = 0;
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 6;
                break;
            }
            case 100: {
                n2 = 100;
                break;
            }
            case 101: {
                n2 = 101;
                break;
            }
            case 999: {
                n2 = 999;
                break;
            }
            case 1: {
                n2 = 96;
                break;
            }
            case 12: {
                n2 = 1;
                break;
            }
            case -1: {
                n2 = 8;
                break;
            }
            case 91: 
            case 92: {
                n2 = 12;
                break;
            }
            case -100: 
            case 93: {
                n2 = 180;
                break;
            }
            case -101: {
                n2 = 181;
                break;
            }
            case -102: {
                n2 = 231;
                break;
            }
            case -103: {
                n2 = 182;
                break;
            }
            case -104: {
                n2 = 183;
                break;
            }
            case -3: 
            case -2: {
                n2 = 23;
                break;
            }
            case -4: {
                n2 = 24;
                break;
            }
            case -8: {
                n2 = 104;
                break;
            }
            case 2004: {
                n2 = 113;
                break;
            }
            case 2005: {
                n2 = 112;
                break;
            }
            case -13: {
                n2 = 114;
                break;
            }
            case -10: {
                n2 = 102;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                n2 = 109;
                break;
            }
            case 2006: {
                n2 = 111;
                break;
            }
            case -14: {
                n2 = 998;
                break;
            }
            case 70: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 995;
                break;
            }
            default: {
                DatabaseError.throwSqlException(4);
            }
        }
        return n2;
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return false;
    }

    public boolean getMoreResults(int n) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return false;
    }

    int getNumberOfColumns() throws SQLException {
        if (!this.described) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.doDescribe(false);
                    this.described = true;
                }
            }
        }
        return this.numberOfDefinePositions;
    }

    public String getOriginalSql() throws SQLException {
        return this.sqlObject.getOriginalSql();
    }

    int getPrefetchInternal(boolean bl) {
        int n = bl ? this.defaultRowPrefetch : this.rowPrefetch;
        return n;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        if (this.userRsetType == 1) {
            if (this.sqlKind == 0) {
                if (this.currentResultSet == null) {
                    this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                }
                return this.currentResultSet;
            }
        } else {
            return this.scrollRset;
        }
        return null;
    }

    public synchronized OracleResultSetCache getResultSetCache() throws SQLException {
        return (OracleResultSetCache)this.rsetCache;
    }

    public int getResultSetConcurrency() throws SQLException {
        return ResultSetUtil.getUpdateConcurrency(this.userRsetType);
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getResultSetType() throws SQLException {
        return ResultSetUtil.getScrollType(this.userRsetType);
    }

    public synchronized int getRowPrefetch() {
        return this.getPrefetchInternal(true);
    }

    byte getSqlKind() {
        return this.sqlKind;
    }

    public synchronized int getUpdateCount() throws SQLException {
        int n = -1;
        switch (this.sqlKind) {
            case 3: {
                if (!this.noMoreUpdateCounts) {
                    n = this.rowsProcessed;
                }
                this.noMoreUpdateCounts = true;
                break;
            }
            case 1: 
            case 4: {
                this.noMoreUpdateCounts = true;
                break;
            }
            case 2: {
                if (!this.noMoreUpdateCounts) {
                    n = this.rowsProcessed;
                }
                this.noMoreUpdateCounts = true;
                break;
            }
        }
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    public int getcacheState() {
        return this.cacheState;
    }

    public boolean getserverCursor() {
        return this.serverCursor;
    }

    public int getstatementType() {
        return this.statementType;
    }

    protected void hardClose() throws SQLException {
        this.hardClose(true);
    }

    private void hardClose(boolean bl) throws SQLException {
        this.alwaysOnClose();
        this.describedWithNames = false;
        this.described = false;
        this.connection.removeStatement(this);
        this.cleanupDefines();
        if (this.isOpen && bl && (this.connection.lifecycle == 1 || this.connection.lifecycle == 16 || this.connection.lifecycle == 2)) {
            if (this.connection.lifecycle == 2) {
                this.connection.needLineUnchecked();
            } else {
                this.connection.needLine();
            }
            this.doClose();
            this.isOpen = false;
        }
        this.sqlObject = null;
    }

    void initBatch() {
    }

    void initializeDefineSubRanges() {
        this.defineByteSubRange = 0;
        this.defineCharSubRange = 0;
        this.defineIndicatorSubRange = 0;
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = 0;
    }

    public boolean isColumnSetNull(int n) {
        return this.columnSetNull;
    }

    public boolean isNCHAR(int n) throws SQLException {
        int n2;
        if (!this.described) {
            this.describe();
        }
        if ((n2 = n - 1) < 0 || n2 >= this.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        boolean bl = this.accessors[n2].formOfUse == 2;
        return bl;
    }

    boolean isOracleBatchStyle() {
        return false;
    }

    public void notifyCloseRset() throws SQLException {
        this.scrollRset = null;
        this.endOfResultSet(false);
    }

    void open() throws SQLException {
        if (!this.isOpen) {
            this.connection.needLine();
            this.connection.open(this);
            this.isOpen = true;
        }
    }

    void prepareAccessors() throws SQLException {
        int n;
        Accessor accessor;
        byte[] byArray = null;
        char[] cArray = null;
        short[] sArray = null;
        boolean bl = false;
        if (this.accessors == null) {
            DatabaseError.throwSqlException(21);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.numberOfDefinePositions) {
            accessor = this.accessors[n4];
            if (accessor == null) {
                DatabaseError.throwSqlException(21);
            }
            n2 += accessor.byteLength;
            n3 += accessor.charLength;
            ++n4;
        }
        if (this.streamList != null && !this.connection.useFetchSizeWithLongColumn) {
            this.rowPrefetch = 1;
        }
        this.definesBatchSize = n = this.rowPrefetch;
        this.initializeDefineSubRanges();
        int n5 = this.defineByteSubRange + n2 * n;
        if (this.defineBytes == null || this.defineBytes.length < n5) {
            if (this.defineBytes != null) {
                byArray = this.defineBytes;
            }
            this.defineBytes = new byte[n5];
        }
        this.defineByteSubRange += this.accessorByteOffset;
        int n6 = this.defineCharSubRange + n3 * n;
        if ((this.defineChars == null || this.defineChars.length < n6) && n6 > 0) {
            if (this.defineChars != null) {
                cArray = this.defineChars;
            }
            this.defineChars = new char[n6];
        }
        this.defineCharSubRange += this.accessorCharOffset;
        int n7 = this.numberOfDefinePositions * n;
        int n8 = this.defineIndicatorSubRange + n7 + n7;
        if (this.defineIndicators == null || this.defineIndicators.length < n8) {
            if (this.defineIndicators != null) {
                sArray = this.defineIndicators;
            }
            this.defineIndicators = new short[n8];
        } else if (this.defineIndicators.length >= n8) {
            bl = true;
            sArray = this.defineIndicators;
        }
        this.defineIndicatorSubRange += this.accessorShortOffset;
        int n9 = this.defineIndicatorSubRange + n7;
        int n10 = 0;
        while (n10 < this.numberOfDefinePositions) {
            accessor = this.accessors[n10];
            accessor.lengthIndexLastRow = accessor.lengthIndex;
            accessor.indicatorIndexLastRow = accessor.indicatorIndex;
            accessor.columnIndexLastRow = accessor.columnIndex;
            accessor.setOffsets(n);
            accessor.lengthIndex = n9;
            accessor.indicatorIndex = this.defineIndicatorSubRange;
            accessor.rowSpaceByte = this.defineBytes;
            accessor.rowSpaceChar = this.defineChars;
            accessor.rowSpaceIndicator = this.defineIndicators;
            this.defineIndicatorSubRange += n;
            n9 += n;
            ++n10;
        }
        this.prepareDefinePreambles();
        if (this.rowPrefetchInLastFetch != -1) {
            if (cArray != null || byArray != null) {
                this.saveDefineBuffersIfRequired(cArray, byArray, sArray != null ? sArray : this.defineIndicators, bl);
            } else if (bl && this.rowPrefetch != this.rowPrefetchInLastFetch) {
                this.saveDefineBuffersIfRequired(this.defineChars, this.defineBytes, this.defineIndicators, bl);
            }
        }
    }

    void prepareDefinePreambles() {
    }

    void prepareForNewResults(boolean bl, boolean bl2) throws SQLException {
        this.clearWarnings();
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
            if (bl2) {
                OracleInputStream oracleInputStream = this.streamList;
                OracleInputStream oracleInputStream2 = null;
                this.streamList = null;
                while (oracleInputStream != null) {
                    if (!oracleInputStream.hasBeenOpen) {
                        if (oracleInputStream2 == null) {
                            this.streamList = oracleInputStream;
                        } else {
                            oracleInputStream2.nextStream = oracleInputStream;
                        }
                        oracleInputStream2 = oracleInputStream;
                    }
                    oracleInputStream = oracleInputStream.nextStream;
                }
            }
        }
        if (this.currentResultSet != null) {
            this.currentResultSet.internal_close(true);
            this.currentResultSet = null;
        }
        this.currentRow = -1;
        this.validRows = 0;
        this.totalRowsVisited = 0;
        this.gotLastBatch = false;
        if (this.needToParse && !this.columnsDefinedByUser) {
            if (bl2 && this.numberOfDefinePositions != 0) {
                this.numberOfDefinePositions = 0;
            }
            this.needToPrepareDefineBuffer = true;
        }
        if (bl && this.rowPrefetch != this.defaultRowPrefetch && this.streamList == null) {
            this.rowPrefetch = this.defaultRowPrefetch;
            this.rowPrefetchChanged = true;
        }
    }

    void printState(String string) throws SQLException {
    }

    void processDmlReturningBind() throws SQLException {
        if (this.returnResultSet != null) {
            this.returnResultSet.close();
        }
        this.returnParamsFetched = false;
        this.returnParamRowBytes = 0;
        this.returnParamRowChars = 0;
        int n = 0;
        int n2 = 0;
        while (n2 < this.numberOfBindPositions) {
            Accessor accessor = this.returnParamAccessors[n2];
            if (accessor != null) {
                ++n;
                if (accessor.charLength > 0) {
                    this.returnParamRowChars += accessor.charLength;
                } else {
                    this.returnParamRowBytes += accessor.byteLength;
                }
            }
            ++n2;
        }
        if (this.isAutoGeneratedKey) {
            this.numReturnParams = n;
        } else {
            if (this.numReturnParams <= 0) {
                this.numReturnParams = OraclePreparedStatement.getReturnParameterCount(this.sqlObject.getOriginalSql());
            }
            if (this.numReturnParams != n) {
                DatabaseError.throwSqlException(173);
            }
        }
        this.returnParamMeta[0] = this.numReturnParams;
        this.returnParamMeta[1] = this.returnParamRowBytes;
        this.returnParamMeta[2] = this.returnParamRowChars;
    }

    void registerReturnParameterInternal(int n, int n2, int n3, int n4, short s, String string) throws SQLException {
        if (this.returnParamAccessors == null) {
            this.returnParamAccessors = new Accessor[this.numberOfBindPositions];
        }
        if (this.returnParamMeta == null) {
            this.returnParamMeta = new int[3 + this.numberOfBindPositions * 3];
        }
        Accessor accessor = this.allocateAccessor(n2, n3, n + 1, n4, s, string, true);
        accessor.isDMLReturnedParam = true;
        this.returnParamAccessors[n] = accessor;
        boolean bl = accessor.charLength > 0;
        this.returnParamMeta[3 + n * 3] = accessor.defineType;
        this.returnParamMeta[3 + n * 3 + 1] = bl ? 1 : 0;
        this.returnParamMeta[3 + n * 3 + 2] = bl ? accessor.charLength : accessor.byteLength;
    }

    void releaseBuffers() {
        this.cachedDefineByteSize = this.defineBytes != null ? this.defineBytes.length : 0;
        this.cachedDefineCharSize = this.defineChars != null ? this.defineChars.length : 0;
        this.cachedDefineIndicatorSize = this.defineIndicators != null ? this.defineIndicators.length : 0;
        this.defineChars = null;
        this.defineBytes = null;
        this.defineIndicators = null;
    }

    void reopenStreams() throws SQLException {
        OracleInputStream oracleInputStream = this.streamList;
        while (oracleInputStream != null) {
            if (oracleInputStream.hasBeenOpen) {
                oracleInputStream = oracleInputStream.accessor.initForNewRow();
            }
            oracleInputStream.closed = false;
            oracleInputStream.hasBeenOpen = true;
            oracleInputStream = oracleInputStream.nextStream;
        }
        this.nextStream = this.streamList;
    }

    void reparseOnRedefineIfNeeded() throws SQLException {
    }

    void resetCurrentRowBinders() {
    }

    void resetOnExceptionDuringExecute() {
        this.needToParse = true;
    }

    void saveDefineBuffersIfRequired(char[] cArray, byte[] byArray, short[] sArray, boolean bl) throws SQLException {
    }

    public int sendBatch() throws SQLException {
        return 0;
    }

    public void setAutoRefetch(boolean bl) throws SQLException {
        this.autoRefetch = bl;
    }

    void setCursorId(int n) throws SQLException {
        this.cursorId = n;
    }

    public void setCursorName(String string) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    void setDefinesInitialized(boolean bl) {
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.processEscapes = bl;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n == 1000) {
            this.defaultFetchDirection = n;
        } else if (n == 1001 || n == 1002) {
            this.defaultFetchDirection = 1000;
            this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
        } else {
            DatabaseError.throwSqlException(68, "setFetchDirection");
        }
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.setPrefetchInternal(n, false, true);
    }

    public void setFixedString(boolean bl) {
        this.fixedString = bl;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        }
        this.maxFieldSize = n;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        }
        this.maxRows = n;
    }

    private final void setNonAutoKey() {
        this.isAutoGeneratedKey = false;
        this.numberOfBindPositions = 0;
        this.bindIndicators = null;
    }

    void setPrefetchInternal(int n, boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            if (n <= 0) {
                DatabaseError.throwSqlException(20);
            }
        } else if (n < 0) {
            DatabaseError.throwSqlException(68, "setFetchSize");
        } else if (n == 0) {
            n = this.connection.getDefaultRowPrefetch();
        }
        if (bl2) {
            if (n != this.defaultRowPrefetch) {
                this.defaultRowPrefetch = n;
                if (this.currentResultSet == null || this.currentResultSet.closed) {
                    this.rowPrefetchChanged = true;
                }
            }
        } else if (n != this.rowPrefetch && this.streamList == null) {
            this.rowPrefetch = n;
            this.rowPrefetchChanged = true;
        }
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        }
        this.queryTimeout = n;
    }

    public synchronized void setResultSetCache(oracle.jdbc.OracleResultSetCache oracleResultSetCache) throws SQLException {
        try {
            if (oracleResultSetCache == null) {
                DatabaseError.throwSqlException(68);
            }
            if (this.rsetCache != null) {
                this.rsetCache.close();
            }
            this.rsetCache = oracleResultSetCache;
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized void setResultSetCache(OracleResultSetCache oracleResultSetCache) throws SQLException {
        this.setResultSetCache((oracle.jdbc.OracleResultSetCache)oracleResultSetCache);
    }

    public synchronized void setRowPrefetch(int n) throws SQLException {
        this.setPrefetchInternal(n, true, true);
    }

    void setupReturnParamAccessors() {
        if (this.rowsDmlReturned == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.numReturnParams * this.rowsDmlReturned;
        int n5 = 0;
        while (n5 < this.numberOfBindPositions) {
            Accessor accessor = this.returnParamAccessors[n5];
            if (accessor != null) {
                if (accessor.charLength > 0) {
                    accessor.rowSpaceChar = this.returnParamChars;
                    accessor.columnIndex = n2;
                    n2 += this.rowsDmlReturned * accessor.charLength;
                } else {
                    accessor.rowSpaceByte = this.returnParamBytes;
                    accessor.columnIndex = n;
                    n += this.rowsDmlReturned * accessor.byteLength;
                }
                accessor.rowSpaceIndicator = this.returnParamIndicators;
                accessor.indicatorIndex = n3;
                n3 += this.rowsDmlReturned;
                accessor.lengthIndex = n4;
                n4 += this.rowsDmlReturned;
            }
            ++n5;
        }
    }

    boolean wasNullValue() throws SQLException {
        if (this.lastIndex == 0) {
            DatabaseError.throwSqlException(24);
        }
        if (this.sqlKind == 0) {
            return this.accessors[this.lastIndex - 1].isNull(this.currentRow);
        }
        return this.outBindAccessors[this.lastIndex - 1].isNull(this.currentRank);
    }
}

