/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetCacheImpl;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ScrollableResultSet
extends BaseResultSet {
    PhysicalConnection connection;
    OracleResultSetImpl resultSet;
    ScrollRsetStatement scrollStmt;
    ResultSetMetaData metadata;
    private int rsetType;
    private int rsetConcurency;
    private int beginColumnIndex;
    private int columnCount;
    private int wasNull;
    OracleResultSetCache rsetCache;
    int currentRow;
    private int numRowsCached;
    private boolean allRowsCached;
    private int lastRefetchSz;
    private Vector refetchRowids;
    private OraclePreparedStatement refetchStmt;
    private int usrFetchDirection;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:36:26_PST_2008";

    ScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n, int n2) throws SQLException {
        this.connection = ((OracleStatement)scrollRsetStatement).connection;
        this.resultSet = oracleResultSetImpl;
        this.metadata = null;
        this.scrollStmt = scrollRsetStatement;
        this.rsetType = n;
        this.rsetConcurency = n2;
        this.autoRefetch = scrollRsetStatement.getAutoRefetch();
        this.beginColumnIndex = ScrollableResultSet.needIdentifier(n, n2) ? 1 : 0;
        this.columnCount = 0;
        this.wasNull = -1;
        this.rsetCache = scrollRsetStatement.getResultSetCache();
        if (this.rsetCache == null) {
            this.rsetCache = new OracleResultSetCacheImpl();
        } else {
            try {
                this.rsetCache.clear();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
        }
        this.currentRow = 0;
        this.numRowsCached = 0;
        this.allRowsCached = false;
        this.lastRefetchSz = 0;
        this.refetchRowids = null;
        this.refetchStmt = null;
        this.usrFetchDirection = 1000;
        this.getInternalMetadata();
    }

    public synchronized boolean absolute(int n) throws SQLException {
        if (n == 0) {
            DatabaseError.throwSqlException(68, "absolute (0)");
        }
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (n > 0) {
            this.currentRow = n;
        } else if (n < 0) {
            this.currentRow = this.getLastRow() + 1 + n;
        }
        return this.isValidRow(this.currentRow);
    }

    public synchronized void afterLast() throws SQLException {
        if (!this.isEmptyResultSet()) {
            this.currentRow = this.getLastRow() + 1;
        }
    }

    public synchronized void beforeFirst() throws SQLException {
        if (!this.isEmptyResultSet()) {
            this.currentRow = 0;
        }
    }

    private int cacheAllRows() throws SQLException {
        while (this.resultSet.next()) {
            int n = 0;
            while (n < this.getColumnCount()) {
                this.putCachedValueAt(this.numRowsCached + 1, n + 1, this.resultSet.privateGetBytes(n + 1));
                ++n;
            }
            ++this.numRowsCached;
        }
        this.allRowsCached = true;
        return this.numRowsCached;
    }

    private boolean cacheRowAt(int n) throws SQLException {
        while (this.numRowsCached < n && this.resultSet.next()) {
            int n2 = 0;
            while (n2 < this.getColumnCount()) {
                byte[] byArray = this.resultSet.privateGetBytes(n2 + 1);
                this.putCachedValueAt(this.numRowsCached + 1, n2 + 1, byArray);
                ++n2;
            }
            ++this.numRowsCached;
        }
        if (this.numRowsCached < n) {
            this.allRowsCached = true;
            return false;
        }
        return true;
    }

    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.refetchStmt != null) {
                    this.refetchStmt.close();
                }
                if (this.scrollStmt != null) {
                    this.scrollStmt.notifyCloseRset();
                }
                if (this.refetchRowids != null) {
                    this.refetchRowids.removeAllElements();
                }
                this.resultSet = null;
                this.scrollStmt = null;
                this.refetchStmt = null;
                this.refetchRowids = null;
                this.metadata = null;
                try {
                    if (this.rsetCache != null) {
                        this.rsetCache.clear();
                        this.rsetCache.close();
                    }
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.rsetCache = null;
            }
        }
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.resultSet.findColumn(string) - this.beginColumnIndex;
    }

    public synchronized boolean first() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.currentRow = 1;
        return this.isValidRow(this.currentRow);
    }

    public synchronized ARRAY getARRAY(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof ARRAY) {
                return (ARRAY)datum;
            }
            DatabaseError.throwSqlException(4, "getARRAY");
        }
        return null;
    }

    public synchronized Array getArray(int n) throws SQLException {
        return this.getARRAY(n);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.asciiStreamValue();
        }
        return null;
    }

    public synchronized BFILE getBFILE(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof BFILE) {
                return (BFILE)datum;
            }
            DatabaseError.throwSqlException(4, "getBFILE");
        }
        return null;
    }

    public synchronized BLOB getBLOB(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof BLOB) {
                return (BLOB)datum;
            }
            DatabaseError.throwSqlException(4, "getBLOB");
        }
        return null;
    }

    public synchronized BFILE getBfile(int n) throws SQLException {
        return this.getBFILE(n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 0);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.binaryStreamValue();
        }
        return null;
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        return this.getBLOB(n);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.booleanValue();
        }
        return false;
    }

    public synchronized byte getByte(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.byteValue();
        }
        return 0;
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof RAW) {
                return ((RAW)datum).shareBytes();
            }
            DatabaseError.throwSqlException(4, "getBytes");
        }
        return null;
    }

    public synchronized CHAR getCHAR(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof CHAR) {
                return (CHAR)datum;
            }
            DatabaseError.throwSqlException(4, "getCHAR");
        }
        return null;
    }

    public synchronized CLOB getCLOB(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof CLOB) {
                return (CLOB)datum;
            }
            DatabaseError.throwSqlException(4, "getCLOB");
        }
        return null;
    }

    private Datum getCachedDatumValueAt(int n, int n2) throws SQLException {
        Datum datum;
        block12: {
            Object object = null;
            try {
                object = this.rsetCache.get(n, n2);
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
            datum = null;
            if (object == null) break block12;
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else if (((byte[])object).length > 0) {
                int n3 = this.getInternalMetadata().getColumnType(n2);
                int n4 = this.getInternalMetadata().getColumnDisplaySize(n2);
                int n5 = this.scrollStmt.getMaxFieldSize();
                if (n5 > 0 && n5 < n4) {
                    n4 = n5;
                }
                String string = null;
                if (n3 == 2006 || n3 == 2002 || n3 == 2008 || n3 == 2007 || n3 == 2003) {
                    string = this.getInternalMetadata().getColumnTypeName(n2);
                }
                int n6 = SQLUtil.getInternalType(n3);
                short s = this.resultSet.statement.accessors[n2 - 1].formOfUse;
                datum = s == 2 && (n6 == 96 || n6 == 1 || n6 == 8 || n6 == 112) ? SQLUtil.makeNDatum(this.connection, (byte[])object, n6, string, s, n4) : SQLUtil.makeDatum((OracleConnection)this.connection, (byte[])object, n6, string, n4);
                try {
                    this.rsetCache.put(n, n2, datum);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                try {
                    this.rsetCache.put(n, n2, null);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            }
        }
        return datum;
    }

    private Object getCachedValueAt(int n, int n2) throws SQLException {
        try {
            return this.rsetCache.get(n, n2);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
            return null;
        }
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    public synchronized Clob getClob(int n) throws SQLException {
        return this.getCLOB(n);
    }

    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            int n = this.resultSet.statement.numberOfDefinePositions;
            this.columnCount = this.resultSet.statement.accessors != null && n > 0 ? n : this.getInternalMetadata().getColumnCount();
        }
        return this.columnCount;
    }

    public int getConcurrency() throws SQLException {
        return this.rsetConcurency;
    }

    public synchronized ResultSet getCursor(int n) throws SQLException {
        DatabaseError.throwSqlException(4, "getCursor");
        return null;
    }

    public synchronized CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = this.getOracleObject(n);
        return customDatumFactory.create(datum, 0);
    }

    public synchronized DATE getDATE(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof DATE) {
                return (DATE)datum;
            }
            DatabaseError.throwSqlException(4, "getDATE");
        }
        return null;
    }

    public synchronized Date getDate(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        Date date = null;
        if (datum != null) {
            ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
            switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                case 93: {
                    date = ((TIMESTAMP)datum).dateValue();
                    break;
                }
                case -101: {
                    date = ((TIMESTAMPTZ)datum).dateValue(this.connection);
                    break;
                }
                case -102: {
                    date = ((TIMESTAMPLTZ)datum).dateValue(this.connection);
                    break;
                }
                default: {
                    date = datum.dateValue();
                    break;
                }
            }
        }
        return date;
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        Datum datum = this.getOracleObject(n);
        Date date = null;
        if (datum != null) {
            ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
            switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                case 93: {
                    date = new Date(((java.util.Date)((TIMESTAMP)datum).timestampValue()).getTime());
                    break;
                }
                case -101: {
                    date = new Date(((java.util.Date)((TIMESTAMPTZ)datum).timestampValue(this.connection)).getTime());
                    break;
                }
                case -102: {
                    date = new Date(((java.util.Date)((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar)).getTime());
                    break;
                }
                case 91: {
                    date = ((DATE)datum).dateValue(calendar);
                    break;
                }
                default: {
                    DatabaseError.throwSqlException(4, "getDate");
                }
            }
        }
        return date;
    }

    public synchronized double getDouble(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.doubleValue();
        }
        return 0.0;
    }

    public synchronized int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    int getFirstUserColumnIndex() {
        return this.beginColumnIndex;
    }

    public synchronized float getFloat(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.floatValue();
        }
        return 0.0f;
    }

    public synchronized INTERVALDS getINTERVALDS(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof INTERVALDS) {
                return (INTERVALDS)datum;
            }
            DatabaseError.throwSqlException(4, "getINTERVALDS");
        }
        return null;
    }

    public synchronized INTERVALYM getINTERVALYM(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof INTERVALYM) {
                return (INTERVALYM)datum;
            }
            DatabaseError.throwSqlException(4, "getINTERVALYM");
        }
        return null;
    }

    public synchronized int getInt(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.intValue();
        }
        return 0;
    }

    private ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.metadata == null) {
            this.metadata = this.resultSet.getMetaData();
        }
        return this.metadata;
    }

    private int getLastRow() throws SQLException {
        if (!this.allRowsCached) {
            this.cacheAllRows();
        }
        return this.numRowsCached;
    }

    public synchronized long getLong(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.longValue();
        }
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                return new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, this.beginColumnIndex);
            }
        }
    }

    public synchronized NUMBER getNUMBER(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof NUMBER) {
                return (NUMBER)datum;
            }
            DatabaseError.throwSqlException(4, "getNUMBER");
        }
        return null;
    }

    public synchronized OPAQUE getOPAQUE(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof OPAQUE) {
                return (OPAQUE)datum;
            }
            DatabaseError.throwSqlException(4, "getOPAQUE");
        }
        return null;
    }

    public synchronized ORAData getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        Datum datum = this.getOracleObject(n);
        return oRADataFactory.create(datum, 0);
    }

    public Object getObject(int n) throws SQLException {
        return this.getObject(n, this.connection.getTypeMap());
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(map);
            }
            return datum.toJdbc();
        }
        return null;
    }

    public synchronized Datum getOracleObject(int n) throws SQLException {
        Datum datum;
        this.wasNull = -1;
        if (!this.isValidRow(this.currentRow)) {
            DatabaseError.throwSqlException(11);
        }
        if (n < 1 || n > this.getColumnCount()) {
            DatabaseError.throwSqlException(3);
        }
        this.wasNull = (datum = this.getCachedDatumValueAt(this.currentRow, n + this.beginColumnIndex)) == null ? 1 : 0;
        return datum;
    }

    public synchronized RAW getRAW(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof RAW) {
                return (RAW)datum;
            }
            DatabaseError.throwSqlException(4, "getRAW");
        }
        return null;
    }

    public synchronized REF getREF(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof REF) {
                return (REF)datum;
            }
            DatabaseError.throwSqlException(4, "getREF");
        }
        return null;
    }

    public synchronized ROWID getROWID(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof ROWID) {
                return (ROWID)datum;
            }
            DatabaseError.throwSqlException(4, "getROWID");
        }
        return null;
    }

    public synchronized Ref getRef(int n) throws SQLException {
        return this.getREF(n);
    }

    synchronized ResultSet getResultSet() {
        return this.resultSet;
    }

    public synchronized int getRow() throws SQLException {
        if (this.isValidRow(this.currentRow)) {
            return this.currentRow;
        }
        return 0;
    }

    public synchronized STRUCT getSTRUCT(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return (STRUCT)datum;
            }
            DatabaseError.throwSqlException(4, "getSTRUCT");
        }
        return null;
    }

    public synchronized short getShort(int n) throws SQLException {
        long l = this.getLong(n);
        if (l > 65537L || l < -65538L) {
            DatabaseError.throwSqlException(26, "getShort");
        }
        return (short)l;
    }

    public synchronized Statement getStatement() throws SQLException {
        return (Statement)((Object)this.scrollStmt);
    }

    public synchronized String getString(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            switch (this.getInternalMetadata().getColumnType(n + this.beginColumnIndex)) {
                case 2005: {
                    CLOB cLOB = (CLOB)datum;
                    return cLOB.getSubString(1L, (int)cLOB.length());
                }
            }
            return datum.stringValue();
        }
        return null;
    }

    public synchronized TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof TIMESTAMP) {
                return (TIMESTAMP)datum;
            }
            DatabaseError.throwSqlException(4, "getTIMESTAMP");
        }
        return null;
    }

    public synchronized TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof TIMESTAMPLTZ) {
                return (TIMESTAMPLTZ)datum;
            }
            DatabaseError.throwSqlException(4, "getTIMESTAMPLTZ");
        }
        return null;
    }

    public synchronized TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof TIMESTAMPTZ) {
                return (TIMESTAMPTZ)datum;
            }
            DatabaseError.throwSqlException(4, "getTIMESTAMPTZ");
        }
        return null;
    }

    public synchronized Time getTime(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        Time time = null;
        if (datum != null) {
            ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
            switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                case 93: {
                    time = ((TIMESTAMP)datum).timeValue();
                    break;
                }
                case -101: {
                    time = ((TIMESTAMPTZ)datum).timeValue(this.connection);
                    break;
                }
                case -102: {
                    time = ((TIMESTAMPLTZ)datum).timeValue(this.connection);
                    break;
                }
                default: {
                    time = datum.timeValue();
                    break;
                }
            }
        }
        return time;
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        Datum datum = this.getOracleObject(n);
        Time time = null;
        if (datum != null) {
            ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
            switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                case 93: {
                    time = new Time(((java.util.Date)((TIMESTAMP)datum).timestampValue()).getTime());
                    break;
                }
                case -101: {
                    time = new Time(((java.util.Date)((TIMESTAMPTZ)datum).timestampValue(this.connection)).getTime());
                    break;
                }
                case -102: {
                    time = new Time(((java.util.Date)((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar)).getTime());
                    break;
                }
                case 91: {
                    time = ((DATE)datum).timeValue(calendar);
                    break;
                }
                default: {
                    DatabaseError.throwSqlException(4, "getTime");
                }
            }
        }
        return time;
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        Timestamp timestamp = null;
        if (datum != null) {
            ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
            switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                case 93: {
                    timestamp = ((TIMESTAMP)datum).timestampValue();
                    break;
                }
                case -101: {
                    timestamp = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                    break;
                }
                case -102: {
                    timestamp = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, ((OracleStatement)this.scrollStmt).getDefaultCalendar());
                    break;
                }
                default: {
                    timestamp = datum.timestampValue();
                    break;
                }
            }
        }
        return timestamp;
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Datum datum = this.getOracleObject(n);
        Timestamp timestamp = null;
        if (datum != null) {
            ResultSetMetaData resultSetMetaData = this.getInternalMetadata();
            switch (resultSetMetaData.getColumnType(n + this.beginColumnIndex)) {
                case 93: {
                    timestamp = ((TIMESTAMP)datum).timestampValue();
                    break;
                }
                case -101: {
                    timestamp = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                    break;
                }
                case -102: {
                    timestamp = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, calendar);
                    break;
                }
                case 91: {
                    timestamp = ((DATE)datum).timestampValue(calendar);
                    break;
                }
                default: {
                    DatabaseError.throwSqlException(4, "getTimestamp");
                }
            }
        }
        return timestamp;
    }

    public int getType() throws SQLException {
        return this.rsetType;
    }

    public synchronized URL getURL(int n) throws SQLException {
        URL uRL = null;
        int n2 = this.getInternalMetadata().getColumnType(n);
        int n3 = SQLUtil.getInternalType(n2);
        if (n3 == 96 || n3 == 1 || n3 == 8) {
            try {
                uRL = new URL(this.getString(n));
            }
            catch (MalformedURLException malformedURLException) {
                DatabaseError.throwSqlException(136);
            }
        } else {
            throw new SQLException("Conversion to java.net.URL not supported.");
        }
        return uRL;
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            DBConversion dBConversion = this.connection.conversion;
            byte[] byArray = datum.shareBytes();
            if (datum instanceof RAW) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
            }
            if (datum instanceof CHAR) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
            }
            DatabaseError.throwSqlException(4, "getUnicodeStream");
        }
        return null;
    }

    private int get_refetch_size(int n, int n2, int n3) throws SQLException {
        int n4 = n3 == 1001 ? -1 : 1;
        int n5 = 0;
        if (this.refetchRowids == null) {
            this.refetchRowids = new Vector(10);
        } else {
            this.refetchRowids.removeAllElements();
        }
        while (n5 < n2 && this.isValidRow(n + n5 * n4)) {
            this.refetchRowids.addElement(this.getCachedDatumValueAt(n + n5 * n4, 1));
            ++n5;
        }
        return n5;
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.currentRow > 0 && !this.isValidRow(this.currentRow);
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.currentRow < 1;
    }

    private boolean isEmptyResultSet() throws SQLException {
        if (this.numRowsCached != 0) {
            return false;
        }
        if (this.numRowsCached == 0 && this.allRowsCached) {
            return true;
        }
        return this.isValidRow(1) ^ true;
    }

    public synchronized boolean isFirst() throws SQLException {
        return this.currentRow == 1;
    }

    public synchronized boolean isLast() throws SQLException {
        return !this.isEmptyResultSet() && this.isValidRow(this.currentRow) && !this.isValidRow(this.currentRow + 1);
    }

    boolean isValidRow(int n) throws SQLException {
        if (n > 0 && n <= this.numRowsCached) {
            return true;
        }
        if (n <= 0) {
            return false;
        }
        return this.cacheRowAt(n);
    }

    public synchronized boolean last() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.currentRow = this.getLastRow();
        return this.isValidRow(this.currentRow);
    }

    public static boolean needCache(int n, int n2) {
        return n != 1003 && (n != 1004 || n2 != 1007);
    }

    public static boolean needIdentifier(int n, int n2) {
        return (n != 1003 || n2 != 1007) && (n != 1004 || n2 != 1007);
    }

    public synchronized boolean next() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.currentRow = this.currentRow < 1 ? 1 : ++this.currentRow;
        return this.isValidRow(this.currentRow);
    }

    private void prepare_refetch_binds(OraclePreparedStatement oraclePreparedStatement, int n) throws SQLException {
        int n2 = this.scrollStmt.copyBinds(oraclePreparedStatement, 0);
        int n3 = 0;
        while (n3 < n) {
            oraclePreparedStatement.setROWID(n2 + n3 + 1, (ROWID)this.refetchRowids.elementAt(n3));
            ++n3;
        }
    }

    private OraclePreparedStatement prepare_refetch_statement(int n) throws SQLException {
        if (n < 1) {
            DatabaseError.throwSqlException(68);
        }
        return (OraclePreparedStatement)this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getRefetchSqlForScrollableResultSet(this, n));
    }

    public synchronized boolean previous() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.currentRow = this.isAfterLast() ? this.getLastRow() : --this.currentRow;
        return this.isValidRow(this.currentRow);
    }

    private void putCachedValueAt(int n, int n2, Object object) throws SQLException {
        try {
            this.rsetCache.put(n, n2, object);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    public void refreshRow() throws SQLException {
        if (!ScrollableResultSet.needIdentifier(this.rsetType, this.rsetConcurency)) {
            DatabaseError.throwSqlException(23, "refreshRow");
        }
        if (this.isValidRow(this.currentRow)) {
            int n = this.getFetchDirection();
            try {
                this.refreshRowsInCache(this.currentRow, this.getFetchSize(), n);
            }
            catch (SQLException sQLException) {
                DatabaseError.throwSqlException(sQLException, 90, "Unsupported syntax for refreshRow()");
            }
        } else {
            DatabaseError.throwSqlException(82, "refreshRow");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int refreshRowsInCache(int n, int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                int n5;
                OracleResultSet oracleResultSet;
                block10: {
                    oracleResultSet = null;
                    n5 = 0;
                    n5 = this.get_refetch_size(n, n2, n3);
                    try {
                        if (n5 <= 0) break block10;
                        if (n5 != this.lastRefetchSz) {
                            if (this.refetchStmt != null) {
                                this.refetchStmt.close();
                            }
                            this.refetchStmt = this.prepare_refetch_statement(n5);
                            this.refetchStmt.setQueryTimeout(((OracleStatement)this.scrollStmt).getQueryTimeout());
                            this.lastRefetchSz = n5;
                        }
                        this.prepare_refetch_binds(this.refetchStmt, n5);
                        oracleResultSet = (OracleResultSet)this.refetchStmt.executeQuery();
                        this.save_refetch_results(oracleResultSet, n, n5, n3);
                    }
                    catch (Throwable throwable) {
                        Object var12_9 = null;
                        if (oracleResultSet == null) throw throwable;
                        oracleResultSet.close();
                        throw throwable;
                    }
                }
                Object var12_8 = null;
                if (oracleResultSet == null) return n5;
                oracleResultSet.close();
                return n5;
            }
        }
    }

    public synchronized boolean relative(int n) throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (this.isValidRow(this.currentRow)) {
            this.currentRow += n;
            return this.isValidRow(this.currentRow);
        }
        DatabaseError.throwSqlException(82, "relative");
        return false;
    }

    private void removeCachedRowAt(int n) throws SQLException {
        try {
            this.rsetCache.remove(n);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    synchronized int removeRowInCache(int n) throws SQLException {
        if (!this.isEmptyResultSet() && this.isValidRow(n)) {
            this.removeCachedRowAt(n);
            --this.numRowsCached;
            if (n >= this.currentRow) {
                --this.currentRow;
            }
            return 1;
        }
        return 0;
    }

    synchronized void resetBeginColumnIndex() {
        this.beginColumnIndex = 0;
    }

    private void save_refetch_results(OracleResultSet oracleResultSet, int n, int n2, int n3) throws SQLException {
        int n4 = n3 == 1001 ? -1 : 1;
        while (oracleResultSet.next()) {
            ROWID rOWID = oracleResultSet.getROWID(1);
            boolean bl = false;
            int n5 = n;
            while (!bl && n5 < n + n2 * n4) {
                if (((ROWID)this.getCachedDatumValueAt(n5, 1)).stringValue().equals(rOWID.stringValue())) {
                    bl = true;
                    continue;
                }
                n5 += n4;
            }
            if (!bl) continue;
            int n6 = 0;
            while (n6 < this.getColumnCount()) {
                this.putCachedValueAt(n5, n6 + 1, oracleResultSet.getOracleObject(n6 + 1));
                ++n6;
            }
        }
    }

    public void setCurrentRowValueAt(Object object, int n, Object object2) throws SQLException {
        if (object instanceof UpdatableResultSet) {
            this.putCachedValueAt(this.currentRow, n, object2);
        } else {
            DatabaseError.throwSqlException(1);
        }
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n == 1000) {
            this.usrFetchDirection = n;
        } else if (n == 1001 || n == 1002) {
            this.usrFetchDirection = n;
            this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
        } else {
            DatabaseError.throwSqlException(68, "setFetchDirection");
        }
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.resultSet.setFetchSize(n);
    }

    public static boolean supportRefreshRow(int n, int n2) {
        return n != 1003 && (n != 1004 || n2 != 1007);
    }

    public synchronized boolean wasNull() throws SQLException {
        if (this.wasNull == -1) {
            DatabaseError.throwSqlException(24);
        }
        return this.wasNull == 1;
    }
}

