/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.usages;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.usages.ServerLocation;
import oracle.ideimpl.usages.ServerLocations;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;

class FileSender {
    private static final FileSender _instance = new FileSender();
    private List _uploadServers;

    private FileSender() {
    }

    public static FileSender getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean logToServer(File ... logFiles) {
        if (logFiles == null || logFiles.length == 0) {
            return false;
        }
        boolean success = false;
        PostMethod method = null;
        try {
            HttpClient client = new HttpClient();
            FileSender.maybeConfigureProxySettings(client);
            client.getParams().setParameter("http.useragent", (Object)"Usage Tracker");
            client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
            FilePart[] parts = new FilePart[logFiles.length];
            for (int i = 0; i < logFiles.length; ++i) {
                parts[i] = new FilePart(logFiles[i].getName(), logFiles[i]);
            }
            List list = this.getUsageServers();
            Iterator iterator = list.iterator();
            while (!success && iterator.hasNext()) {
                ServerLocation server = (ServerLocation)iterator.next();
                method = new PostMethod(server.getUrl());
                MultipartRequestEntity multiRequest = new MultipartRequestEntity((Part[])parts, method.getParams());
                method.setRequestEntity((RequestEntity)multiRequest);
                int status = client.executeMethod((HttpMethod)method);
                if (200 == status) {
                    success = true;
                    continue;
                }
                iterator.remove();
                Assert.println((String)method.getResponseBodyAsString());
            }
        }
        catch (IOException e) {
            Assert.printStackTrace((Throwable)e);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return success;
    }

    private static void maybeConfigureProxySettings(HttpClient client) {
        ProxyOptions options = ProxyOptions.getProxyOptions();
        Boolean useProxy = options.getUseProxy();
        if (useProxy.booleanValue()) {
            String host = options.getProxyHost();
            Integer port = Integer.valueOf(options.getProxyPort());
            client.getHostConfiguration().setProxy(host, port.intValue());
            AuthScope authScope = new AuthScope(host, port.intValue());
            UsernamePasswordCredentials credentials = options.getUseProxyAuthentication() != false ? new UsernamePasswordCredentials(options.getProxyUserName(), new String(options.getProxyPassword())) : null;
            client.getState().setProxyCredentials(authScope, credentials);
        }
    }

    private List getUsageServers() {
        if (this._uploadServers == null || this._uploadServers.size() == 0) {
            this._uploadServers = new ArrayList<ServerLocation>(ServerLocations.getServers());
        }
        return this._uploadServers;
    }
}

