/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.usages;

import java.io.BufferedInputStream;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.usages.ServerLocation;
import oracle.ideimpl.usages.ServerLocationsParser;
import oracle.javatools.codeex.Base64;

final class ServerLocations {
    static String _masterServerURL;

    ServerLocations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<ServerLocation> getServers() {
        HashSet<ServerLocation> serverList = new HashSet<ServerLocation>();
        try {
            URL masterURL = URLFactory.newURL((String)ServerLocations.getMasterUsageServerURL());
            BufferedInputStream bis = null;
            try {
                URLConnection conn = ServerLocations.urlConnect(masterURL);
                bis = new BufferedInputStream(conn.getInputStream());
                List masterEntries = new ServerLocationsParser().parse(bis);
                for (ServerLocation entry : masterEntries) {
                    serverList.add(entry);
                }
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
        }
        catch (NoRouteToHostException nrth) {
            Assert.println((String)"Failed to upload usage logs to server. Possible cause: proxy may not be configured correctly.");
            Assert.printStackTrace((Throwable)nrth);
        }
        catch (Throwable t) {
            Assert.println((String)"Failed to upload usage logs to server.");
            Assert.printStackTrace((Throwable)t);
        }
        return Collections.unmodifiableSet(serverList);
    }

    private static URLConnection urlConnect(URL serverLocation) throws Exception {
        URLConnection connection;
        ProxyOptions options = ProxyOptions.getProxyOptions();
        if (options.getUseProxy().booleanValue()) {
            String host = options.getProxyHost();
            Integer port = Integer.valueOf(options.getProxyPort());
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, (int)port));
            connection = serverLocation.openConnection(proxy);
            if (options.getUseProxyAuthentication().booleanValue()) {
                String password = options.getProxyUserName() + ':' + new String(options.getProxyPassword());
                String encodedPassword = Base64.base64Encode((byte[])password.getBytes());
                connection.setRequestProperty("Proxy-Authorization", encodedPassword);
            }
        } else {
            connection = serverLocation.openConnection();
        }
        return connection;
    }

    static String getMasterUsageServerURL() {
        if (_masterServerURL == null) {
            String masterServer = System.getProperty("ide.update.usage.servers");
            if (masterServer == null || masterServer.trim().length() == 0) {
                masterServer = "http://download.oracle.com/otn-pub/jdeveloper/cfu/usage.xml";
            }
            _masterServerURL = masterServer;
        }
        return _masterServerURL;
    }
}

