/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupactionjobs;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backupactionjobs.NewSelectionControl;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.SQLScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.dialogs.MessageDialog;

public class UnconfigureAction
extends ActionDialog {
    private static final String CREDENTIAL = "CREDENTIAL";
    private static final String UNIX_WINDOWS = "UNIX_WINDOWS";
    private static final String SERVERSIDE_DIRECTORY = "SERVERSIDE_DIRECTORY";
    private String _homeDir;
    private ActionControl _unixWindowsCtl;
    private boolean hasWindowsSchedulerSupport;

    protected ScriptProcessor createScriptProcessor() {
        return new SQLScriptProcessor(){

            public void processScript(ScriptProcessorContext scriptProcessorContext) throws Exception {
                if (!UnconfigureAction.this.isSchedulerSupported()) {
                    throw new Exception();
                }
                super.processScript(scriptProcessorContext);
            }

            public String getFailureMessage() {
                return UnconfigureAction.this.isSchedulerSupported() ? UiResources.getString((String)"SQL_FAILURE") : DbaNavigatorResources.getString("BACKUP_NO_WINDOWS_EXECUTION");
            }

            public boolean isCancellable() {
                return true;
            }
        };
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("UNCONFIGURE_ACTION_JOBS_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(final Connection connection) {
        Object object;
        String string;
        Object object2;
        Object object3;
        String string2;
        if (!DbaUtil.isSysdbaRole(connection) || DbaUtil.getDatabaseMajorVersion(connection) < 11) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("SCHEDULER_RMAN_NOT_SUPPORTED"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
            throw new RuntimeException("sysdba and 11g or higher is required for Unconfigure RMAN action");
        }
        boolean bl = false;
        String string3 = null;
        String[] stringArray = null;
        String string4 = null;
        this._homeDir = DbaUtil.getServerHome(connection);
        String string5 = "/";
        if (this._homeDir.contains("\\")) {
            string5 = "\\";
        }
        string3 = this._homeDir.endsWith(string5) ? this._homeDir + "sqldeveloper" + string5 + "dbascripts" + string5 : this._homeDir + string5 + "sqldeveloper" + string5 + "dbascripts" + string5;
        bl = string5.equals("/");
        if (Connections.getInstance().lock(connection)) {
            try {
                string2 = null;
                try {
                    object3 = new HashMap();
                    object2 = DBUtil.getInstance((Connection)connection);
                    object2.setRaiseError(true);
                    string2 = object2.executeOracleQuery(this.getQuery(connection, "getCredentials"), (Map)object3);
                    if (string2 != null) {
                        string = Preferences.getPreferences().getProperties().getString("DBA.DEFAULT_CREDENTIAL");
                        object = string2.getResultSet();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        while (object.next()) {
                            String string6 = object.getString("CREDENTIAL_NAME");
                            arrayList.add(string6);
                            if (!string6.equals(string)) continue;
                            string4 = string;
                        }
                        if (string4 == null && arrayList.size() > 0) {
                            string4 = (String)arrayList.get(0);
                        }
                        stringArray = new String[arrayList.size()];
                        arrayList.toArray(stringArray);
                    }
                    this.hasWindowsSchedulerSupport = false;
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                finally {
                    if (string2 != null) {
                        string2.close();
                    }
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        string2 = string3.replace('\\', '/');
        object3 = string3.replace('/', '\\');
        object2 = new NewSelectionControl(CREDENTIAL, DbaNavigatorResources.getString("CREDENTIAL_LABEL"), stringArray, new NewSelectionControl.NewListener(){

            @Override
            public String getButtonLabel() {
                return DbaNavigatorResources.getString("NEW_CREDENTIAL_LABEL");
            }

            @Override
            public String getNewComboItem() {
                return DbaUtil.createNewCredential(connection);
            }
        });
        ((NewSelectionControl)((Object)object2)).set(string4);
        this._unixWindowsCtl = new ComboBoxActionControl(UNIX_WINDOWS, DbaNavigatorResources.getString("UNIX_WINDOWS_LABEL"), new String[]{"Unix", "Windows"}, bl ? "Unix" : "Windows");
        string = new TextBoxActionControl(SERVERSIDE_DIRECTORY, DbaNavigatorResources.getString("SERVERSIDE_DIRECTORY_LABEL"), string3);
        string.setEditable(false);
        this._unixWindowsCtl.addPropertyChangeListener(new PropertyChangeListener((String)object3, (TextBoxActionControl)string){
            final /* synthetic */ String val$windowsServerDir;
            final /* synthetic */ TextBoxActionControl val$serversideDirectoryCtl;
            {
                this.val$windowsServerDir = string22;
                this.val$serversideDirectoryCtl = textBoxActionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = null;
                string = UnconfigureAction.this._unixWindowsCtl.getValue().get().equals("Unix") ? string2 : this.val$windowsServerDir;
                this.val$serversideDirectoryCtl.set(string);
            }
        });
        object = new ArrayList();
        ((ArrayList)object).add(object2);
        ((ArrayList)object).add(this._unixWindowsCtl);
        ((ArrayList)object).add(string);
        return object;
    }

    private boolean isSchedulerSupported() {
        return this._unixWindowsCtl.getValue().get().equals("Unix") || this.hasWindowsSchedulerSupport;
    }

    protected String getScript(ActionDialog.Values values) {
        if (!this.isSchedulerSupported()) {
            return "-- " + DbaNavigatorResources.getString("BACKUP_NO_WINDOWS_EXECUTION");
        }
        String string = values.get(CREDENTIAL);
        RMANScriptProcessorActionControl.updateDefaultCredential(string);
        String string2 = values.get(SERVERSIDE_DIRECTORY);
        boolean bl = values.get(UNIX_WINDOWS).equals("Unix");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN \n");
        stringBuffer.append("    BEGIN \n");
        stringBuffer.append("        DBMS_SCHEDULER.DROP_PROGRAM( \n");
        stringBuffer.append("          program_name => 'SQLDEV$DBA_CHILD', \n");
        stringBuffer.append("          force => TRUE); \n");
        stringBuffer.append("    EXCEPTION \n");
        stringBuffer.append("        WHEN OTHERS THEN \n");
        stringBuffer.append("          NULL; \n");
        stringBuffer.append("    END; \n");
        stringBuffer.append("    BEGIN \n");
        stringBuffer.append("        DBMS_SCHEDULER.DROP_PROGRAM(  \n");
        stringBuffer.append("          program_name => 'SQLDEV$DBA_DETACHED', \n");
        stringBuffer.append("          force => TRUE); \n");
        stringBuffer.append("    EXCEPTION \n");
        stringBuffer.append("        WHEN OTHERS THEN \n");
        stringBuffer.append("          NULL; \n");
        stringBuffer.append("    END; \n");
        stringBuffer.append("    BEGIN \n");
        stringBuffer.append("        DBMS_SCHEDULER.DROP_JOB(  \n");
        stringBuffer.append("          job_name => 'SQLDEV$DBA_RMDIR', \n");
        stringBuffer.append("          defer => FALSE, force => TRUE); \n");
        stringBuffer.append("    EXCEPTION \n");
        stringBuffer.append("        WHEN OTHERS THEN \n");
        stringBuffer.append("          NULL; \n");
        stringBuffer.append("    END; \n");
        if (bl) {
            stringBuffer.append("    DBMS_SCHEDULER.CREATE_JOB( \n");
            stringBuffer.append("      job_name=>'SQLDEV$DBA_RMDIR', \n");
            stringBuffer.append("      job_type=>'EXECUTABLE', \n");
            stringBuffer.append("      job_action=>'/bin/rm', \n");
            stringBuffer.append("      number_of_arguments => 2, \n");
            stringBuffer.append("      enabled => false, \n");
            stringBuffer.append("      auto_drop =>true); \n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_RMDIR',1,'-r'); \n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_RMDIR',2,'" + string2 + "'); \n");
        } else {
            stringBuffer.append("    DBMS_SCHEDULER.CREATE_JOB( \n");
            stringBuffer.append("      job_name=>'SQLDEV$DBA_RMDIR', \n");
            stringBuffer.append("      job_type=>'EXECUTABLE', \n");
            stringBuffer.append("      job_action=>'cmd', \n");
            stringBuffer.append("      number_of_arguments => 5, \n");
            stringBuffer.append("      enabled => false, \n");
            stringBuffer.append("      auto_drop =>true); \n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_RMDIR',1,'/c');\n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_RMDIR',2,'rmdir');\n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_RMDIR',3,'/S'); \n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_RMDIR',4,'/Q'); \n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_RMDIR',5,'" + string2 + "'); \n");
        }
        stringBuffer.append("    DBMS_SCHEDULER.SET_ATTRIBUTE('SQLDEV$DBA_RMDIR','credential_name','\"" + string + "\"'); \n");
        stringBuffer.append("    DBMS_SCHEDULER.ENABLE('SQLDEV$DBA_RMDIR'); \n");
        stringBuffer.append("END; \n");
        return stringBuffer.toString();
    }
}

