/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupjobs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.GroupActionControl;
import oracle.dbtools.raptor.ui.controls.PasswordActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class DiskEncryptionActionGroup
extends GroupActionControl {
    public static final String USE_RMAN_ENCRYPTION = "USE_RMAN_ENCRYPTION";
    public static final String ENCRYPTION_ALGORITHM = "ENCRYPTION_ALGORITHM";
    public static final String USE_ENCRYPTION_PASSWORDS = "USE_ENCRYPTION_PASSWORDS";
    public static final String PASSWORD_TEXT = "PASSWORD_TEXT";
    private ArrayList<ActionControl> _controls;
    private ActionControl useEncryptionCtl;
    private ActionControl algorithmCtl;
    private BooleanCheckBoxActionControl usePasswordsCtl;
    private PasswordActionControl passwordTextCtl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskEncryptionActionGroup(Connection connection, RMANScriptProcessorActionControl rMANScriptProcessorActionControl) {
        ResultSetWrapper resultSetWrapper;
        String[] stringArray = null;
        String string = null;
        if (Connections.getInstance().lock(connection)) {
            resultSetWrapper = null;
            try {
                HashMap hashMap = new HashMap();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(connection, "getEncryptionAlgorithms"), hashMap);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string2 = resultSet.getString("ALGORITHM_NAME");
                        arrayList.add(string2);
                        if (string != null || !resultSet.getString("IS_DEFAULT").equals("YES")) continue;
                        string = string2;
                    }
                }
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        this.useEncryptionCtl = new BooleanCheckBoxActionControl(USE_RMAN_ENCRYPTION, DbaNavigatorResources.getString("USE_RMAN_ENCRYPTION_LABEL"), false);
        this.algorithmCtl = new ComboBoxActionControl(ENCRYPTION_ALGORITHM, DbaNavigatorResources.getString("ENCRYPTION_ALGORITHM_LABEL"), stringArray, string);
        this.usePasswordsCtl = new BooleanCheckBoxActionControl(USE_ENCRYPTION_PASSWORDS, DbaNavigatorResources.getString("ENCRYPTION_PASSWORDS_LABEL"), false);
        this.passwordTextCtl = new PasswordActionControl(PASSWORD_TEXT, DbaNavigatorResources.getString("PASSWORD_TEXT_LABEL"));
        resultSetWrapper = rMANScriptProcessorActionControl.getProcessingTypeCtl();
        this.enabledControls(this.useEncryptionCtl, this.algorithmCtl, (ActionControl)resultSetWrapper, this.usePasswordsCtl, this.passwordTextCtl);
        resultSetWrapper.addPropertyChangeListener(new PropertyChangeListener((ActionControl)resultSetWrapper){
            final /* synthetic */ ActionControl val$processingTypeCtl;
            {
                this.val$processingTypeCtl = actionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DiskEncryptionActionGroup.this.enabledControls(DiskEncryptionActionGroup.this.useEncryptionCtl, DiskEncryptionActionGroup.this.algorithmCtl, this.val$processingTypeCtl, DiskEncryptionActionGroup.this.usePasswordsCtl, DiskEncryptionActionGroup.this.passwordTextCtl);
            }
        });
        this.useEncryptionCtl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)resultSetWrapper){
            final /* synthetic */ ActionControl val$processingTypeCtl;
            {
                this.val$processingTypeCtl = actionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DiskEncryptionActionGroup.this.enabledControls(DiskEncryptionActionGroup.this.useEncryptionCtl, DiskEncryptionActionGroup.this.algorithmCtl, this.val$processingTypeCtl, DiskEncryptionActionGroup.this.usePasswordsCtl, DiskEncryptionActionGroup.this.passwordTextCtl);
            }
        });
        this.usePasswordsCtl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)resultSetWrapper){
            final /* synthetic */ ActionControl val$processingTypeCtl;
            {
                this.val$processingTypeCtl = actionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DiskEncryptionActionGroup.this.enabledControls(DiskEncryptionActionGroup.this.useEncryptionCtl, DiskEncryptionActionGroup.this.algorithmCtl, this.val$processingTypeCtl, DiskEncryptionActionGroup.this.usePasswordsCtl, DiskEncryptionActionGroup.this.passwordTextCtl);
            }
        });
        this._controls = new ArrayList();
        this._controls.add(this.useEncryptionCtl);
        this._controls.add(this.algorithmCtl);
        this._controls.add((ActionControl)this.usePasswordsCtl);
        this._controls.add((ActionControl)this.passwordTextCtl);
    }

    private void enabledControls(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, BooleanCheckBoxActionControl booleanCheckBoxActionControl, PasswordActionControl passwordActionControl) {
        boolean bl;
        boolean bl2 = Boolean.parseBoolean(actionControl.getValue().get());
        actionControl2.enableUI(bl2);
        boolean bl3 = bl = bl2 && actionControl3.getValue().get().equals(RMANScriptProcessorActionControl.RUN_SCHEDULER_JOB);
        if (!bl) {
            booleanCheckBoxActionControl.set(false);
            passwordActionControl.set("");
        }
        booleanCheckBoxActionControl.enableUI(bl);
        boolean bl4 = bl && Boolean.parseBoolean(booleanCheckBoxActionControl.getValue().get());
        passwordActionControl.enableUI(bl4);
    }

    public ActionControl getUseEncryptionCtl() {
        return this.useEncryptionCtl;
    }

    public ActionControl getAlgorithmCtl() {
        return this.algorithmCtl;
    }

    public ActionControl getUsePasswordsCtl() {
        return this.usePasswordsCtl;
    }

    public ActionControl getPasswordTextCtl() {
        return this.passwordTextCtl;
    }

    public List<ActionControl> getChildControls() {
        return this._controls;
    }

    public static boolean isUseRMANEncryption(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(USE_RMAN_ENCRYPTION));
    }

    public static String getEncryptionAlgorithm(ActionDialog.Lookup lookup) {
        return lookup.get(ENCRYPTION_ALGORITHM);
    }

    public static boolean isEncryptionPasswords(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(USE_ENCRYPTION_PASSWORDS));
    }

    public static String getEncryptionPassword(ActionDialog.Lookup lookup) {
        return lookup.get(PASSWORD_TEXT);
    }
}

