/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditBackupPoliciesAction
extends ActionDialog {
    private static final String AUTOBACKUP = "AUTOBACKUP";
    private static final String AUTOBACKUP_DISK_LOCATION = "AUTOBACKUP_DISK_LOCATION";
    private static final String BACKUP_OPTIMIZATION = "BACKUP_OPTIMIZATION";

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_BACKUP_POLICIES_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        if (Connections.getInstance().lock(connection)) {
            booleanCheckBoxActionControl = null;
            try {
                textBoxActionControl = new HashMap();
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                booleanCheckBoxActionControl = dBUtil.executeOracleQuery(this.getQuery(connection, "getBackupPolicies"), (Map)textBoxActionControl);
                if (booleanCheckBoxActionControl != null) {
                    object = booleanCheckBoxActionControl.getResultSet();
                    while (object.next()) {
                        bl = object.getString(AUTOBACKUP).equals("ON");
                        string = object.getString(AUTOBACKUP_DISK_LOCATION);
                        bl2 = object.getString(BACKUP_OPTIMIZATION).equals("ON");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (booleanCheckBoxActionControl != null) {
                    booleanCheckBoxActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(AUTOBACKUP, DbaNavigatorResources.getString("AUTOBACKUP_LABEL"), bl);
        textBoxActionControl = new TextBoxActionControl(AUTOBACKUP_DISK_LOCATION, DbaNavigatorResources.getString("AUTOBACKUP_DISK_LOCATION_LABEL"), string);
        dBUtil = new BooleanCheckBoxActionControl(BACKUP_OPTIMIZATION, DbaNavigatorResources.getString("BACKUP_OPTIMIZATION_LABEL"), bl2);
        object = new ArrayList();
        ((ArrayList)object).add(booleanCheckBoxActionControl);
        ((ArrayList)object).add(textBoxActionControl);
        ((ArrayList)object).add(dBUtil);
        ((ArrayList)object).add(new SeperatorActionControl());
        ((ArrayList)object).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = Boolean.parseBoolean(values.get(AUTOBACKUP));
        String string = values.get(AUTOBACKUP_DISK_LOCATION);
        boolean bl2 = Boolean.parseBoolean(values.get(BACKUP_OPTIMIZATION));
        stringBuffer.append("CONFIGURE CONTROLFILE AUTOBACKUP ");
        stringBuffer.append(bl ? "ON" : "OFF");
        stringBuffer.append(";\n");
        stringBuffer.append("CONFIGURE CONTROLFILE AUTOBACKUP FORMAT FOR DEVICE TYPE DISK TO '");
        stringBuffer.append(string);
        stringBuffer.append("';\n");
        stringBuffer.append("CONFIGURE BACKUP OPTIMIZATION ");
        stringBuffer.append(bl2 ? "ON" : "OFF");
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }
}

