/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditFlashRecoverySettingsAction
extends ActionDialog {
    private static final String FLASH_RECOVERY_FILE_DEST = "FLASH_RECOVERY_FILE_DEST";
    private static final String FLASH_AREA_SIZE = "FLASH_AREA_SIZE";
    private static final String FLASHBACK_RETENTION_TIME = "FLASHBACK_RETENTION_TIME";
    private static final String SPFILE_ONLY = "SPFILE_ONLY";

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_FLASH_RECOVERY_SETTINGS_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        ResultSet resultSet;
        DBUtil dBUtil;
        FileSizeActionControl fileSizeActionControl;
        TextBoxActionControl textBoxActionControl;
        String string = null;
        long l = 0L;
        int n = 0;
        if (Connections.getInstance().lock(connection)) {
            textBoxActionControl = null;
            try {
                fileSizeActionControl = new HashMap();
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                textBoxActionControl = dBUtil.executeOracleQuery(this.getQuery(connection, "getFlashRecoverySettings"), (Map)fileSizeActionControl);
                if (textBoxActionControl != null) {
                    resultSet = textBoxActionControl.getResultSet();
                    while (resultSet.next()) {
                        string = resultSet.getString(FLASH_RECOVERY_FILE_DEST);
                        l = resultSet.getLong(FLASH_AREA_SIZE);
                        n = resultSet.getInt(FLASHBACK_RETENTION_TIME);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (textBoxActionControl != null) {
                    textBoxActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        textBoxActionControl = new TextBoxActionControl(FLASH_RECOVERY_FILE_DEST, DbaNavigatorResources.getString("FLASH_RECOVERY_FILE_DEST_LABEL"), string);
        fileSizeActionControl = new FileSizeActionControl(FLASH_AREA_SIZE, DbaNavigatorResources.getString("FLASH_AREA_SIZE_LABEL"), l);
        dBUtil = new TextBoxActionControl(FLASHBACK_RETENTION_TIME, DbaNavigatorResources.getString("FLASHBACK_RETENTION_TIME_LABEL"), Integer.toString(n), TextBoxActionControl.getIntegerFormat());
        resultSet = new BooleanCheckBoxActionControl(SPFILE_ONLY, DbaNavigatorResources.getString("SPFILE_ONLY_LABEL"), false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)fileSizeActionControl);
        arrayList.add((ActionControl)dBUtil);
        arrayList.add((ActionControl)resultSet);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        string = Boolean.parseBoolean(values.get(SPFILE_ONLY)) ? " SCOPE=SPFILE;\n" : " SCOPE=BOTH;\n";
        stringBuffer.append("ALTER SYSTEM SET db_recovery_file_dest = \"");
        stringBuffer.append(values.get(FLASH_RECOVERY_FILE_DEST));
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("ALTER SYSTEM SET db_recovery_file_dest_size = ");
        stringBuffer.append(values.get(FLASH_AREA_SIZE, "Bytes"));
        stringBuffer.append(string);
        stringBuffer.append("ALTER SYSTEM SET db_flashback_retention_target = ");
        stringBuffer.append(values.get(FLASHBACK_RETENTION_TIME));
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

