/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditMediaRecoverySettingsAction
extends ActionDialog {
    private static final String LOG_ARCHIVE_FORMAT = "LOG_ARCHIVE_FORMAT";
    private static final String SUPPLEMENTAL_LOG_DATA_MIN = "SUPPLEMENTAL_LOG_DATA_MIN";

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_MEDIA_RECOVERY_SETTINGS_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl;
        TextBoxActionControl textBoxActionControl;
        String string = null;
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            textBoxActionControl = null;
            try {
                booleanCheckBoxActionControl = new HashMap();
                object = DBUtil.getInstance((Connection)connection);
                object.setRaiseError(true);
                textBoxActionControl = object.executeOracleQuery(this.getQuery(connection, "getMediaRecoverySettings"), (Map)booleanCheckBoxActionControl);
                if (textBoxActionControl != null) {
                    ResultSet resultSet = textBoxActionControl.getResultSet();
                    while (resultSet.next()) {
                        string = resultSet.getString(LOG_ARCHIVE_FORMAT);
                        bl = resultSet.getString(SUPPLEMENTAL_LOG_DATA_MIN).equals("YES");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (textBoxActionControl != null) {
                    textBoxActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        textBoxActionControl = new TextBoxActionControl(LOG_ARCHIVE_FORMAT, DbaNavigatorResources.getString("LOG_ARCHIVE_FORMAT_LABEL"), string);
        booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(SUPPLEMENTAL_LOG_DATA_MIN, DbaNavigatorResources.getString("SUPPLEMENTAL_LOG_DATA_MIN_LABEL"), bl);
        object = new ArrayList();
        ((ArrayList)object).add(textBoxActionControl);
        ((ArrayList)object).add(booleanCheckBoxActionControl);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = values.get(LOG_ARCHIVE_FORMAT);
        boolean bl = Boolean.parseBoolean(values.get(SUPPLEMENTAL_LOG_DATA_MIN));
        stringBuffer.append("ALTER SYSTEM SET log_archive_format = \"");
        stringBuffer.append(string);
        stringBuffer.append("\" SCOPE=SPFILE;\n");
        if (bl) {
            stringBuffer.append("ALTER DATABASE ADD SUPPLEMENTAL LOG DATA;\n");
        } else {
            stringBuffer.append("ALTER DATABASE DROP SUPPLEMENTAL LOG DATA;\n");
        }
        return stringBuffer.toString();
    }
}

