/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditRetentionPoliciesAction
extends ActionDialog {
    private static final String RETENTION_POLICY = "RETENTION_POLICY";
    private static final String RECOVERY_WINDOW_DAYS = "RECOVERY_WINDOW_DAYS";
    private static final String REDUNDANCY_COUNT = "REDUNDANCY_COUNT";
    private static final String RETAIN_ALL = DbaNavigatorResources.getString("RETENTION_POLICY_RETAIN_ALL");
    private static final String RETAIN_FOR_WINDOW = DbaNavigatorResources.getString("RETENTION_POLICY_RETAIN_FOR_WINDOW");
    private static final String RETAIN_REDUNDANT = DbaNavigatorResources.getString("RETENTION_POLICY_RETAIN_REDUNDANT");

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_RETENTION_POLICIES_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        ResultSetWrapper resultSetWrapper;
        String string = null;
        int n = 0;
        int n2 = 0;
        if (Connections.getInstance().lock(connection)) {
            resultSetWrapper = null;
            try {
                textBoxActionControl = new HashMap();
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(connection, "getRetentionPolicies"), textBoxActionControl);
                if (resultSetWrapper != null) {
                    object = resultSetWrapper.getResultSet();
                    while (object.next()) {
                        string = object.getString(RETENTION_POLICY);
                        n = object.getInt(RECOVERY_WINDOW_DAYS);
                        n2 = object.getInt(REDUNDANCY_COUNT);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        resultSetWrapper = new ComboBoxActionControl(RETENTION_POLICY, DbaNavigatorResources.getString("RETENTION_POLICY_LABEL"), new String[]{RETAIN_ALL, RETAIN_FOR_WINDOW, RETAIN_REDUNDANT}, string);
        textBoxActionControl = new TextBoxActionControl(RECOVERY_WINDOW_DAYS, DbaNavigatorResources.getString("RECOVERY_WINDOW_DAYS_LABEL"), Integer.toString(n), TextBoxActionControl.getIntegerFormat());
        dBUtil = new TextBoxActionControl(REDUNDANCY_COUNT, DbaNavigatorResources.getString("REDUNDANCY_COUNT_LABEL"), Integer.toString(n2), TextBoxActionControl.getIntegerFormat());
        this.onChangePolicy((ActionControl)resultSetWrapper, (ActionControl)textBoxActionControl, (ActionControl)dBUtil);
        resultSetWrapper.addPropertyChangeListener(new PropertyChangeListener((ActionControl)resultSetWrapper, (ActionControl)textBoxActionControl, (ActionControl)dBUtil){
            final /* synthetic */ ActionControl val$retentionPolicyCtl;
            final /* synthetic */ ActionControl val$recoveryWindowDaysCtl;
            final /* synthetic */ ActionControl val$redundancyCountCtl;
            {
                this.val$retentionPolicyCtl = actionControl;
                this.val$recoveryWindowDaysCtl = actionControl2;
                this.val$redundancyCountCtl = actionControl3;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditRetentionPoliciesAction.this.onChangePolicy(this.val$retentionPolicyCtl, this.val$recoveryWindowDaysCtl, this.val$redundancyCountCtl);
            }
        });
        object = new ArrayList();
        ((ArrayList)object).add(resultSetWrapper);
        ((ArrayList)object).add(textBoxActionControl);
        ((ArrayList)object).add(dBUtil);
        ((ArrayList)object).add(new SeperatorActionControl());
        ((ArrayList)object).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        return object;
    }

    private void onChangePolicy(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3) {
        String string = actionControl.getValue().get();
        if (string.equals(RETAIN_ALL)) {
            actionControl2.enableUI(false);
            actionControl3.enableUI(false);
        } else if (string.equals(RETAIN_FOR_WINDOW)) {
            actionControl2.enableUI(true);
            actionControl3.enableUI(false);
        } else if (string.equals(RETAIN_REDUNDANT)) {
            actionControl2.enableUI(false);
            actionControl3.enableUI(true);
        }
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = values.get(RETENTION_POLICY);
        int n = Integer.parseInt(values.get(RECOVERY_WINDOW_DAYS));
        int n2 = Integer.parseInt(values.get(REDUNDANCY_COUNT));
        stringBuffer.append("CONFIGURE RETENTION POLICY TO ");
        if (string.equals(RETAIN_ALL)) {
            stringBuffer.append("NONE");
        } else if (string.equals(RETAIN_FOR_WINDOW)) {
            stringBuffer.append("RECOVERY WINDOW OF ");
            stringBuffer.append(n);
            stringBuffer.append(" DAYS");
        } else if (string.equals(RETAIN_REDUNDANT)) {
            stringBuffer.append("REDUNDANCY ");
            stringBuffer.append(n2);
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }
}

