/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.SQLPLUSScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class SQLPlusSwitchArchiveLogModeAction
extends ActionDialog {
    private static final String ARCHIVELOG_MODE_ENABLED = "ARCHIVELOG_MODE_ENABLED";

    protected ScriptProcessor createScriptProcessor() {
        return new SQLPLUSScriptProcessor(this){

            @Override
            protected String getMountCommand(ScriptProcessorContext scriptProcessorContext) {
                boolean bl = Boolean.parseBoolean(scriptProcessorContext.getParameter(SQLPlusSwitchArchiveLogModeAction.ARCHIVELOG_MODE_ENABLED));
                return "ALTER DATABASE " + (bl ? "ARCHIVELOG" : "NOARCHIVELOG");
            }
        };
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("SWITCH_ARCHIVE_LOG_MODE_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Cloneable cloneable;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl;
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            booleanCheckBoxActionControl = null;
            try {
                cloneable = new HashMap();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                booleanCheckBoxActionControl = dBUtil.executeOracleQuery(this.getQuery(connection, "getArchiveLogMode"), (Map)((Object)cloneable));
                if (booleanCheckBoxActionControl != null) {
                    ResultSet resultSet = booleanCheckBoxActionControl.getResultSet();
                    while (resultSet.next()) {
                        bl = !resultSet.getString("LOG_MODE").equals("NOARCHIVELOG");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (booleanCheckBoxActionControl != null) {
                    booleanCheckBoxActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(ARCHIVELOG_MODE_ENABLED, DbaNavigatorResources.getString("ENABLE_ARCHIVELOG_MODE_LABEL"), bl);
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(booleanCheckBoxActionControl);
        return cloneable;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = Boolean.parseBoolean(values.get(ARCHIVELOG_MODE_ENABLED));
        stringBuffer.append("SHUTDOWN IMMEDIATE\n");
        stringBuffer.append("CONNECT / AS SYSDBA\n");
        stringBuffer.append("STARTUP MOUNT\n");
        stringBuffer.append("ALTER DATABASE ");
        if (bl) {
            stringBuffer.append("ARCHIVELOG;\n");
        } else {
            stringBuffer.append("NOARCHIVELOG;\n");
        }
        stringBuffer.append("ALTER DATABASE OPEN;\n");
        stringBuffer.append("EXIT\n");
        return stringBuffer.toString();
    }
}

