/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.SQLPLUSScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class SQLPlusSwitchFlashbackDatabaseAction
extends ActionDialog {
    private static final String FLASHBACK_ON = "FLASHBACK_ON";

    protected ScriptProcessor createScriptProcessor() {
        return new SQLPLUSScriptProcessor(this){

            @Override
            protected String getMountCommand(ScriptProcessorContext scriptProcessorContext) {
                boolean bl = Boolean.parseBoolean(scriptProcessorContext.getParameter(SQLPlusSwitchFlashbackDatabaseAction.FLASHBACK_ON));
                return "ALTER DATABASE FLASHBACK " + (bl ? "ON" : "OFF");
            }
        };
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("SWITCH_FLASHBACK_DATABASE_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Cloneable cloneable;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl;
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            booleanCheckBoxActionControl = null;
            try {
                cloneable = new HashMap();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                booleanCheckBoxActionControl = dBUtil.executeOracleQuery(this.getQuery(connection, "getFlashbackOn"), (Map)((Object)cloneable));
                if (booleanCheckBoxActionControl != null) {
                    ResultSet resultSet = booleanCheckBoxActionControl.getResultSet();
                    while (resultSet.next()) {
                        bl = !resultSet.getString(FLASHBACK_ON).equals("NO");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (booleanCheckBoxActionControl != null) {
                    booleanCheckBoxActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(FLASHBACK_ON, DbaNavigatorResources.getString("ENABLE_FLASHBACK_DATABASE_LABEL"), bl);
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(booleanCheckBoxActionControl);
        return cloneable;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = Boolean.parseBoolean(values.get(FLASHBACK_ON));
        stringBuffer.append("SHUTDOWN IMMEDIATE\n");
        stringBuffer.append("CONNECT / AS SYSDBA\n");
        stringBuffer.append("STARTUP MOUNT\n");
        stringBuffer.append("ALTER DATABASE FLASHBACK ");
        if (bl) {
            stringBuffer.append("ON;\n");
        } else {
            stringBuffer.append("OFF;\n");
        }
        stringBuffer.append("ALTER DATABASE OPEN;\n");
        stringBuffer.append("EXIT\n");
        return stringBuffer.toString();
    }
}

