/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backuptabs;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditTapeBackupSetSettingsTab
extends ActionDialogTab {
    public static final String DATAFILE_COPIES = "DATAFILE_COPIES";
    public static final String ARCHIVELOG_COPIES = "ARCHIVELOG_COPIES";
    private boolean _includeProcessorAction;

    public EditTapeBackupSetSettingsTab() {
        super(null, null);
        this._includeProcessorAction = true;
    }

    public EditTapeBackupSetSettingsTab(String string) {
        super(string, DbaNavigatorResources.getString("TAPE_BACKUP_SET_TAB"));
        this._includeProcessorAction = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActionControl> createControls(Connection connection) {
        Object object;
        TextBoxActionControl textBoxActionControl;
        TextBoxActionControl textBoxActionControl2;
        int n = 0;
        int n2 = 0;
        if (Connections.getInstance().lock(connection)) {
            textBoxActionControl2 = null;
            try {
                textBoxActionControl = new HashMap();
                object = DBUtil.getInstance((Connection)connection);
                object.setRaiseError(true);
                textBoxActionControl2 = object.executeOracleQuery(this.getQuery(connection, "getTapeBackupSetSettings"), textBoxActionControl);
                if (textBoxActionControl2 != null) {
                    ResultSet resultSet = textBoxActionControl2.getResultSet();
                    while (resultSet.next()) {
                        n = resultSet.getInt(DATAFILE_COPIES);
                        n2 = resultSet.getInt(ARCHIVELOG_COPIES);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (textBoxActionControl2 != null) {
                    textBoxActionControl2.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        textBoxActionControl2 = new TextBoxActionControl(DATAFILE_COPIES, DbaNavigatorResources.getString("DATAFILE_COPIES_LABEL"), Integer.toString(n), TextBoxActionControl.getIntegerFormat());
        textBoxActionControl = new TextBoxActionControl(ARCHIVELOG_COPIES, DbaNavigatorResources.getString("ARCHIVELOG_COPIES_LABEL"), Integer.toString(n2), TextBoxActionControl.getIntegerFormat());
        object = new ArrayList();
        ((ArrayList)object).add(textBoxActionControl2);
        ((ArrayList)object).add(textBoxActionControl);
        if (this._includeProcessorAction) {
            ((ArrayList)object).add(new SeperatorActionControl());
            ((ArrayList)object).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        }
        return object;
    }

    public static int getDatafileCopies(ActionDialog.Lookup lookup) {
        return Integer.parseInt(lookup.get(DATAFILE_COPIES));
    }

    public static int getArchiveLogCopies(ActionDialog.Lookup lookup) {
        return Integer.parseInt(lookup.get(ARCHIVELOG_COPIES));
    }
}

