/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.containerrmplans;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class AddOrEditItemAction
extends ActionDialog {
    private static final String PDBNAME = "PDBName";
    private static final String SHARES = "Shares";
    private static final String UTILIZATION_LIMIT = "UtilizationLimit";
    private static final String PARALLEL_SERVER_LIMIT = "ParallelServerLimit";

    protected String getTitle() {
        String string = null;
        Operation operation = this.getOperation();
        string = operation == Operation.EDIT_NORMAL ? DbaNavigatorResources.getString("EDIT_ITEM_TITLE") : (operation == Operation.EDIT_DEFAULT ? DbaNavigatorResources.getString("EDIT_DEFAULT_ITEM_TITLE") : (operation == Operation.EDIT_AUTOTASK ? DbaNavigatorResources.getString("EDIT_AUTOTASK_ITEM_TITLE") : DbaNavigatorResources.getString("CREATE_ITEM_TITLE")));
        return string;
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        ResultSet resultSet;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        TextBoxActionControl textBoxActionControl2;
        Operation operation = this.getOperation();
        String string = null;
        String string2 = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        switch (operation) {
            case ADD: {
                string = this.getObjectName();
                break;
            }
            case EDIT_NORMAL: {
                string = this.getDBObjectName();
                string2 = this.getDBObjectChildName();
                break;
            }
            case EDIT_DEFAULT: {
                string = this.getObjectName();
                string2 = "ORA$DEFAULT_PDB_DIRECTIVE";
                break;
            }
            case EDIT_AUTOTASK: {
                string = this.getObjectName();
                string2 = "ORA$AUTOTASK";
            }
        }
        if (operation != Operation.ADD && Connections.getInstance().lock(connection)) {
            textBoxActionControl2 = null;
            try {
                textBoxActionControl = new HashMap();
                textBoxActionControl.put("PDB", string2);
                textBoxActionControl.put("PLAN", string);
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                textBoxActionControl2 = dBUtil.executeOracleQuery(this.getQuery(connection, "getDirective"), (Map)textBoxActionControl);
                if (textBoxActionControl2 != null) {
                    resultSet = textBoxActionControl2.getResultSet();
                    while (resultSet.next()) {
                        n = this.getDirective(resultSet, "SHARES");
                        n2 = this.getDirective(resultSet, "UTILIZATION_LIMIT");
                        n3 = this.getDirective(resultSet, "PARALLEL_SERVER_LIMIT");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (textBoxActionControl2 != null) {
                    textBoxActionControl2.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        textBoxActionControl2 = null;
        if (operation != Operation.ADD) {
            textBoxActionControl2 = new TextBoxActionControl(PDBNAME, DbaNavigatorResources.getString("PDB_NAME_LABEL"), string2);
            textBoxActionControl2.setEditable(false);
        } else {
            textBoxActionControl = new HashMap();
            textBoxActionControl2 = new SqlComboBoxActionControl(PDBNAME, DbaNavigatorResources.getString("PDB_NAME_LABEL"), connection, this.getQuery(connection, "getPDBItems"), textBoxActionControl, string2);
        }
        textBoxActionControl = new TextBoxActionControl(SHARES, DbaNavigatorResources.getString("SHARES_LABEL"), Integer.toString(n), TextBoxActionControl.getIntegerFormat());
        dBUtil = new TextBoxActionControl(UTILIZATION_LIMIT, DbaNavigatorResources.getString("UTILIZATION_LIMIT_LABEL"), Integer.toString(n2), TextBoxActionControl.getIntegerFormat());
        resultSet = new TextBoxActionControl(PARALLEL_SERVER_LIMIT, DbaNavigatorResources.getString("PARALLEL_SERVER_LIMIT_LABEL"), Integer.toString(n3), TextBoxActionControl.getIntegerFormat());
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        arrayList.add((ActionControl)resultSet);
        return arrayList;
    }

    private int getDirective(ResultSet resultSet, String string) throws SQLException {
        int n = -1;
        try {
            n = Integer.parseInt(resultSet.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CLEAR_PENDING_AREA();\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_PENDING_AREA();\n");
        if (this.getOperation() == Operation.ADD) {
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_CDB_PLAN_DIRECTIVE(\n");
            stringBuffer.append("        PLAN => '");
            stringBuffer.append(this.getObjectName());
            stringBuffer.append("',\n");
            stringBuffer.append("        PLUGGABLE_DATABASE => '");
            stringBuffer.append(values.get(PDBNAME));
            stringBuffer.append("',\n");
            stringBuffer.append("        SHARES => ");
            stringBuffer.append(values.get(SHARES));
            stringBuffer.append(",\n");
            stringBuffer.append("        UTILIZATION_LIMIT => ");
            stringBuffer.append(values.get(UTILIZATION_LIMIT));
            stringBuffer.append(",\n");
            stringBuffer.append("        PARALLEL_SERVER_LIMIT => ");
            stringBuffer.append(values.get(PARALLEL_SERVER_LIMIT));
            stringBuffer.append(");\n");
        } else {
            switch (this.getOperation()) {
                case EDIT_NORMAL: {
                    stringBuffer.append("    DBMS_RESOURCE_MANAGER.UPDATE_CDB_PLAN_DIRECTIVE(\n");
                    break;
                }
                case EDIT_DEFAULT: {
                    stringBuffer.append("    DBMS_RESOURCE_MANAGER.UPDATE_CDB_DEFAULT_DIRECTIVE(\n");
                    break;
                }
                case EDIT_AUTOTASK: {
                    stringBuffer.append("    DBMS_RESOURCE_MANAGER.UPDATE_CDB_AUTOTASK_DIRECTIVE(\n");
                }
            }
            stringBuffer.append("        PLAN => '");
            stringBuffer.append(this.getDBObjectName());
            stringBuffer.append("',\n");
            if (this.getOperation() == Operation.EDIT_NORMAL) {
                stringBuffer.append("        PLUGGABLE_DATABASE => '");
                stringBuffer.append(values.get(PDBNAME));
                stringBuffer.append("',\n");
            }
            stringBuffer.append("        NEW_SHARES => ");
            stringBuffer.append(values.get(SHARES));
            stringBuffer.append(",\n");
            stringBuffer.append("        NEW_UTILIZATION_LIMIT => ");
            stringBuffer.append(values.get(UTILIZATION_LIMIT));
            stringBuffer.append(",\n");
            stringBuffer.append("        NEW_PARALLEL_SERVER_LIMIT => ");
            stringBuffer.append(values.get(PARALLEL_SERVER_LIMIT));
            stringBuffer.append(");\n");
        }
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.VALIDATE_PENDING_AREA();\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.SUBMIT_PENDING_AREA();\n");
        stringBuffer.append("END;\n");
        return stringBuffer.toString();
    }

    private static enum Operation {
        ADD,
        EDIT_NORMAL,
        EDIT_DEFAULT,
        EDIT_AUTOTASK;

    }
}

