/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.dbagraphics;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javax.swing.SwingUtilities;
import oracle.dbtools.parser.plsql.IdentifierDefinitionLookup;
import oracle.dbtools.raptor.dba.navigator.actions.dbagraphics.FxQueryInfo;
import oracle.dbtools.raptor.dba.navigator.actions.dbagraphics.FxQueryViewer;
import oracle.dbtools.raptor.dba.navigator.net.DBAURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public abstract class FxQueryController
implements Initializable {
    private List<FxQueryInfo<?, ?>> queryInfoList = new ArrayList();
    private FxQueryViewer fxQueryViewer;
    private ViewListener viewListener = new ViewListener(){

        public void viewActivated(ViewEvent viewEvent) {
        }

        public void viewDeactivated(ViewEvent viewEvent) {
        }

        public void viewClosed(ViewEvent viewEvent) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FxQueryController.this.setConnection(null);
                }
            });
            FxQueryController.this.fxQueryViewer.removeViewListener(FxQueryController.this.viewListener);
            FxQueryController.this.fxQueryViewer.getGUI().removeComponentListener(FxQueryController.this.componentListener);
        }
    };
    private ComponentListener componentListener = new ComponentListener(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.setViewActive(true);
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            this.setViewActive(false);
        }

        private void setViewActive(boolean bl) {
            for (FxQueryInfo fxQueryInfo : FxQueryController.this.queryInfoList) {
                fxQueryInfo.setViewActive(bl);
            }
        }
    };
    private FxQueryViewer parentFxQueryViewer;

    protected void add(FxQueryInfo<?, ?> fxQueryInfo) {
        if (!this.queryInfoList.contains(fxQueryInfo)) {
            this.queryInfoList.add(fxQueryInfo);
        }
    }

    public void setConnection(String string) {
        for (FxQueryInfo<?, ?> fxQueryInfo : this.queryInfoList) {
            fxQueryInfo.setFqConnectionName(string);
        }
    }

    public void setUpdateInterval(long l) {
        for (FxQueryInfo<?, ?> fxQueryInfo : this.queryInfoList) {
            fxQueryInfo.setUpdateInterval(l);
        }
    }

    public void update() {
        for (FxQueryInfo<?, ?> fxQueryInfo : this.queryInfoList) {
            fxQueryInfo.update();
        }
    }

    public void setFxQueryViewer(final FxQueryViewer fxQueryViewer) {
        this.fxQueryViewer = fxQueryViewer;
        fxQueryViewer.addViewListener(this.viewListener);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                fxQueryViewer.getGUI().addComponentListener(FxQueryController.this.componentListener);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected FxQueryViewer getFxQueryViewer() {
        return this.fxQueryViewer;
    }

    public void setParentFxQueryViewer(FxQueryViewer fxQueryViewer) {
        this.parentFxQueryViewer = fxQueryViewer;
    }

    @FXML
    protected void raiseParentFxQueryViewer(ActionEvent actionEvent) {
        this.raiseEditor((Editor)this.parentFxQueryViewer);
    }

    private void raiseEditor(final Editor editor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                if (editor != null) {
                    for (EditorInfo editorInfo : editorManager.getEditorsInfo()) {
                        if (editor != editorInfo._getEditor()) continue;
                        editorManager.activateEditor(editorInfo);
                        break;
                    }
                }
            }
        });
    }

    protected void performDrill(String string, String string2) {
        String string3 = this.getFxQueryViewer().getFqConnectionName();
        String string4 = "SYS";
        try {
            string4 = Connections.getInstance().getDatabase(string3).getUserName();
        }
        catch (DBException dBException) {
            Logger.severe(this.getClass(), (Throwable)dBException);
        }
        URL uRL = DBAURLFormatHelper.getURL("sqldev.dbanav", string3, null, string4, string);
        if (ModelUtil.hasLength((String)string2)) {
            uRL = DBAURLFormatHelper.getURL(uRL, string2);
        }
        final URL uRL2 = uRL;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdentifierDefinitionLookup.goTo((URL)uRL2, (boolean)false);
            }
        });
    }

    protected Context createContext() {
        Context context = new Context(this.fxQueryViewer.getContext());
        return context;
    }

    protected void raiseFxQueryViewer(Class<? extends FxQueryViewer> clazz) {
        this.raiseFxQueryViewer(clazz, this.createContext());
    }

    protected void raiseFxQueryViewer(final Class<? extends FxQueryViewer> clazz, final Context context) {
        final EditorManager editorManager = EditorManager.getEditorManager();
        Editor editor = null;
        for (Editor editor2 : editorManager.getAllEditors()) {
            if (clazz != editor2.getClass() || !context.equals((Object)editor2.getContext())) continue;
            editor = editor2;
            break;
        }
        if (editor != null) {
            this.raiseEditor(editor);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                    waitCursor.show();
                    try {
                        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, clazz);
                        Editor editor = editorManager.openEditor(openEditorOptions);
                        assert (null == editor || editor != null);
                    }
                    finally {
                        waitCursor.hide();
                    }
                }
            });
        }
    }
}

