/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.dbagraphics;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Parent;
import javafx.util.BuilderFactory;
import oracle.dbtools.raptor.dba.navigator.actions.dbagraphics.FxQueryController;
import oracle.dbtools.util.Logger;
import oracle.javatools.util.ModelUtil;

public class FxmlInfo {
    String fxmlFile;
    String resourceBundle;
    ClassLoader classLoader;
    Parent parent;
    FxQueryController fxQueryController;

    public Parent getFxmlUI() {
        return this.parent;
    }

    public FxQueryController getController() {
        return this.fxQueryController;
    }

    FxmlInfo(String string, String string2, ClassLoader classLoader) {
        assert (ModelUtil.hasLength((String)string));
        assert (ModelUtil.hasLength((String)string2));
        assert (classLoader != null);
        this.fxmlFile = string;
        this.resourceBundle = string2;
        this.classLoader = classLoader;
        this.load();
    }

    public void setConnection(String string) {
        if (this.fxQueryController != null) {
            this.fxQueryController.setConnection(string);
        }
    }

    public void setUpdateInterval(long l) {
        if (this.fxQueryController != null) {
            this.fxQueryController.setUpdateInterval(l);
        }
    }

    public void update() {
        if (this.fxQueryController != null) {
            this.fxQueryController.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        URL uRL = this.classLoader.getResource(this.fxmlFile);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.resourceBundle, Locale.getDefault(), this.classLoader);
        FXMLLoader fXMLLoader = new FXMLLoader();
        fXMLLoader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        fXMLLoader.setClassLoader(this.classLoader);
        fXMLLoader.setLocation(uRL);
        fXMLLoader.setResources(resourceBundle);
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            this.parent = (Parent)fXMLLoader.load(inputStream);
            Object object = fXMLLoader.getController();
            if (object instanceof FxQueryController) {
                this.fxQueryController = (FxQueryController)object;
            }
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Logger.warn(this.getClass(), (Throwable)iOException);
                }
            }
        }
    }
}

