/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.dbagraphics;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import oracle.dbtools.raptor.JFXFactoryEnvironment;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.javatools.dialogs.ExceptionDialog;

public class JFXPanelFactory {
    private static final Class<?> CLAZZ = JFXPanelFactory.class;
    private static String JAVAFX_HOME_DESC = "JAVAFX_HOME=" + (JFXFactoryEnvironment.JAVAFX_HOME == null ? "null" : JFXFactoryEnvironment.JAVAFX_HOME);
    private static Throwable JAVAFX_RUNTIME_LINK_ERROR;
    private static JFXPanel BLOCK_IMPLICIT_CLOSE;
    private static ShutdownHook fxShutdownHook;
    private static String JAVAFX_VERSION;
    private static boolean JAVAFX_VERSION_IS_2dot2;

    public static JFXPanel createJFXPanel() {
        JFXFactoryEnvironment.initialize();
        JAVAFX_HOME_DESC = "JAVAFX_HOME=" + (null == JFXFactoryEnvironment.JAVAFX_HOME ? "null" : JFXFactoryEnvironment.JAVAFX_HOME);
        JFXPanel jFXPanel = null;
        try {
            jFXPanel = JFXPanelFactory.createJFXPanelImpl();
            JFXPanelFactory.checkVersion();
            JFXPanelFactory.addShutdownHook();
        }
        catch (Throwable throwable) {
            jFXPanel = null;
            String string = "Problem initializing the JavaFX runtime. This feature requires JavaFX.";
            string = string + '\n' + JAVAFX_HOME_DESC;
            Logger.warn(CLAZZ, (String)string, (Throwable)throwable);
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)string);
        }
        return jFXPanel;
    }

    private static void checkEnvironment() throws IOException {
        File file;
        String string = JFXFactoryEnvironment.JAVAFX_HOME;
        if (string != null && !(file = new File(string)).exists()) {
            throw new IOException(JAVAFX_HOME_DESC + " directory does not exist.");
        }
    }

    private static JFXPanel createJFXPanelImpl() throws Throwable {
        JFXPanel jFXPanel = null;
        try {
            if (JAVAFX_RUNTIME_LINK_ERROR != null) {
                throw JAVAFX_RUNTIME_LINK_ERROR;
            }
            jFXPanel = new JFXPanel();
        }
        catch (Throwable throwable) {
            if (throwable.getCause() instanceof UnsatisfiedLinkError) {
                JAVAFX_RUNTIME_LINK_ERROR = throwable;
            }
            throw throwable;
        }
        return jFXPanel;
    }

    private static void addShutdownHook() {
        if (JAVAFX_VERSION_IS_2dot2) {
            Platform.setImplicitExit((boolean)false);
        } else {
            try {
                BLOCK_IMPLICIT_CLOSE = JFXPanelFactory.createJFXPanelImpl();
            }
            catch (Throwable throwable) {
                Logger.ignore(CLAZZ, (Throwable)throwable);
            }
        }
        fxShutdownHook = new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BLOCK_IMPLICIT_CLOSE = null;
                        Platform.exit();
                    }
                });
            }
        };
        ExitCommand.removeShutdownHook((ShutdownHook)fxShutdownHook);
        ExitCommand.addShutdownHook((ShutdownHook)fxShutdownHook);
    }

    private static void checkVersion() {
        String string = "javafx.runtime.version";
        Object object = System.getProperties().get(string);
        String string2 = JAVAFX_VERSION = object == null ? "null" : object.toString();
        if (-1 != JAVAFX_VERSION.indexOf("2.2")) {
            JAVAFX_VERSION_IS_2dot2 = true;
            Logger.info(CLAZZ, (String)(string + '=' + JAVAFX_VERSION));
        } else {
            Logger.warn(CLAZZ, (String)(string + '=' + JAVAFX_VERSION + " Not officially supported!"));
        }
    }
}

