/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.performance;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.DelayedLoadingComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.DelayedLoadingComboBoxLoader;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class CreateBaselineAction
extends ActionDialog {
    private static final String BASELINE_NAME = "BaselineName";
    private static final String START_SNAPSHOT = "StartSnapshot";
    private static final String END_SNAPSHOT = "EndSnapshot";

    protected String getTitle() {
        return DbaNavigatorResources.getString("CREATE_BASELINE_TITLE");
    }

    protected List<ActionControl> createControls(final Connection connection) {
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(BASELINE_NAME, DbaNavigatorResources.getString("BASELINE_NAME_LABEL"), "");
        DelayedLoadingComboBoxActionControl delayedLoadingComboBoxActionControl = new DelayedLoadingComboBoxActionControl(START_SNAPSHOT, DbaNavigatorResources.getString("START_SNAPSHOT_LABEL"), (Object)"", new DelayedLoadingComboBoxLoader(){

            public List<Object> getComboContents() throws TaskException {
                return CreateBaselineAction.this.getSnapshotIds(connection);
            }
        }, true);
        DelayedLoadingComboBoxActionControl delayedLoadingComboBoxActionControl2 = new DelayedLoadingComboBoxActionControl(END_SNAPSHOT, DbaNavigatorResources.getString("END_SNAPSHOT_LABEL"), (Object)"", new DelayedLoadingComboBoxLoader(){

            public List<Object> getComboContents() throws TaskException {
                return CreateBaselineAction.this.getSnapshotIds(connection);
            }
        }, true);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)delayedLoadingComboBoxActionControl);
        arrayList.add((ActionControl)delayedLoadingComboBoxActionControl2);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN\n");
        stringBuffer.append("   DBMS_WORKLOAD_REPOSITORY.CREATE_BASELINE(START_SNAP_ID => '");
        stringBuffer.append(this.snapshotId(values.get(START_SNAPSHOT)));
        stringBuffer.append("', END_SNAP_ID => '");
        stringBuffer.append(this.snapshotId(values.get(END_SNAPSHOT)));
        stringBuffer.append("', BASELINE_NAME => '");
        stringBuffer.append(values.get(BASELINE_NAME));
        stringBuffer.append("');\n");
        stringBuffer.append("END;\n");
        return stringBuffer.toString();
    }

    private String snapshotId(String string) {
        int n;
        String string2 = "";
        if (string != null & !string.equals("") && (n = string.indexOf("@")) >= 0) {
            string2 = string.substring(0, n).trim();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> getSnapshotIds(Connection connection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap hashMap = new HashMap();
                resultSetWrapper = dBUtil.executeOracleQuery(Utils.getQuery(((Object)((Object)this)).getClass(), (Connection)connection, (String)"getSnapshotTimes"), hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        arrayList.add(string + " @ " + string2);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }
}

