/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.performance;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditADDMParametersAction
extends ActionDialog {
    private static final String EXPIRES_IN = "ExpiresIn";
    private static final String DBIO_EXPECTED = "DBIOExpected";
    private int expiresIn;
    private int dbioExpected;

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_ADDM_PARAMETERS_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Cloneable cloneable;
        DBUtil dBUtil;
        SpinnerActionControl spinnerActionControl;
        this.expiresIn = 0;
        this.dbioExpected = 0;
        if (Connections.getInstance().lock(connection)) {
            spinnerActionControl = null;
            try {
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                cloneable = new HashMap();
                spinnerActionControl = dBUtil.executeOracleQuery(Utils.getQuery(((Object)((Object)this)).getClass(), (Connection)connection, (String)"getDefaultADDMParamValues"), cloneable);
                if (spinnerActionControl != null) {
                    ResultSet resultSet = spinnerActionControl.getResultSet();
                    while (resultSet.next()) {
                        this.expiresIn = resultSet.getInt(1);
                        this.dbioExpected = resultSet.getInt(2);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (spinnerActionControl != null) {
                    spinnerActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        spinnerActionControl = new SpinnerActionControl(EXPIRES_IN, DbaNavigatorResources.getString("EXPIRES_IN_LABEL"), Integer.valueOf(this.expiresIn), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(1));
        dBUtil = new SpinnerActionControl(DBIO_EXPECTED, DbaNavigatorResources.getString("DBIO_EXPECTED_LABEL"), Integer.valueOf(this.dbioExpected), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(1));
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(spinnerActionControl);
        ((ArrayList)cloneable).add(dBUtil);
        return cloneable;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.parseInt(values.get(EXPIRES_IN));
        int n2 = Integer.parseInt(values.get(DBIO_EXPECTED));
        if (n != this.expiresIn || n2 != this.dbioExpected) {
            stringBuffer.append("BEGIN\n");
            if (n != this.expiresIn) {
                stringBuffer.append("   DBMS_ADVISOR.SET_DEFAULT_TASK_PARAMETER( 'Default Advisor', 'DAYS_TO_EXPIRE', '");
                stringBuffer.append(n);
                stringBuffer.append("');\n");
            }
            if (n2 != this.dbioExpected) {
                stringBuffer.append("   DBMS_ADVISOR.SET_DEFAULT_TASK_PARAMETER( 'ADDM', 'DBIO_EXPECTED', '");
                stringBuffer.append(n2);
                stringBuffer.append("');\n");
            }
            stringBuffer.append("END;\n");
        }
        return stringBuffer.toString();
    }
}

