/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.performance;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditAWRSettingsAction
extends ActionDialog {
    private static final String RETAIN_FOREVER = "RetainForever";
    private static final String RETENTION_PERIOD = "RetentionPeriod";
    private static final String DISABLE_SNAPSHOTS = "DisableSnapshots";
    private static final String SNAPSHOT_INTERVAL = "SnapshotInterval";
    private static final String COLLECTION_LEVEL = "CollectionLevel";
    private boolean retainForever;
    private int retentionPeriod;
    private boolean disableSnapshots;
    private int snapshotInterval;
    private String collectionLevel;

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_AWR_SETTINGS_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        ResultSet resultSet;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl;
        DBUtil dBUtil;
        ResultSetWrapper resultSetWrapper;
        if (Connections.getInstance().lock(connection)) {
            resultSetWrapper = null;
            try {
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                booleanCheckBoxActionControl = new HashMap();
                resultSetWrapper = dBUtil.executeOracleQuery(Utils.getQuery(((Object)((Object)this)).getClass(), (Connection)connection, (String)"getAWRParameters"), booleanCheckBoxActionControl);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        this.retentionPeriod = resultSet.getInt(1);
                        this.snapshotInterval = resultSet.getInt(2);
                        this.collectionLevel = resultSet.getString(3);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        if (this.retentionPeriod > 52704000) {
            this.retainForever = true;
            this.retentionPeriod = 8;
        } else {
            this.retentionPeriod /= 1440;
        }
        if (this.snapshotInterval > 52704000) {
            this.disableSnapshots = true;
            this.snapshotInterval = 60;
        }
        resultSetWrapper = new BooleanCheckBoxActionControl(RETAIN_FOREVER, DbaNavigatorResources.getString("RETAIN_FOREVER_LABEL"), this.retainForever);
        dBUtil = new SpinnerActionControl(RETENTION_PERIOD, DbaNavigatorResources.getString("RETENTION_PERIOD_LABEL"), Integer.valueOf(this.retentionPeriod), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(1));
        booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(DISABLE_SNAPSHOTS, DbaNavigatorResources.getString("DISABLE_SNAPSHOTS_LABEL"), this.disableSnapshots);
        resultSet = new SpinnerActionControl(SNAPSHOT_INTERVAL, DbaNavigatorResources.getString("SNAPSHOT_INTERVAL_LABEL"), Integer.valueOf(this.snapshotInterval), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(1));
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(COLLECTION_LEVEL, DbaNavigatorResources.getString("COLLECTION_LEVEL_LABEL"), new String[]{"BASIC", "TYPICAL", "ALL"}, this.collectionLevel);
        dBUtil.enableUI(!this.retainForever);
        resultSetWrapper.addPropertyChangeListener(new PropertyChangeListener((ActionControl)dBUtil, (ActionControl)resultSetWrapper){
            final /* synthetic */ ActionControl val$retentionPeriodCtl;
            final /* synthetic */ ActionControl val$retainForeverCtl;
            {
                this.val$retentionPeriodCtl = actionControl;
                this.val$retainForeverCtl = actionControl2;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.val$retentionPeriodCtl.enableUI(!Boolean.parseBoolean(this.val$retainForeverCtl.getValue().get()));
            }
        });
        resultSet.enableUI(!this.disableSnapshots);
        booleanCheckBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)resultSet, (ActionControl)booleanCheckBoxActionControl){
            final /* synthetic */ ActionControl val$snapshotIntervalCtl;
            final /* synthetic */ ActionControl val$disableSnapshotsCtl;
            {
                this.val$snapshotIntervalCtl = actionControl;
                this.val$disableSnapshotsCtl = actionControl2;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.val$snapshotIntervalCtl.enableUI(!Boolean.parseBoolean(this.val$disableSnapshotsCtl.getValue().get()));
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)resultSetWrapper);
        arrayList.add((ActionControl)dBUtil);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)resultSet);
        arrayList.add((ActionControl)comboBoxActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = Boolean.parseBoolean(values.get(RETAIN_FOREVER));
        int n = Integer.parseInt(values.get(RETENTION_PERIOD));
        boolean bl3 = Boolean.parseBoolean(values.get(DISABLE_SNAPSHOTS));
        int n2 = Integer.parseInt(values.get(SNAPSHOT_INTERVAL));
        String string = values.get(COLLECTION_LEVEL);
        boolean bl4 = bl2 != this.retainForever || !bl2 && n != this.retentionPeriod || bl3 != this.disableSnapshots || !bl3 && n2 != this.snapshotInterval;
        boolean bl5 = bl = !string.equals(this.collectionLevel);
        if (bl4) {
            stringBuffer.append("BEGIN\n");
            if (bl) {
                stringBuffer.append("   EXECUTE IMMEDIATE 'ALTER SYSTEM SET statistics_level=\"");
                stringBuffer.append(string);
                stringBuffer.append("\" SCOPE=MEMORY';\n");
            }
            stringBuffer.append("   DBMS_WORKLOAD_REPOSITORY.MODIFY_SNAPSHOT_SETTINGS(");
            if (bl2) {
                stringBuffer.append(0);
            } else {
                stringBuffer.append(n * 60 * 24);
            }
            stringBuffer.append(", ");
            if (bl3) {
                stringBuffer.append(0);
            } else {
                stringBuffer.append(n2);
            }
            stringBuffer.append(");\n");
            stringBuffer.append("END;\n");
        } else if (bl) {
            stringBuffer.append("ALTER SYSTEM SET statistics_level=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" SCOPE=MEMORY;\n");
        }
        return stringBuffer.toString();
    }
}

