/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.resourcemanagerplans;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class AddOrEditItemAction
extends ActionDialog {
    private static final String GROUP_OR_SUBPLAN = "GroupOrSubplan";
    private static final String LEVEL1 = "Level1";
    private static final String LEVEL2 = "Level2";
    private static final String LEVEL3 = "Level3";
    private static final String LEVEL4 = "Level4";
    private static final String LEVEL5 = "Level5";
    private static final String LEVEL6 = "Level6";
    private static final String LEVEL7 = "Level7";
    private static final String LEVEL8 = "Level8";
    private static final String MAX_DEGREE_PARALLELISM = "MaxDegreeParallelism";
    private static final String SWITCH_GROUP = "SwitchGroup";
    private static final String MAX_NUMBER_ACTIVE_SESSIONS = "MaxNumberActiveSessions";
    private static final String QUEUE_TIMEOUT = "QueueTimeout";
    private static final String MAX_UNDO_SPACE = "MaxUndoSpace";
    private static final String MAX_EST_EXECUTION_TIME = "MaxEstExecutionTime";
    private static final String MAX_IDLE_TIME = "MaxIdleTime";
    private static final String MAX_BLOCKING_IDLE_TIME = "MaxBlockingIdleTime";
    private static final String EXECUTION_TIME_LIMIT = "ExecutionTimeLimit";
    private static final String IO_LIMIT = "IoLimit";
    private static final String IO_REQUEST_LIMT = "IoRequestLimit";
    private boolean is11gOrLater;
    private boolean is12gOrLater;
    private boolean isGroup;

    protected String getTitle() {
        String string = null;
        Operation operation = this.getOperation();
        string = operation == Operation.EDIT ? DbaNavigatorResources.getString("EDIT_ITEM_TITLE") : DbaNavigatorResources.getString("CREATE_ITEM_TITLE");
        return string;
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        Object object2;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        TextBoxActionControl textBoxActionControl2;
        boolean bl = DbaUtil.isPDB(connection);
        Operation operation = this.getOperation();
        if (operation == Operation.ADD_SUBPLAN && bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("NOT_SUPPORTED_FOR_PDB"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
            throw new RuntimeException("not supported for pluggable database");
        }
        try {
            this.is11gOrLater = connection.getMetaData().getDatabaseMajorVersion() >= 11;
            this.is12gOrLater = connection.getMetaData().getDatabaseMajorVersion() >= 12;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        String string = this.getObjectName();
        String string2 = null;
        this.isGroup = false;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        String string3 = null;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        int n16 = -1;
        int n17 = -1;
        int n18 = -1;
        switch (operation) {
            case ADD_GROUP: {
                this.isGroup = true;
                string3 = bl ? "" : "CANCEL_SQL";
                break;
            }
            case ADD_SUBPLAN: {
                this.isGroup = false;
                break;
            }
            default: {
                if (!Connections.getInstance().lock(connection)) break;
                textBoxActionControl2 = null;
                try {
                    textBoxActionControl = new HashMap();
                    string2 = this.getDBObjectChildName();
                    string = this.getDBObjectName();
                    textBoxActionControl.put("GROUP_OR_SUBPLAN", string2);
                    textBoxActionControl.put("PLAN", string);
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    textBoxActionControl2 = dBUtil.executeOracleQuery(this.getQuery(connection, "getDirective"), (Map)textBoxActionControl);
                    if (textBoxActionControl2 == null) break;
                    object2 = textBoxActionControl2.getResultSet();
                    while (object2.next()) {
                        object = object2.getString("TYPE");
                        this.isGroup = ((String)object).equals("CONSUMER_GROUP");
                        n = this.getDirective((ResultSet)object2, "CPU_P1");
                        n2 = this.getDirective((ResultSet)object2, "CPU_P2");
                        n3 = this.getDirective((ResultSet)object2, "CPU_P3");
                        n4 = this.getDirective((ResultSet)object2, "CPU_P4");
                        n5 = this.getDirective((ResultSet)object2, "CPU_P5");
                        n6 = this.getDirective((ResultSet)object2, "CPU_P6");
                        n7 = this.getDirective((ResultSet)object2, "CPU_P7");
                        n8 = this.getDirective((ResultSet)object2, "CPU_P8");
                        n9 = this.getDirective((ResultSet)object2, "PARALLEL_DEGREE_LIMIT_P1");
                        string3 = object2.getString("SWITCH_GROUP");
                        n10 = this.getDirective((ResultSet)object2, "ACTIVE_SESS_POOL_P1");
                        n11 = this.getDirective((ResultSet)object2, "QUEUEING_P1");
                        n12 = this.getDirective((ResultSet)object2, "UNDO_POOL");
                        n13 = this.getDirective((ResultSet)object2, "MAX_EST_EXEC_TIME");
                        n14 = this.getDirective((ResultSet)object2, "MAX_IDLE_TIME");
                        n15 = this.getDirective((ResultSet)object2, "MAX_IDLE_BLOCKER_TIME");
                        n16 = this.getDirective((ResultSet)object2, "SWITCH_TIME");
                        if (!this.is11gOrLater) continue;
                        n17 = this.getDirective((ResultSet)object2, "SWITCH_IO_MEGABYTES");
                        n18 = this.getDirective((ResultSet)object2, "SWITCH_IO_REQS");
                    }
                    break;
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break;
                }
                finally {
                    if (textBoxActionControl2 != null) {
                        textBoxActionControl2.close();
                    }
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        textBoxActionControl2 = null;
        if (operation == Operation.EDIT) {
            textBoxActionControl2 = new TextBoxActionControl(GROUP_OR_SUBPLAN, DbaNavigatorResources.getString(this.isGroup ? "GROUP_NAME_LABEL" : "SUBPLAN_NAME_LABEL"), string2);
            textBoxActionControl2.setEditable(false);
        } else {
            textBoxActionControl = new HashMap();
            textBoxActionControl.put("PLAN", string);
            textBoxActionControl2 = this.isGroup ? new SqlComboBoxActionControl(GROUP_OR_SUBPLAN, DbaNavigatorResources.getString("GROUP_NAME_LABEL"), connection, this.getQuery(connection, "getGroupItems"), textBoxActionControl, string2) : new SqlComboBoxActionControl(GROUP_OR_SUBPLAN, DbaNavigatorResources.getString("SUBPLAN_NAME_LABEL"), connection, this.getQuery(connection, "getSubPlanItems"), textBoxActionControl, string2);
        }
        textBoxActionControl = new TextBoxActionControl(LEVEL1, DbaNavigatorResources.getString(bl ? "SHARES_LABEL" : "LEVEL1_LABEL"), Integer.toString(n), TextBoxActionControl.getIntegerFormat());
        dBUtil = bl ? null : new TextBoxActionControl(LEVEL2, DbaNavigatorResources.getString("LEVEL2_LABEL"), Integer.toString(n2), TextBoxActionControl.getIntegerFormat());
        object2 = bl ? null : new TextBoxActionControl(LEVEL3, DbaNavigatorResources.getString("LEVEL3_LABEL"), Integer.toString(n3), TextBoxActionControl.getIntegerFormat());
        object = bl ? null : new TextBoxActionControl(LEVEL4, DbaNavigatorResources.getString("LEVEL4_LABEL"), Integer.toString(n4), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl3 = bl ? null : new TextBoxActionControl(LEVEL5, DbaNavigatorResources.getString("LEVEL5_LABEL"), Integer.toString(n5), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl4 = bl ? null : new TextBoxActionControl(LEVEL6, DbaNavigatorResources.getString("LEVEL6_LABEL"), Integer.toString(n6), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl5 = bl ? null : new TextBoxActionControl(LEVEL7, DbaNavigatorResources.getString("LEVEL7_LABEL"), Integer.toString(n7), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl6 = bl ? null : new TextBoxActionControl(LEVEL8, DbaNavigatorResources.getString("LEVEL8_LABEL"), Integer.toString(n8), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl7 = new TextBoxActionControl(MAX_DEGREE_PARALLELISM, DbaNavigatorResources.getString("MAX_DEGREE_PARALLELISM_LABEL"), Integer.toString(n9), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl8 = new TextBoxActionControl(SWITCH_GROUP, DbaNavigatorResources.getString("SWITCH_GROUP_LABEL"), string3);
        TextBoxActionControl textBoxActionControl9 = new TextBoxActionControl(MAX_NUMBER_ACTIVE_SESSIONS, DbaNavigatorResources.getString("MAX_NUMBER_ACTIVE_SESSIONS_LABEL"), Integer.toString(n10), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl10 = new TextBoxActionControl(QUEUE_TIMEOUT, DbaNavigatorResources.getString("QUEUE_TIMEOUT_LABEL"), Integer.toString(n11), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl11 = new TextBoxActionControl(MAX_UNDO_SPACE, DbaNavigatorResources.getString("MAX_UNDO_SPACE_LABEL"), Integer.toString(n12), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl12 = new TextBoxActionControl(MAX_EST_EXECUTION_TIME, DbaNavigatorResources.getString("MAX_EST_EXECUTION_TIME_LABEL"), Integer.toString(n13), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl13 = new TextBoxActionControl(MAX_IDLE_TIME, DbaNavigatorResources.getString("MAX_IDLE_TIME_LABEL"), Integer.toString(n14), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl14 = new TextBoxActionControl(MAX_BLOCKING_IDLE_TIME, DbaNavigatorResources.getString("MAX_BLOCKING_IDLE_TIME_LABEL"), Integer.toString(n15), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl15 = new TextBoxActionControl(EXECUTION_TIME_LIMIT, DbaNavigatorResources.getString("EXECUTION_TIME_LIMIT_LABEL"), Integer.toString(n16), TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl16 = this.is11gOrLater ? new TextBoxActionControl(IO_LIMIT, DbaNavigatorResources.getString("IO_LIMIT_LABEL"), Integer.toString(n17), TextBoxActionControl.getIntegerFormat()) : null;
        TextBoxActionControl textBoxActionControl17 = this.is11gOrLater ? new TextBoxActionControl(IO_REQUEST_LIMT, DbaNavigatorResources.getString("IO_REQUEST_LIMT_LABEL"), Integer.toString(n18), TextBoxActionControl.getIntegerFormat()) : null;
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl);
        if (!bl) {
            arrayList.add((ActionControl)dBUtil);
            arrayList.add((ActionControl)object2);
            arrayList.add((ActionControl)object);
            arrayList.add((ActionControl)textBoxActionControl3);
            arrayList.add((ActionControl)textBoxActionControl4);
            arrayList.add((ActionControl)textBoxActionControl5);
            arrayList.add((ActionControl)textBoxActionControl6);
        }
        if (this.isGroup) {
            arrayList.add((ActionControl)textBoxActionControl7);
            arrayList.add((ActionControl)textBoxActionControl8);
            arrayList.add((ActionControl)textBoxActionControl9);
            arrayList.add((ActionControl)textBoxActionControl10);
            arrayList.add((ActionControl)textBoxActionControl11);
            arrayList.add((ActionControl)textBoxActionControl12);
            arrayList.add((ActionControl)textBoxActionControl13);
            arrayList.add((ActionControl)textBoxActionControl14);
            arrayList.add((ActionControl)textBoxActionControl15);
            if (this.is11gOrLater) {
                arrayList.add((ActionControl)textBoxActionControl16);
                arrayList.add((ActionControl)textBoxActionControl17);
            }
        }
        return arrayList;
    }

    private int getDirective(ResultSet resultSet, String string) throws SQLException {
        int n = -1;
        try {
            n = Integer.parseInt(resultSet.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.is11gOrLater ? "MGMT" : "CPU";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CLEAR_PENDING_AREA();\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_PENDING_AREA();\n");
        if (this.getOperation() != Operation.EDIT) {
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_PLAN_DIRECTIVE(\n");
            stringBuffer.append("        PLAN => '");
            stringBuffer.append(this.getObjectName());
            stringBuffer.append("',\n");
            stringBuffer.append("        GROUP_OR_SUBPLAN => '");
            stringBuffer.append(values.get(GROUP_OR_SUBPLAN));
            stringBuffer.append("',\n");
            stringBuffer.append("        COMMENT => ''");
            stringBuffer.append(",\n");
            stringBuffer.append("        " + string + "_P1 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL1)));
            stringBuffer.append(",\n");
            stringBuffer.append("        " + string + "_P2 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL2)));
            stringBuffer.append(",\n");
            stringBuffer.append("        " + string + "_P3 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL3)));
            stringBuffer.append(",\n");
            stringBuffer.append("        " + string + "_P4 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL4)));
            stringBuffer.append(",\n");
            stringBuffer.append("        " + string + "_P5 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL5)));
            stringBuffer.append(",\n");
            stringBuffer.append("        " + string + "_P6 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL6)));
            stringBuffer.append(",\n");
            stringBuffer.append("        " + string + "_P7 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL7)));
            stringBuffer.append(",\n");
            stringBuffer.append("        " + string + "_P8 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL8)));
            if (this.isGroup) {
                stringBuffer.append(",\n");
                stringBuffer.append("        ACTIVE_SESS_POOL_P1 => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_NUMBER_ACTIVE_SESSIONS)));
                stringBuffer.append(",\n");
                stringBuffer.append("        QUEUEING_P1 => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(QUEUE_TIMEOUT)));
                stringBuffer.append(",\n");
                stringBuffer.append("        PARALLEL_DEGREE_LIMIT_P1 => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_DEGREE_PARALLELISM)));
                stringBuffer.append(",\n");
                stringBuffer.append("        SWITCH_GROUP => '");
                stringBuffer.append(values.get(SWITCH_GROUP));
                stringBuffer.append("',\n");
                stringBuffer.append("        SWITCH_TIME => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(EXECUTION_TIME_LIMIT)));
                stringBuffer.append(",\n");
                stringBuffer.append("        MAX_EST_EXEC_TIME => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_EST_EXECUTION_TIME)));
                stringBuffer.append(",\n");
                stringBuffer.append("        UNDO_POOL => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_UNDO_SPACE)));
                stringBuffer.append(",\n");
                stringBuffer.append("        MAX_IDLE_TIME => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_IDLE_TIME)));
                stringBuffer.append(",\n");
                stringBuffer.append("        MAX_IDLE_BLOCKER_TIME => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_BLOCKING_IDLE_TIME)));
                if (this.is11gOrLater) {
                    stringBuffer.append(",\n");
                    stringBuffer.append("        SWITCH_IO_MEGABYTES => ");
                    stringBuffer.append(this.intStringForPLSQLCall(values.get(IO_LIMIT)));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        SWITCH_IO_REQS => ");
                    stringBuffer.append(this.intStringForPLSQLCall(values.get(IO_REQUEST_LIMT)));
                }
            }
            stringBuffer.append(");\n");
        } else {
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.UPDATE_PLAN_DIRECTIVE(\n");
            stringBuffer.append("        PLAN => '");
            stringBuffer.append(this.getDBObjectName());
            stringBuffer.append("',\n");
            stringBuffer.append("        GROUP_OR_SUBPLAN => '");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(GROUP_OR_SUBPLAN)));
            stringBuffer.append("',\n");
            stringBuffer.append("        NEW_COMMENT => ''");
            stringBuffer.append(",\n");
            stringBuffer.append("        NEW_" + string + "_P1 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL1)));
            stringBuffer.append(",\n");
            stringBuffer.append("        NEW_" + string + "_P2 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL2)));
            stringBuffer.append(",\n");
            stringBuffer.append("        NEW_" + string + "_P3 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL3)));
            stringBuffer.append(",\n");
            stringBuffer.append("        NEW_" + string + "_P4 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL4)));
            stringBuffer.append(",\n");
            stringBuffer.append("        NEW_" + string + "_P5 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL5)));
            stringBuffer.append(",\n");
            stringBuffer.append("        NEW_" + string + "_P6 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL6)));
            stringBuffer.append(",\n");
            stringBuffer.append("        NEW_" + string + "_P7 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL7)));
            stringBuffer.append(",\n");
            stringBuffer.append("        NEW_" + string + "_P8 => ");
            stringBuffer.append(this.intStringForPLSQLCall(values.get(LEVEL8)));
            if (this.isGroup) {
                stringBuffer.append(",\n");
                stringBuffer.append("        NEW_ACTIVE_SESS_POOL_P1 => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_NUMBER_ACTIVE_SESSIONS)));
                stringBuffer.append(",\n");
                stringBuffer.append("        NEW_QUEUEING_P1 => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(QUEUE_TIMEOUT)));
                stringBuffer.append(",\n");
                stringBuffer.append("        NEW_PARALLEL_DEGREE_LIMIT_P1 => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_DEGREE_PARALLELISM)));
                stringBuffer.append(",\n");
                stringBuffer.append("        NEW_SWITCH_GROUP => '");
                stringBuffer.append(values.get(SWITCH_GROUP));
                stringBuffer.append("',\n");
                stringBuffer.append("        NEW_SWITCH_TIME => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(EXECUTION_TIME_LIMIT)));
                stringBuffer.append(",\n");
                stringBuffer.append("        NEW_MAX_EST_EXEC_TIME => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_EST_EXECUTION_TIME)));
                stringBuffer.append(",\n");
                stringBuffer.append("        NEW_UNDO_POOL => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_UNDO_SPACE)));
                stringBuffer.append(",\n");
                stringBuffer.append("        NEW_MAX_IDLE_TIME => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_IDLE_TIME)));
                stringBuffer.append(",\n");
                stringBuffer.append("        NEW_MAX_IDLE_BLOCKER_TIME => ");
                stringBuffer.append(this.intStringForPLSQLCall(values.get(MAX_BLOCKING_IDLE_TIME)));
                if (this.is11gOrLater) {
                    stringBuffer.append(",\n");
                    stringBuffer.append("        NEW_SWITCH_IO_MEGABYTES => ");
                    stringBuffer.append(this.intStringForPLSQLCall(values.get(IO_LIMIT)));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        NEW_SWITCH_IO_REQS => ");
                    stringBuffer.append(this.intStringForPLSQLCall(values.get(IO_REQUEST_LIMT)));
                }
            }
            stringBuffer.append(");\n");
        }
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.SUBMIT_PENDING_AREA();\n");
        stringBuffer.append("END;\n");
        return stringBuffer.toString();
    }

    private String intStringForPLSQLCall(String string) {
        if (string == null || "-1".equals(string)) {
            return "NULL";
        }
        return string;
    }

    private static enum Operation {
        ADD_GROUP,
        ADD_SUBPLAN,
        EDIT;

    }
}

