/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.rollbacksegments;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControl;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class CreateEditAction
extends ActionDialog {
    private static final String WARNING = "Warning";
    private static final String SEGMENT_NAME = "SegmentName";
    private static final String TABLESPACE = "Tablespace";
    private static final String PUBLIC = "Public";
    private static final String INITIAL_SIZE = "InitialSize";
    private static final String NEXT_SIZE = "NextSize";
    private static final String DEFAULT_OPTIMAL = "DefaultOptimal";
    private static final String OPTIMAL_SIZE = "OptimalSize";
    private static final String MIN_EXTENTS = "MinExtents";
    private static final String UNLIMITED_MAX_EXTENTS = "UnlimitedMaxExtents";
    private static final String MAX_EXTENTS = "MaxExtents";
    private boolean _automaticUndoManagement;
    private boolean _canSpecifyExtent;

    protected String getTitle() {
        String string = null;
        Operation operation = this.getOperation();
        string = operation == Operation.EDIT ? DbaNavigatorResources.getString("EDIT_ROLLBACK_SEGMENT_TITLE") : DbaNavigatorResources.getString("CREATE_ROLLBACK_SEGMENT_TITLE");
        return string;
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        ResultSet resultSet;
        DBUtil dBUtil;
        Object object;
        LabelActionControl labelActionControl;
        Operation operation = this.getOperation();
        String string = this.getObjectName();
        String string2 = DbaNavigatorResources.getString("ENTER_VALUE_PROMPT");
        String string3 = null;
        boolean bl = false;
        long l = 100L;
        long l2 = 1000L;
        boolean bl2 = true;
        long l3 = 100L;
        long l4 = 10L;
        boolean bl3 = true;
        long l5 = 100L;
        this._canSpecifyExtent = true;
        if (Connections.getInstance().lock(connection)) {
            labelActionControl = null;
            try {
                object = new HashMap();
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                labelActionControl = dBUtil.executeOracleQuery(this.getQuery(connection, "getUndoManagement"), (Map)object);
                if (labelActionControl != null) {
                    resultSet = labelActionControl.getResultSet();
                    while (resultSet.next()) {
                        this._automaticUndoManagement = "AUTO".equals(resultSet.getString("VALUE"));
                    }
                    labelActionControl.close();
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (labelActionControl != null) {
                    labelActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        if (operation != Operation.CREATE_NEW) {
            bl2 = false;
            bl3 = false;
            if (Connections.getInstance().lock(connection)) {
                labelActionControl = null;
                try {
                    object = new HashMap();
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    ((HashMap)object).put("SEGMENT_NAME", string);
                    labelActionControl = dBUtil.executeOracleQuery(this.getQuery(connection, "getSegment"), (Map)object);
                    if (labelActionControl != null) {
                        resultSet = labelActionControl.getResultSet();
                        while (resultSet.next()) {
                            if (operation == Operation.EDIT) {
                                string2 = resultSet.getString("SEGMENT_NAME");
                                this._canSpecifyExtent = "USER".equals(resultSet.getString("ALLOCATION_TYPE"));
                            }
                            bl = "PUBLIC".equals(resultSet.getString("OWNER"));
                            string3 = resultSet.getString("TABLESPACE_NAME");
                            l = resultSet.getLong("INITIAL_EXTENT");
                            l2 = resultSet.getLong("NEXT_EXTENT");
                            l4 = resultSet.getLong("MIN_EXTENTS");
                            l5 = resultSet.getLong("MAX_EXTENTS");
                        }
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                finally {
                    if (labelActionControl != null) {
                        labelActionControl.close();
                    }
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        labelActionControl = null;
        if (this._automaticUndoManagement) {
            labelActionControl = new LabelActionControl(WARNING, DbaNavigatorResources.getString("UNDO_MGMT_MODE_ERROR"));
        }
        object = new TextBoxActionControl(SEGMENT_NAME, DbaNavigatorResources.getString("SEGMENT_NAME_LABEL"), string2);
        dBUtil = new SqlComboBoxActionControl(TABLESPACE, DbaNavigatorResources.getString("TABLESPACE_LABEL"), connection, this.getQuery(connection, "getTablespaceNames"), string3);
        resultSet = new BooleanCheckBoxActionControl(PUBLIC, DbaNavigatorResources.getString("PUBLIC_LABEL"), bl);
        FileSizeActionControl fileSizeActionControl = new FileSizeActionControl(INITIAL_SIZE, DbaNavigatorResources.getString("INITIAL_SIZE_LABEL"), l * 1024L);
        FileSizeActionControl fileSizeActionControl2 = new FileSizeActionControl(NEXT_SIZE, DbaNavigatorResources.getString("NEXT_SIZE_LABEL"), l2 * 1024L);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(DEFAULT_OPTIMAL, DbaNavigatorResources.getString("DEFAULT_OPTIMAL_LABEL"), bl2);
        FileSizeActionControl fileSizeActionControl3 = new FileSizeActionControl(OPTIMAL_SIZE, DbaNavigatorResources.getString("OPTIMAL_SIZE_LABEL"), l3 * 1024L);
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(MIN_EXTENTS, DbaNavigatorResources.getString("MIN_EXTENTS_LABEL"), Long.toString(l4), TextBoxActionControl.getIntegerFormat());
        final BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl(UNLIMITED_MAX_EXTENTS, DbaNavigatorResources.getString("UNLIMITED_MAX_EXTENTS_LABEL"), bl3);
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl(MAX_EXTENTS, DbaNavigatorResources.getString("MAX_EXTENTS_LABEL"), Long.toString(l5), TextBoxActionControl.getIntegerFormat());
        if (operation == Operation.EDIT) {
            object.setEditable(false);
            dBUtil.setEditable(false);
            fileSizeActionControl.setEditable(false);
        }
        if (!this._canSpecifyExtent) {
            resultSet.setEditable(false);
            fileSizeActionControl.setEditable(false);
            fileSizeActionControl2.setEditable(false);
            booleanCheckBoxActionControl.setEditable(false);
            fileSizeActionControl3.setEditable(false);
            textBoxActionControl.setEditable(false);
            booleanCheckBoxActionControl2.setEditable(false);
            textBoxActionControl2.setEditable(false);
        } else {
            fileSizeActionControl3.enableUI(!bl2);
            textBoxActionControl2.enableUI(!bl3);
            booleanCheckBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)booleanCheckBoxActionControl, (ActionControl)fileSizeActionControl3){
                final /* synthetic */ ActionControl val$defaultOptimalCtl;
                final /* synthetic */ ActionControl val$optimalSizeCtl;
                {
                    this.val$defaultOptimalCtl = actionControl;
                    this.val$optimalSizeCtl = actionControl2;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = !Boolean.parseBoolean(this.val$defaultOptimalCtl.getValue().get());
                    this.val$optimalSizeCtl.enableUI(bl);
                }
            });
            booleanCheckBoxActionControl2.addPropertyChangeListener(new PropertyChangeListener((ActionControl)textBoxActionControl2){
                final /* synthetic */ ActionControl val$maxExtentsCtl;
                {
                    this.val$maxExtentsCtl = actionControl;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = !Boolean.parseBoolean(booleanCheckBoxActionControl2.getValue().get());
                    this.val$maxExtentsCtl.enableUI(bl);
                }
            });
        }
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        if (this._automaticUndoManagement) {
            arrayList.add((ActionControl)labelActionControl);
        }
        arrayList.add((ActionControl)object);
        arrayList.add((ActionControl)dBUtil);
        arrayList.add((ActionControl)resultSet);
        arrayList.add((ActionControl)fileSizeActionControl);
        arrayList.add((ActionControl)fileSizeActionControl2);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)fileSizeActionControl3);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl2);
        if (this._automaticUndoManagement) {
            for (ActionControl actionControl : arrayList) {
                actionControl.setEditable(false);
            }
        }
        return arrayList;
    }

    protected boolean allowApplyScript() {
        boolean bl = true;
        if (this._automaticUndoManagement) {
            this.showErrorDialog(DbaNavigatorResources.getString("UNDO_MGMT_MODE_ERROR"));
            bl = false;
        } else if (!this._canSpecifyExtent) {
            this.showErrorDialog(DbaNavigatorResources.getString("CANT_MODIFY_EXTENT_ERROR"));
            bl = false;
        }
        return !this._automaticUndoManagement && this._canSpecifyExtent;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getOperation() != Operation.EDIT) {
            stringBuffer.append("CREATE ");
            if (Boolean.parseBoolean(values.get(PUBLIC))) {
                stringBuffer.append("PUBLIC ");
            }
            stringBuffer.append("ROLLBACK SEGMENT \"");
            stringBuffer.append(values.get(SEGMENT_NAME));
            stringBuffer.append("\"\nTABLESPACE \"");
            stringBuffer.append(values.get(TABLESPACE));
        } else {
            stringBuffer.append("ALTER ROLLBACK SEGMENT \"");
            stringBuffer.append(values.get(SEGMENT_NAME));
        }
        stringBuffer.append("\"\nSTORAGE");
        stringBuffer.append("\n(");
        if (this.getOperation() != Operation.EDIT) {
            stringBuffer.append("\n    INITIAL ");
            stringBuffer.append(values.get(INITIAL_SIZE, "SizeClause"));
        }
        stringBuffer.append("\n    NEXT ");
        stringBuffer.append(values.get(NEXT_SIZE, "SizeClause"));
        stringBuffer.append("\n    OPTIMAL ");
        if (Boolean.parseBoolean(values.get(DEFAULT_OPTIMAL))) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(values.get(OPTIMAL_SIZE, "SizeClause"));
        }
        stringBuffer.append("\n    MINEXTENTS ");
        stringBuffer.append(values.get(MIN_EXTENTS));
        stringBuffer.append("\n    MAXEXTENTS ");
        if (Boolean.parseBoolean(values.get(UNLIMITED_MAX_EXTENTS))) {
            stringBuffer.append("UNLIMITED");
        } else {
            stringBuffer.append(values.get(MAX_EXTENTS));
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }
}

