/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors;

import java.awt.Component;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;

public abstract class SQLPLUSScriptProcessor
implements ScriptProcessor {
    private boolean _processingDeclined;
    private ActionDialog _dialog;

    public SQLPLUSScriptProcessor(ActionDialog actionDialog) {
        this._dialog = actionDialog;
    }

    protected String getOSCommand() {
        return "$ sqlplus \"SYS@[tnsname] as sysdba\" @[filename]";
    }

    public String getScriptEditorTabName() {
        return DbaNavigatorResources.getString("SQLPLUS_TAB");
    }

    public BasicEditorPane getEditorPane() {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        return basicEditorPane;
    }

    public boolean isCancellable() {
        return false;
    }

    public void cancel() {
    }

    public String getSuccessMessage() {
        return UiResources.getString((String)"SQL_SUCCESS");
    }

    public String getFailureMessage(Exception exception) {
        String string = UiResources.getString((String)"SQL_FAILURE");
        String string2 = exception.getLocalizedMessage();
        if (string2 != null) {
            string = string + "\n- " + string2;
        }
        return string;
    }

    protected abstract String getMountCommand(ScriptProcessorContext var1);

    public void processScript(ScriptProcessorContext scriptProcessorContext) throws Exception {
        boolean bl = false;
        if (!MessageDialog.confirm((Component)scriptProcessorContext.getParent(), (Object)DbaNavigatorResources.getString("SQLPLUS_WARNING_MESSAGE"), (String)DbaNavigatorResources.getString("RESTART_DATABASE_TITLE"), null)) {
            this._processingDeclined = true;
            throw new SQLException();
        }
        Connections.getInstance().closeConnection(scriptProcessorContext.getConnectionName());
        this._dialog.setDBObject(null);
        this.shutdown(scriptProcessorContext);
        this.startup(scriptProcessorContext);
        if (bl) {
            throw new SQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(ScriptProcessorContext scriptProcessorContext) throws SQLException {
        Properties properties = scriptProcessorContext.getConnectionProperties();
        String string = properties.getProperty("customUrl");
        String string2 = properties.getProperty("user");
        String string3 = properties.getProperty("password");
        OracleDataSource oracleDataSource = new OracleDataSource();
        Properties properties2 = new Properties();
        properties2.setProperty("user", string2);
        properties2.setProperty("password", string3);
        properties2.setProperty("internal_logon", "sysdba");
        oracleDataSource.setConnectionProperties(properties2);
        oracleDataSource.setURL(string);
        OracleConnection oracleConnection = (OracleConnection)oracleDataSource.getConnection();
        try {
            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.IMMEDIATE);
            Statement statement = oracleConnection.createStatement();
            statement.executeUpdate("ALTER DATABASE CLOSE NORMAL");
            statement.executeUpdate("ALTER DATABASE DISMOUNT");
            statement.close();
            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.FINAL);
        }
        finally {
            oracleConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startup(ScriptProcessorContext scriptProcessorContext) throws SQLException {
        Properties properties = scriptProcessorContext.getConnectionProperties();
        String string = properties.getProperty("customUrl");
        String string2 = properties.getProperty("user");
        String string3 = properties.getProperty("password");
        OracleDataSource oracleDataSource = new OracleDataSource();
        Properties properties2 = new Properties();
        properties2.setProperty("user", string2);
        properties2.setProperty("password", string3);
        properties2.setProperty("internal_logon", "sysdba");
        properties2.setProperty("prelim_auth", "true");
        oracleDataSource.setConnectionProperties(properties2);
        oracleDataSource.setURL(string);
        OracleConnection oracleConnection = (OracleConnection)oracleDataSource.getConnection();
        try {
            oracleConnection.startup(OracleConnection.DatabaseStartupMode.NO_RESTRICTION);
        }
        finally {
            oracleConnection.close();
        }
        OracleDataSource oracleDataSource2 = new OracleDataSource();
        Properties properties3 = new Properties();
        properties3.setProperty("user", string2);
        properties3.setProperty("password", string3);
        properties3.setProperty("internal_logon", "sysdba");
        oracleDataSource2.setConnectionProperties(properties3);
        oracleDataSource2.setURL(string);
        OracleConnection oracleConnection2 = (OracleConnection)oracleDataSource2.getConnection();
        try {
            Statement statement = oracleConnection2.createStatement();
            statement.executeUpdate("ALTER DATABASE MOUNT");
            try {
                statement.executeUpdate(this.getMountCommand(scriptProcessorContext));
            }
            finally {
                statement.executeUpdate("ALTER DATABASE OPEN");
                statement.close();
            }
        }
        finally {
            oracleConnection2.close();
        }
    }
}

