/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.TemporalController;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.datatypes.objects.OraDATE;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.dba.navigator.Drill.DBADrillLink;
import oracle.dbtools.raptor.dba.navigator.displays.DisplayArb;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.calendar.CalendarPopupButton;
import oracle.javatools.util.Version;

public class UndoDisplay
extends DisplayAdapter {
    private JPanel _panel;
    private String _tsName;
    private String _maxSize;
    private String _autoextend;
    private String _retension;
    private String _retGuarantee;
    private boolean _isRefreshing = false;
    private String _autoTune;
    private String _curSize;
    private String _undoState;
    private String _owner;
    String h_prob = null;
    String h_rec = null;
    String h_rat = null;
    int h_ret = 0;
    int h_utb = 0;
    int h_mig = 0;
    int h_bpr = 0;
    int h_lq = 0;
    int h_rr = 0;
    int h_ru = 0;
    String h_adv = null;
    JLabel h_prob_lab = new JLabel();
    JLabel h_rec_lab = new JLabel();
    JLabel h_rat_lab = new JLabel();
    JLabel h_ret_lab = new JLabel();
    JLabel h_utb_lab = new JLabel();
    JLabel h_mig_lab = new JLabel();
    JLabel h_bpr_lab = new JLabel();
    JLabel h_lq_lab = new JLabel();
    JLabel h_rr_lab = new JLabel();
    JLabel h_ru_lab = new JLabel();
    JLabel h_adv_lab = new JLabel();
    JTextField h_req_ret = new JTextField();
    private OraTemporalDatum _fromDatum;
    private OraTemporalDatum _toDatum;
    private TemporalController _fromController;
    private TemporalController _toController;
    private CalendarPopupButton _fromButton;
    private CalendarPopupButton _toButton;
    private DateTimeEditor _fromDe;
    private DateTimeEditor _toDe;
    private JButton _advButton;

    public void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInfo() {
        String string = "DECLARE   tsn VARCHAR2(40);   tss NUMBER(10);   aex BOOLEAN;   unr NUMBER(5);   rgt BOOLEAN;   retval BOOLEAN;   state VARCHAR2(20); BEGIN   retval := dbms_undo_adv.undo_info(tsn, tss, aex, unr, rgt);   ? := tsn;   ? := TO_CHAR(tss);   IF aex THEN     state := 'TRUE';   ELSE     state := 'FALSE';   END IF;   ? := state;   ? := TO_CHAR(unr/60);   IF rgt THEN     state := 'TRUE';   ELSE     state := 'FALSE';   END IF;   ? := state; END; ";
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                CallableStatement callableStatement = connection.prepareCall(string);
                callableStatement.registerOutParameter(1, 12);
                callableStatement.registerOutParameter(2, 12);
                callableStatement.registerOutParameter(3, 12);
                callableStatement.registerOutParameter(4, 12);
                callableStatement.registerOutParameter(5, 12);
                this._tsName = null;
                try {
                    callableStatement.execute();
                    this._tsName = callableStatement.getString(1);
                    this._maxSize = callableStatement.getString(2);
                    this._autoextend = callableStatement.getString(3);
                    this._retension = callableStatement.getString(4);
                    this._retGuarantee = callableStatement.getString(5);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAutoTune() {
        String string = "declare v_return Boolean := null; v_enabled boolean := null; v_status varchar2(20);begin  v_return:= dbms_undo_adv.undo_autotune(v_enabled);  if v_return then     if v_enabled then \t\tv_status := 'ENABLED';     else \t\tv_status := 'DISABLED'; \t end if;  else \t  v_status := 'NOINFO';  end if;  ? := v_status; end; ";
        String string2 = null;
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                CallableStatement callableStatement = connection.prepareCall(string);
                callableStatement.registerOutParameter(1, 12);
                try {
                    callableStatement.execute();
                    string2 = callableStatement.getString(1);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        this._autoTune = string2 == null || string2.equals("NOINFO") ? DisplayArb.getString("AUTO_NOINFO") : (string2.equals("ENABLED") ? DisplayArb.getString("AUTO_ENABLE") : (string2.equals("DISABLED") ? DisplayArb.getString("AUTO_DISABLED") : DisplayArb.getString("AUTO_NOINFO")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDetailInfo() {
        String string = "select to_char(bytes/1024/1024) from dba_data_files where tablespace_name = (select value from v$parameter where name = 'undo_tablespace')";
        String string2 = "select USER from dual";
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                this._curSize = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string);
                this._owner = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string2);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadUndoState() {
        String string = "select value from V$SYSTEM_PARAMETER where name = 'undo_management'";
        Connection connection = this.getConnection();
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            try {
                this._undoState = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string);
                if (!this._undoState.equals("MANUAL")) {
                    bl = true;
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHealth() {
        String string = "DECLARE  prob VARCHAR2(100);  reco VARCHAR2(100);  rtnl VARCHAR2(100);  retn NUMBER;  utbs NUMBER;  retv NUMBER; BEGIN   retv := dbms_undo_adv.undo_health(?, ?, prob, reco, rtnl, retn, utbs);   ? := prob;   ? := reco;   ? := rtnl;   ? := TO_CHAR(retn);   ? := TO_CHAR(utbs); END; ";
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                CallableStatement callableStatement = connection.prepareCall(string);
                callableStatement.setDate(1, this._fromDatum.getDate());
                callableStatement.setDate(2, this._toDatum.getDate());
                callableStatement.registerOutParameter(3, 12);
                callableStatement.registerOutParameter(4, 12);
                callableStatement.registerOutParameter(5, 12);
                callableStatement.registerOutParameter(6, 2);
                callableStatement.registerOutParameter(7, 2);
                try {
                    callableStatement.execute();
                    this.h_prob = callableStatement.getString(3);
                    this.h_rec = callableStatement.getString(4);
                    this.h_rat = callableStatement.getString(5);
                    this.h_ret = callableStatement.getInt(6);
                    this.h_utb = callableStatement.getInt(7);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
            this.h_prob_lab.setText(this.h_prob);
            this.h_rec_lab.setText(this.h_rec);
            this.h_rat_lab.setText(this.h_rat);
            this.h_ret_lab.setText(Integer.toString(this.h_ret));
            this.h_utb_lab.setText(Integer.toString(this.h_utb));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadReqRetension() {
        String string = "BEGIN   ? := dbms_undo_adv.REQUIRED_RETENTION(?, ?); END; ";
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                CallableStatement callableStatement = connection.prepareCall(string);
                callableStatement.registerOutParameter(1, 2);
                callableStatement.setDate(2, this._fromDatum.getDate());
                callableStatement.setDate(3, this._toDatum.getDate());
                try {
                    callableStatement.execute();
                    this.h_rr = callableStatement.getInt(1);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
            this.h_rr_lab.setText(Integer.toString(this.h_rr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLongQuery() {
        String string = "BEGIN   ? := dbms_undo_adv.LONGEST_QUERY(?, ?); END; ";
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                CallableStatement callableStatement = connection.prepareCall(string);
                callableStatement.registerOutParameter(1, 2);
                callableStatement.setDate(2, this._fromDatum.getDate());
                callableStatement.setDate(3, this._toDatum.getDate());
                try {
                    callableStatement.execute();
                    this.h_lq = callableStatement.getInt(1);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
            this.h_lq_lab.setText(Integer.toString(this.h_lq));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBestPossibleRetension() {
        String string = "BEGIN   ? := dbms_undo_adv.BEST_POSSIBLE_RETENTION(?, ?); END; ";
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                CallableStatement callableStatement = connection.prepareCall(string);
                callableStatement.registerOutParameter(1, 2);
                callableStatement.setDate(2, this._fromDatum.getDate());
                callableStatement.setDate(3, this._toDatum.getDate());
                try {
                    callableStatement.execute();
                    this.h_bpr = callableStatement.getInt(1);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
            this.h_bpr_lab.setText(Integer.toString(this.h_bpr));
            this.h_req_ret.setText(Integer.toString(this.h_bpr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAdvisor() {
        String string = "DECLARE   instancenumber NUMBER; BEGIN   select instance_number into instancenumber from v$instance;   ? := dbms_undo_adv.undo_advisor(?,?,instancenumber); END; ";
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                CallableStatement callableStatement = connection.prepareCall(string);
                callableStatement.registerOutParameter(1, 12);
                callableStatement.setDate(2, this._fromDatum.getDate());
                callableStatement.setDate(3, this._toDatum.getDate());
                try {
                    callableStatement.execute();
                    this.h_adv = callableStatement.getString(1);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
            this.h_adv_lab.setText(this.h_adv);
            this.h_adv_lab.setToolTipText(this.h_adv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadReqUndo() {
        block12: {
            String string = "BEGIN   ? := dbms_undo_adv.REQUIRED_UNDO_SIZE(?, ?, ?); END; ";
            try {
                int n = Integer.parseInt(this.h_req_ret.getText());
                Connection connection = this.getConnection();
                if (!Connections.getInstance().lock(connection)) break block12;
                try {
                    CallableStatement callableStatement = connection.prepareCall(string);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, n);
                    callableStatement.setDate(3, this._fromDatum.getDate());
                    callableStatement.setDate(4, this._toDatum.getDate());
                    try {
                        callableStatement.execute();
                        this.h_ru = callableStatement.getInt(1);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                    }
                    finally {
                        callableStatement.close();
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
                this.h_ru_lab.setText(Integer.toString(this.h_ru));
            }
            catch (Exception exception) {
                this.h_ru_lab.setText(DisplayArb.getString("BAD_RETENTION"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMigration() {
        String string = "BEGIN   ? := dbms_undo_adv.RBU_MIGRATION(?, ?); END; ";
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                CallableStatement callableStatement = connection.prepareCall(string);
                callableStatement.registerOutParameter(1, 2);
                callableStatement.setDate(2, this._fromDatum.getDate());
                callableStatement.setDate(3, this._toDatum.getDate());
                try {
                    callableStatement.execute();
                    this.h_mig = callableStatement.getInt(1);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
            this.h_mig_lab.setText(Integer.toString(this.h_mig));
        }
    }

    private void loadData() {
        this.loadInfo();
        this.loadAutoTune();
        this.loadDetailInfo();
        this.loadHealth();
        this.loadMigration();
        this.loadBestPossibleRetension();
        this.loadLongQuery();
        this.loadReqRetension();
        this.loadAdvisor();
        this.loadReqUndo();
    }

    private void calSetup() {
        this._fromDatum = OraDATE.getInstance();
        this._fromDatum.setPrecision(OraTemporalDatum.Precision.SECOND);
        this._fromDatum.add(5, -7);
        this._fromController = new TemporalController(this._fromDatum, true, null);
        this._fromController.setName("fromController");
        this._fromDe = this._fromController.getDateTimeEditor();
        this._fromButton = this._fromController.getCalendarPopupButton();
        this._toDatum = OraDATE.getInstance();
        this._toDatum.setPrecision(OraTemporalDatum.Precision.SECOND);
        this._toController = new TemporalController(this._toDatum, true, null);
        this._toController.setName("toController");
        this._toDe = this._toController.getDateTimeEditor();
        this._toButton = this._toController.getCalendarPopupButton();
    }

    private JPanel getInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        RichHintLabel richHintLabel = new RichHintLabel();
        if (DbaUtil.isPDB(this.getConnection())) {
            richHintLabel.setHtmlText(this._tsName);
        } else {
            richHintLabel.setHtmlText("<a href=\"http:" + this._tsName + "\">" + this._tsName + "</a>");
            richHintLabel.registerAction(this._tsName, (Action)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Class<?> clazz = Class.forName("oracle.dbtools.raptor.dba.navigator.Drill.DBADrillLink");
                        DBADrillLink dBADrillLink = (DBADrillLink)clazz.newInstance();
                        dBADrillLink.setName(UndoDisplay.this._tsName);
                        dBADrillLink.setType("TABLESPACE");
                        dBADrillLink.setOwner(UndoDisplay.this._owner);
                        dBADrillLink.setConnName(UndoDisplay.this.getConnName());
                        dBADrillLink.performDrill();
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            });
        }
        jPanel.add((Component)new JLabel(DisplayArb.getString("TABLESPACE_LABEL")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("AUTOEXTEND_LABEL")), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("RETENSION_MIN_LABEL")), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("AUTOTUNE_LABEL")), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)richHintLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(this._autoextend), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(this._retension), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(this._autoTune), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("CURR_SIZE_LABEL")), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 50, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("MAX_SIZE_LABEL")), new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 50, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("GUARANTEE_LABEL")), new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 50, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(this._curSize), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(this._maxSize), new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(this._retGuarantee), new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.setBorder(BorderFactory.createEtchedBorder(0));
        return jPanel;
    }

    private JPanel getCalPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(DisplayArb.getString("FROM"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._fromDe, (String)DisplayArb.getString("FROM"));
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)this._fromDe, "West");
        jPanel2.add((Component)this._fromButton, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel2 = new JLabel(DisplayArb.getString("TO"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._toDe, (String)DisplayArb.getString("TO"));
        jPanel3.add((Component)jLabel2, "North");
        jPanel3.add((Component)this._toDe, "West");
        jPanel3.add((Component)this._toButton, "East");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this._advButton = new JButton(DisplayArb.getString("DATE_GO"));
        ResourceUtils.resButton((AbstractButton)this._advButton, (String)DisplayArb.getString("DATE_GO"));
        this._advButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UndoDisplay.this._fromDatum.compareTo(UndoDisplay.this._toDatum) < 0) {
                    UndoDisplay.this.loadHealth();
                    UndoDisplay.this.loadMigration();
                    UndoDisplay.this.loadBestPossibleRetension();
                    UndoDisplay.this.loadLongQuery();
                    UndoDisplay.this.loadReqRetension();
                    UndoDisplay.this.loadAdvisor();
                    UndoDisplay.this.loadReqUndo();
                } else {
                    UndoDisplay.this.badHealthDates();
                }
            }
        });
        jPanel4.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this._advButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 15, 0, new Insets(0, 0, 5, 0), 0, 0));
        return jPanel4;
    }

    private void badHealthDates() {
        this.h_prob_lab.setText("");
        this.h_rec_lab.setText("");
        this.h_rat_lab.setText("");
        this.h_ret_lab.setText("");
        this.h_utb_lab.setText("");
        this.h_mig_lab.setText("");
        this.h_bpr_lab.setText("");
        this.h_lq_lab.setText("");
        this.h_rr_lab.setText("");
        this.h_ru_lab.setText("");
        this.h_req_ret.setText("");
        this.h_adv_lab.setText(DisplayArb.getString("BAD_DATE"));
        this.h_adv_lab.setToolTipText("");
    }

    private JPanel getHealthPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(DisplayArb.getString("PROBLEM_LABEL")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("REC_LABEL")), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("RATIONALE_LABEL")), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("RETENSION_LABEL")), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("UTB_LABEL")), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("RBU_LABEL")), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("BPR_LABEL")), new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("LONG_QUERY_LABEL")), new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("REQ_RET_LABEL")), new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(DisplayArb.getString("UNDO_LABEL")), new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_prob_lab, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_rec_lab, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_rat_lab, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_ret_lab, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_utb_lab, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_mig_lab, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_bpr_lab, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_lq_lab, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_rr_lab, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_adv_lab, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel getUndoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(DisplayArb.getString("REQ_UNDO_SIZE")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_ru_lab, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel getUndoInputPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(DisplayArb.getString("RETENSION_LABEL1"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.h_req_ret, (String)DisplayArb.getString("RETENSION_LABEL1"));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.h_req_ret, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JButton jButton = new JButton(DisplayArb.getString("RETEN_GO"));
        ResourceUtils.resButton((AbstractButton)jButton, (String)DisplayArb.getString("RETEN_GO"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UndoDisplay.this._fromDatum.compareTo(UndoDisplay.this._toDatum) < 0) {
                    boolean bl = false;
                    try {
                        bl = Integer.parseInt(UndoDisplay.this.h_req_ret.getText()) >= 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    if (bl) {
                        UndoDisplay.this.loadReqUndo();
                    } else {
                        UndoDisplay.this.badRetensionValue();
                    }
                    UndoDisplay.this.h_ru_lab.requestFocusInWindow();
                } else {
                    UndoDisplay.this.badHealthDates();
                }
            }
        });
        jPanel.add((Component)jButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private void badRetensionValue() {
        this.h_ru_lab.setText(DisplayArb.getString("BAD_RET_VALUE"));
    }

    private void init() {
        this._isRefreshing = true;
        this._panel.removeAll();
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(DisplayArb.getString("LOAD_TASK_NAME"), true, IRaptorTaskRunMode.MODAL){

            protected Void doWork() throws TaskException {
                Connection connection = UndoDisplay.this.getConnection();
                if (!DBUtil.checkVersion((Connection)connection, (Version)new Version("13"), (Version)new Version("10"))) {
                    throw new TaskException(null);
                }
                UndoDisplay.this.calSetup();
                UndoDisplay.this.loadData();
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UndoDisplay.this.h_req_ret.setPreferredSize(new Dimension(70, 20));
                            UndoDisplay.this._panel.setLayout(new GridBagLayout());
                            UndoDisplay.this._panel.add((Component)new JLabel(DisplayArb.getString("INFO_LABEL")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(20, 20, 0, 0), 0, 0));
                            if (UndoDisplay.this._tsName != null) {
                                UndoDisplay.this._panel.add((Component)UndoDisplay.this.getInfoPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
                                UndoDisplay.this._panel.add((Component)new JLabel(DisplayArb.getString("ADV_LABEL")), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(30, 20, 0, 0), 0, 0));
                                UndoDisplay.this._panel.add((Component)UndoDisplay.this.getCalPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
                                UndoDisplay.this._panel.add((Component)UndoDisplay.this.getHealthPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 0, new Insets(20, 20, 0, 0), 0, 0));
                                UndoDisplay.this._panel.add((Component)UndoDisplay.this.getUndoInputPanel(), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 18, 0, new Insets(20, 20, 0, 0), 0, 0));
                                UndoDisplay.this._panel.add((Component)UndoDisplay.this.getUndoPanel(), new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 20, 0, 0), 0, 0));
                                UndoDisplay.this._panel.add((Component)new JLabel(), new GridBagConstraints(0, 50, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 20, 0, 0), 0, 0));
                            }
                            UndoDisplay.this._panel.setVisible(true);
                            UndoDisplay.this._panel.validate();
                        }
                    });
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                UndoDisplay.this._isRefreshing = false;
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                UndoDisplay.this._panel.add((Component)new JLabel(DisplayArb.getString("CANCELED")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 20, 0, 0), 0, 0));
                UndoDisplay.this._isRefreshing = false;
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Connection connection = UndoDisplay.this.getConnection();
                if (DBUtil.checkVersion((Connection)connection, (Version)new Version("12"), (Version)new Version("10"))) {
                    UndoDisplay.this._panel.add((Component)new JLabel(DisplayArb.getString("BAD_VERSION")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(20, 20, 0, 0), 0, 0));
                    UndoDisplay.this._panel.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(20, 20, 0, 0), 0, 0));
                } else {
                    UndoDisplay.this._panel.add((Component)new JLabel(DisplayArb.getString("TASK_FAILED")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(20, 20, 0, 0), 0, 0));
                    UndoDisplay.this._panel.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(20, 20, 0, 0), 0, 0));
                }
                UndoDisplay.this._isRefreshing = false;
            }
        });
        if (this.loadUndoState()) {
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        } else {
            this._panel.add((Component)new JLabel(DisplayArb.getString("BAD_UNDO")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 20, 0, 0), 0, 0));
            this._isRefreshing = false;
        }
    }

    public JComponent getUI() {
        if (this._panel == null) {
            this._panel = new JPanel();
        }
        return this._panel;
    }

    public void close() {
        JPanel jPanel = this._panel;
        this._panel = null;
        if (jPanel != null && jPanel.getParent() != null) {
            jPanel.getParent().remove(jPanel);
        }
        super.close();
    }

    public void refresh(boolean bl) {
        if (!this._isRefreshing) {
            this.init();
        }
    }

    public void addActions(List<ObjectAction> list) {
    }
}

