/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.performancereport;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.controls.TemporalController;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPLTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.dba.navigator.displays.DisplayArb;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.DbInstancePanel;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.PerformanceReport;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.RowSelectionPanel;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.ide.controls.Toolbar;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class ASHReport
extends PerformanceReport {
    private DbInstancePanel dbInstancePanel;
    private JComboBox timeCombo;
    private TimePanel fromPanel;
    private TimePanel toPanel;
    private CardLayoutPanel cardPanel;
    private RowSelectionPanel sessionPanel;
    private RowSelectionPanel sqlPanel;
    private RowSelectionPanel waitClassPanel;
    private RowSelectionPanel servicePanel;
    private RowSelectionPanel modulePanel;
    private RowSelectionPanel actionPanel;
    private RowSelectionPanel clientPanel;

    public ASHReport(Connection connection, Toolbar toolbar) {
        super(connection, toolbar);
    }

    @Override
    protected JPanel createConfigurePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        boolean bl = this.isMultiInstance();
        boolean bl2 = this.isMultiDbId();
        if (bl || bl2) {
            this.dbInstancePanel = new DbInstancePanel(this.conn, bl, bl2, this.defaultDbId(), this.dbSupportsGlobal());
            this.dbInstancePanel.setBorder(new LineBorder(Color.LIGHT_GRAY));
            this.dbInstancePanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ASHReport.this.calculateGenerateEnabled();
                }
            });
        }
        jPanel2.setBorder(BorderFactory.createTitledBorder(DisplayArb.getString("PERF_PERIOD_LABEL")));
        jPanel2.setLayout(new GridBagLayout());
        this.timeCombo = new JComboBox<String>(new String[]{DisplayArb.getString("PERF_PERIOD_VALUE_LAST_5"), DisplayArb.getString("PERF_PERIOD_VALUE_LAST_10"), DisplayArb.getString("PERF_PERIOD_VALUE_LAST_30"), DisplayArb.getString("PERF_PERIOD_VALUE_LAST_60"), DisplayArb.getString("PERF_PERIOD_VALUE_LAST_SPECIFIED")});
        this.fromPanel = new TimePanel(DisplayArb.getString("PERF_FROM_LABEL"), 12, -5);
        this.toPanel = new TimePanel(DisplayArb.getString("PERF_TO_LABEL"), -1, 0);
        this.fromPanel.setEnabled(false);
        this.toPanel.setEnabled(false);
        this.timeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ASHReport.this.timeEditorsEnabled();
                ASHReport.this.fromPanel.setEnabled(bl);
                ASHReport.this.toPanel.setEnabled(bl);
                ASHReport.this.calculateGenerateEnabled();
            }
        });
        jPanel2.add((Component)this.timeCombo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 2, 5), 0, 0));
        jPanel2.add((Component)this.fromPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 2, 2, 5), 0, 0));
        jPanel2.add((Component)this.toPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(2, 5, 2, 2), 0, 0));
        int n = 0;
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.createFiltersPanel(), new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 17, 3, new Insets(5, 5, 5, 5), 0, 0));
        if (bl || bl2) {
            jPanel.add((Component)this.dbInstancePanel, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 7, 0, 7), 0, 0));
        }
        jPanel.add((Component)new JLabel(), new GridBagConstraints(2, n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean writeReport(Writer writer) {
        boolean bl;
        block20: {
            bl = false;
            int n = this.timeCombo.getSelectedIndex();
            Timestamp timestamp = null;
            Timestamp timestamp2 = null;
            if (n == 4) {
                timestamp = this.fromPanel.datum.toTimestamp();
                timestamp2 = this.toPanel.datum.toTimestamp();
            } else {
                long l = System.currentTimeMillis();
                timestamp2 = new Timestamp(l);
                if (n == 0) {
                    timestamp = new Timestamp(l - 300000L);
                } else if (n == 1) {
                    timestamp = new Timestamp(l - 600000L);
                } else if (n == 2) {
                    timestamp = new Timestamp(l - 1800000L);
                } else if (n == 3) {
                    timestamp = new Timestamp(l - 3600000L);
                }
            }
            Object object = this.bindValueFromSelectionPanelValue(this.sessionPanel.getSelectedItemId());
            Object object2 = this.bindValueFromSelectionPanelValue(this.sqlPanel.getSelectedItemId());
            Object object3 = this.bindValueFromSelectionPanelValue(this.waitClassPanel.getSelectedItemId());
            Object object4 = this.bindValueFromSelectionPanelValue(this.servicePanel.getSelectedItemId());
            Object object5 = this.bindValueFromSelectionPanelValue(this.modulePanel.getSelectedItemId());
            Object object6 = this.bindValueFromSelectionPanelValue(this.actionPanel.getSelectedItemId());
            Object object7 = this.bindValueFromSelectionPanelValue(this.clientPanel.getSelectedItemId());
            try {
                if (!Connections.getInstance().lock(this.conn)) break block20;
                ResultSetWrapper resultSetWrapper = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
                    dBUtil.setRaiseError(true);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("DB_ID", this.dbId());
                    hashMap.put("INSTANCE_NUMBER", this.instanceNumber());
                    hashMap.put("BEGIN_TIME", timestamp);
                    hashMap.put("END_TIME", timestamp2);
                    hashMap.put("SID", object);
                    hashMap.put("SQL_ID", object2);
                    hashMap.put("WAIT_CLASS", object3);
                    hashMap.put("SERVICE_HASH", object4);
                    hashMap.put("MODULE", object5);
                    hashMap.put("ACTION", object6);
                    hashMap.put("CLIENT_ID", object7);
                    resultSetWrapper = this.hasMultipleInstanceNumbers() ? dBUtil.executeOracleQuery(Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getGlobalASHReport"), hashMap) : dBUtil.executeOracleQuery(Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getASHReport"), hashMap);
                    if (resultSetWrapper != null) {
                        ResultSet resultSet = resultSetWrapper.getResultSet();
                        while (resultSet.next()) {
                            String string = resultSet.getString(1);
                            if (string == null) {
                                string = "";
                            }
                            string = string.trim() + "\n";
                            writer.write(string);
                        }
                        bl = true;
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                finally {
                    if (resultSetWrapper != null) {
                        resultSetWrapper.close();
                    }
                    Connections.getInstance().unlock(this.conn);
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        return bl;
    }

    private boolean timeEditorsEnabled() {
        return this.timeCombo.getSelectedIndex() == this.timeCombo.getItemCount() - 1;
    }

    private JPanel createFiltersPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TreeMap<String, RowSelectionPanel> treeMap = new TreeMap<String, RowSelectionPanel>();
        this.sessionPanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getASHSessionIDs"), null, new String[]{DisplayArb.getString("PERF_FILTER_COL_SESSION_ID")}, 30);
        this.sqlPanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getAshSQLIDs"), null, new String[]{DisplayArb.getString("PERF_FILTER_COL_SQL_ID")}, 30);
        this.waitClassPanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getASHWaitClasses"), null, new String[]{DisplayArb.getString("PERF_FILTER_COL_WAIT_CLASS")}, 30);
        this.servicePanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getASHServiceHashes"), null, new String[]{DisplayArb.getString("PERF_FILTER_COL_SERVICE_HASH")}, 30);
        this.modulePanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getASHModules"), null, new String[]{DisplayArb.getString("PERF_FILTER_COL_MODULE")}, 30);
        this.actionPanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getASHActions"), null, new String[]{DisplayArb.getString("PERF_FILTER_COL_ACTION")}, 30);
        this.clientPanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getASHClientIDs"), null, new String[]{DisplayArb.getString("PERF_FILTER_COL_CLIENT_ID")}, 30);
        treeMap.put(DisplayArb.getString("PERF_FILTER_NAME_SESSION"), this.sessionPanel);
        treeMap.put(DisplayArb.getString("PERF_FILTER_NAME_SQL"), this.sqlPanel);
        treeMap.put(DisplayArb.getString("PERF_FILTER_NAME_WAIT_CLASS"), this.waitClassPanel);
        treeMap.put(DisplayArb.getString("PERF_FILTER_NAME_SERVICE"), this.servicePanel);
        treeMap.put(DisplayArb.getString("PERF_FILTER_NAME_MODULE"), this.modulePanel);
        treeMap.put(DisplayArb.getString("PERF_FILTER_NAME_ACTION"), this.actionPanel);
        treeMap.put(DisplayArb.getString("PERF_FILTER_NAME_CLIENT"), this.clientPanel);
        this.cardPanel = new CardLayoutPanel(treeMap, DisplayArb.getString("PERF_FILTERS_LABEL"), CardLayoutPanel.Type.TITLE_BORDER);
        jPanel.add((Component)this.cardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void calculateGenerateEnabled() {
        boolean bl;
        String string = this.instanceNumber();
        String string2 = this.dbId();
        boolean bl2 = bl = string != null && !string.equals("") && string2 != null && !string2.equals("");
        if (bl && this.timeEditorsEnabled()) {
            Date date;
            Date date2 = this.fromPanel.editor.getDate();
            bl = date2.compareTo(date = this.toPanel.editor.getDate()) < 0;
        }
        this.enableGenerate(bl);
    }

    private Object bindValueFromSelectionPanelValue(String string) {
        return string == null || string.equals("") ? DBUtil.NULL_VALUE : string;
    }

    private String instanceNumber() {
        return this.dbInstancePanel != null ? this.dbInstancePanel.instanceNumber() : "1";
    }

    private boolean hasMultipleInstanceNumbers() {
        return this.dbInstancePanel != null ? this.dbInstancePanel.hasMultipleInstanceNumbers() : false;
    }

    private String dbId() {
        return this.dbInstancePanel != null ? this.dbInstancePanel.dbId() : this.defaultDbId();
    }

    class TimePanel
    extends JPanel {
        private OraTemporalDatum datum;
        private TemporalController controller;
        private CalendarPopupButton button;
        private DateTimeEditor editor;

        TimePanel(String string, int n, int n2) {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.datum = OraTIMESTAMPLTZ.getInstance((TimeZone)NLSUtils.getSessionTimeZone((Connection)ASHReport.this.conn));
            this.datum.setPrecision(OraTemporalDatum.Precision.SECOND);
            if (n >= 0) {
                this.datum.add(n, n2);
            }
            this.controller = new TemporalController(this.datum, true, null);
            this.editor = this.controller.getDateTimeEditor();
            this.button = this.controller.getCalendarPopupButton();
            this.editor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ASHReport.this.calculateGenerateEnabled();
                }
            });
            this.add((Component)this.editor, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.button, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.controller.setEnabled(bl);
            this.button.setEnabled(bl);
            this.editor.setEnabled(bl);
        }
    }
}

