/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.performancereport;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dba.navigator.displays.DisplayArb;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;

public abstract class PerformanceReport {
    protected Connection conn;
    private Toolbar toolbar;
    private JPanel panel;
    private boolean generateEnabled;
    private boolean saveToFileEnabled;
    private boolean openInBrowserEnabled;
    private JEditorPane reportPane;
    private File tempReportFile;
    private JPanel configurationPanel;
    private HyperlinkListener hyperlinkListener;
    private boolean canToggleInputs;
    private boolean openInBrowserSupported;
    private JScrollPane contentScrollPane;
    private boolean multiInstance;
    private boolean multiDbId;
    private String defaultDbId;
    private boolean dbSupportsGlobal;

    public PerformanceReport(Connection connection, Toolbar toolbar) {
        this.conn = connection;
        this.toolbar = toolbar;
        this.hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    PerformanceReport.this.reportPane.scrollToReference(hyperlinkEvent.getURL().getRef());
                }
            }
        };
        this.openInBrowserSupported = Desktop.isDesktopSupported();
        this.multiInstance = QueryUtils.hasRequiredFeatures((Connection)connection, (String[])new String[]{"multi_instance"});
        this.querySupportsGlobal(connection);
        this.queryMultiDbIdInfo(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryMultiDbIdInfo(Connection connection) {
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap hashMap = new HashMap();
                resultSetWrapper = dBUtil.executeOracleQuery(Utils.getQuery(this.getClass(), (Connection)connection, (String)"getDBIDCount"), hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        this.multiDbId = resultSet.getInt(1) > 1;
                        this.defaultDbId = resultSet.getString(2);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private void querySupportsGlobal(Connection connection) {
        try {
            int n = connection.getMetaData().getDatabaseMajorVersion();
            int n2 = connection.getMetaData().getDatabaseMinorVersion();
            this.dbSupportsGlobal = n > 11 || n == 11 && n2 >= 2;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    public void initUI(JPanel jPanel) {
        this.panel = jPanel;
        this.setupAccelerators(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.configurationPanel = this.createConfigurePanel();
        jPanel2.add((Component)this.configurationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JComponent jComponent = this.createContentComponent();
        jComponent.setBorder(new LineBorder(Color.LIGHT_GRAY));
        jPanel2.add((Component)jComponent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.contentScrollPane = new JScrollPane();
        this.contentScrollPane.setViewportView(jPanel2);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.contentScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public boolean canToggleInputs() {
        return this.canToggleInputs;
    }

    public boolean canGenerateReport() {
        return this.generateEnabled;
    }

    public boolean canSaveToFile() {
        return this.saveToFileEnabled;
    }

    public boolean canOpenInBrowser() {
        return this.openInBrowserEnabled;
    }

    public void toggleInputs() {
        if (this.canToggleInputs) {
            boolean bl = this.configurationPanel.isVisible();
            if (bl) {
                this.configurationPanel.setVisible(false);
            } else {
                this.configurationPanel.setVisible(true);
                this.contentScrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
        }
    }

    public void generateReport() {
        this.saveToFileEnabled = false;
        this.openInBrowserEnabled = false;
        this.refreshToolbar();
        this.reportPane.removeHyperlinkListener(this.hyperlinkListener);
        this.reportPane.setText("<tt>" + DisplayArb.getString("PERF_GENERATING") + "</tt>");
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(DisplayArb.getString("PERF_GENERATING_REPORT"), true, IRaptorTaskRunMode.MODAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                try {
                    PerformanceReport.this.tempReportFile = File.createTempFile("SQLDEV_PERF_REPORT", ".html");
                    FileWriter fileWriter = new FileWriter(PerformanceReport.this.tempReportFile);
                    boolean bl = false;
                    try {
                        bl = PerformanceReport.this.writeReport(fileWriter);
                    }
                    finally {
                        ((Writer)fileWriter).close();
                    }
                    final boolean bl2 = bl;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (bl2) {
                                    PerformanceReport.this.reportPane.setPage(PerformanceReport.this.tempReportFile.toURI().toURL());
                                    PerformanceReport.this.reportPane.addHyperlinkListener(PerformanceReport.this.hyperlinkListener);
                                    PerformanceReport.this.canToggleInputs = true;
                                    PerformanceReport.this.saveToFileEnabled = true;
                                    if (PerformanceReport.this.openInBrowserSupported) {
                                        PerformanceReport.this.openInBrowserEnabled = true;
                                    }
                                    PerformanceReport.this.refreshToolbar();
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            PerformanceReport.this.setInputsVisible(false);
                                        }
                                    });
                                } else {
                                    PerformanceReport.this.reportPane.setText("");
                                }
                            }
                            catch (IOException iOException) {
                                oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)iOException);
                            }
                        }
                    });
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        oracle.dbtools.util.Logger.ignore(((Object)((Object)this)).getClass(), (Throwable)interruptedException);
                    }
                }
                catch (IOException iOException) {
                    throw new TaskException((Throwable)iOException);
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(DisplayArb.getString("PERF_HTML_FILES"), ".html"));
        uRLFileChooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(DisplayArb.getString("PERF_ALL_FILES")));
        uRLFileChooser.setFileSelectionMode(0);
        int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), DisplayArb.getString("PERF_SAVE_REPORT_TO_FILE"));
        String string = null;
        if (n == 0) {
            string = uRLFileChooser.getSelectedFile().toString();
            try {
                FileWriter fileWriter = new FileWriter(string);
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(this.tempReportFile));
                    try {
                        String string2 = bufferedReader.readLine();
                        while (string2 != null) {
                            fileWriter.write(string2 + "\n");
                            string2 = bufferedReader.readLine();
                        }
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
                finally {
                    ((Writer)fileWriter).close();
                }
            }
            catch (IOException iOException) {
                oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)iOException);
                MessageDialog.error((Component)this.panel, (Object)DisplayArb.getString("PERF_UNABLE_TO_SAVE_FILE"), (String)DisplayArb.getString("PERF_ERROR"), null);
            }
        }
    }

    public void openInBrowser() {
        try {
            Desktop.getDesktop().browse(this.tempReportFile.toURI());
        }
        catch (IOException iOException) {
            oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)iOException);
            MessageDialog.error((Component)this.panel, (Object)DisplayArb.getString("PERF_UNABLE_TO_OPEN_IN_BROWER"), (String)DisplayArb.getString("PERF_ERROR"), null);
        }
    }

    protected boolean dbSupportsGlobal() {
        return this.dbSupportsGlobal;
    }

    protected boolean isMultiInstance() {
        return this.multiInstance;
    }

    protected boolean isMultiDbId() {
        return this.multiDbId;
    }

    protected String defaultDbId() {
        return this.defaultDbId;
    }

    protected void enableGenerate(boolean bl) {
        this.generateEnabled = bl;
        this.refreshToolbar();
    }

    protected abstract JPanel createConfigurePanel();

    protected abstract boolean writeReport(Writer var1);

    private void setInputsVisible(boolean bl) {
        this.configurationPanel.setVisible(bl);
    }

    private JComponent createContentComponent() {
        this.reportPane = new JEditorPane("text/html", "");
        this.reportPane.setEditable(false);
        this.reportPane.addHyperlinkListener(this.hyperlinkListener);
        this.reportPane.putClientProperty("JEditorPane.w3cLengthUnits", true);
        return this.reportPane;
    }

    private void refreshToolbar() {
        View.updateToolbarActions((Toolbar)this.toolbar);
    }

    private void setupAccelerators(JPanel jPanel) {
        try {
            InputMap inputMap = jPanel.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(80, 192, false);
            Object object = inputMap.get(keyStroke);
            InputMap inputMap2 = new InputMap();
            inputMap2.put(keyStroke, object);
            UIUtils.addIdeKeyBindings((JComponent)jPanel, (int)1, (String)"oracle/dbtools/raptor/dba/navigator/accelerators.xml", (InputMap)inputMap2);
            UIUtils.setupAccelerators((Toolbar)this.toolbar, (String)"oracle/dbtools/raptor/dba/navigator/accelerators.xml");
        }
        catch (Exception exception) {
            oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)exception);
        }
    }
}

