/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.performancereport;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dba.navigator.displays.DisplayArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.ui.PopupButton;

public class RowSelectionPanel
extends JPanel {
    private Connection conn;
    private Map<String, ?> binds;
    private String[] tableColNames;
    private String query;
    private JTextField rowIdent;
    private JPanel popupContent;
    private JLabel loadingLabel;
    private JTable popupTable;
    private DefaultTableModel tableModel;
    private PanelPopupButton popupButton;
    private boolean tablePopulationInitiated;
    private PropertyChangeSupport changeSupport;
    boolean multiSelect;

    public RowSelectionPanel(Connection connection, String string, Map<String, ?> map, String[] stringArray, int n) {
        this(connection, string, map, stringArray, n, false);
    }

    public RowSelectionPanel(Connection connection, String string, Map<String, ?> hashMap, String[] stringArray, int n, boolean bl) {
        this.setLayout(new GridBagLayout());
        this.conn = connection;
        this.tableColNames = stringArray;
        this.query = string;
        this.binds = hashMap != null ? hashMap : new HashMap();
        this.multiSelect = bl;
        this.changeSupport = new PropertyChangeSupport(this);
        this.rowIdent = new JTextField(n);
        this.rowIdent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RowSelectionPanel.this.changeSupport.firePropertyChange(null, null, null);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RowSelectionPanel.this.changeSupport.firePropertyChange(null, null, null);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.popupButton = new PanelPopupButton();
        this.popupButton.setText(DisplayArb.getString("PERF_BROWSE"));
        this.add((Component)this.rowIdent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)((Object)this.popupButton), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getSelectedItemId() {
        return this.rowIdent.getText();
    }

    public void setSelectedItemId(String string) {
        this.rowIdent.setText(string);
    }

    private void openPopupAndPopulateIfNeeded() {
        if (!this.tablePopulationInitiated) {
            this.tablePopulationInitiated = true;
            this.initPopupContent();
            this.popupButton.openPopup();
            RaptorTask<Void> raptorTask = new RaptorTask<Void>("", true, IRaptorTaskRunMode.NO_GUI){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void doWork() throws TaskException {
                    final ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                    if (Connections.getInstance().lock(RowSelectionPanel.this.conn)) {
                        ResultSetWrapper resultSetWrapper = null;
                        try {
                            DBUtil dBUtil = DBUtil.getInstance((Connection)RowSelectionPanel.this.conn);
                            dBUtil.setRaiseError(true);
                            resultSetWrapper = dBUtil.executeOracleQuery(RowSelectionPanel.this.query, RowSelectionPanel.this.binds);
                            if (resultSetWrapper != null) {
                                ResultSet resultSet = resultSetWrapper.getResultSet();
                                while (resultSet.next()) {
                                    Object[] objectArray = new Object[RowSelectionPanel.this.tableColNames.length];
                                    for (int i = 0; i < RowSelectionPanel.this.tableColNames.length; ++i) {
                                        objectArray[i] = resultSet.getString(i + 1);
                                    }
                                    arrayList.add(objectArray);
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                        }
                        finally {
                            if (resultSetWrapper != null) {
                                resultSetWrapper.close();
                            }
                            Connections.getInstance().unlock(RowSelectionPanel.this.conn);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RowSelectionPanel.this.loadPopupContent(arrayList);
                        }
                    });
                    return null;
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        } else {
            this.popupButton.openPopup();
        }
    }

    private void initPopupContent() {
        this.popupContent = new JPanel();
        this.popupContent.setLayout(new GridBagLayout());
        this.loadingLabel = new JLabel(DisplayArb.getString("PERF_LOADING"));
        this.tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.popupTable = new JTable(this.tableModel);
        this.popupTable.getSelectionModel().setSelectionMode(this.multiSelect ? 2 : 0);
        Dimension dimension = this.popupTable.getPreferredScrollableViewportSize();
        dimension.setSize(dimension.getWidth(), (double)(this.popupTable.getRowHeight() * 10));
        this.popupTable.setPreferredScrollableViewportSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(this.popupTable);
        this.popupContent.add((Component)this.loadingLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.popupContent.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.popupButton.setPopupContent(this.popupContent);
    }

    private void loadPopupContent(List<Object[]> list) {
        this.popupContent.remove(this.loadingLabel);
        for (String string : this.tableColNames) {
            this.tableModel.addColumn(string);
        }
        for (Object[] objectArray : list) {
            this.tableModel.addRow(objectArray);
        }
        this.popupTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    Point point = mouseEvent.getPoint();
                    int n = RowSelectionPanel.this.popupTable.rowAtPoint(point);
                    if (n >= 0) {
                        RowSelectionPanel.this.popupButton.closePopup();
                    }
                }
            }
        });
        this.popupTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown()) {
                    RowSelectionPanel.this.popupButton.closePopup();
                }
            }
        });
    }

    class PanelPopupButton
    extends PopupButton {
        PanelPopupButton() {
            this.setMargin(new Insets(4, 1, 4, 1));
        }

        void openPopup() {
            super.showPopup();
        }

        void closePopup() {
            int[] nArray = RowSelectionPanel.this.popupTable.getSelectedRows();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (int n : nArray) {
                String string = RowSelectionPanel.this.tableModel.getValueAt(n, 0).toString();
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string);
            }
            RowSelectionPanel.this.rowIdent.setText(stringBuilder.toString());
            this.hidePopup();
        }

        protected void showPopup() {
            RowSelectionPanel.this.openPopupAndPopulateIfNeeded();
        }
    }
}

