/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.performancereport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dba.navigator.displays.DisplayArb;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.PerformanceReport;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.RowSelectionPanel;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.SnapshotPanel;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controls.Toolbar;

public class SQLReport
extends PerformanceReport {
    private SnapshotPanel snapPanel;
    private RowSelectionPanel sqlIdPanel;

    public SQLReport(Connection connection, Toolbar toolbar) {
        super(connection, toolbar);
    }

    @Override
    protected JPanel createConfigurePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.snapPanel = new SnapshotPanel(this.conn, DisplayArb.getString("PERF_SNAPSHOT_RANGE"), this.isMultiInstance(), this.isMultiDbId(), this.defaultDbId(), false);
        this.snapPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SQLReport.this.setEnableGenerate();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(DisplayArb.getString("PERF_SQL_ID_TITLE")));
        this.sqlIdPanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getSQLIDs"), null, new String[]{DisplayArb.getString("PERF_SQL_ID"), DisplayArb.getString("PERF_SESSION_ID"), DisplayArb.getString("PERF_SERIAL_NO"), DisplayArb.getString("PERF_SQL")}, 20);
        this.sqlIdPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SQLReport.this.setEnableGenerate();
            }
        });
        jPanel2.add((Component)this.sqlIdPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.snapPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 10, 5, 5), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean writeReport(Writer writer) {
        boolean bl;
        block11: {
            bl = false;
            String[] stringArray = this.snapPanel.resolvedSnapshotIds();
            String string = this.sqlIdPanel.getSelectedItemId();
            try {
                if (!Connections.getInstance().lock(this.conn)) break block11;
                ResultSetWrapper resultSetWrapper = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("DB_ID", this.snapPanel.dbId());
                    hashMap.put("INSTANCE_NUMBER", this.snapPanel.instanceNumber());
                    hashMap.put("START_ID", stringArray[0]);
                    hashMap.put("END_ID", stringArray[1]);
                    hashMap.put("SQL_ID", string);
                    resultSetWrapper = dBUtil.executeOracleQuery(Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getSQLReport"), hashMap);
                    if (resultSetWrapper != null) {
                        ResultSet resultSet = resultSetWrapper.getResultSet();
                        while (resultSet.next()) {
                            String string2 = resultSet.getString(1);
                            if (string2 == null) {
                                string2 = "";
                            }
                            string2 = string2.trim() + "\n";
                            writer.write(string2);
                        }
                        bl = true;
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                finally {
                    if (resultSetWrapper != null) {
                        resultSetWrapper.close();
                    }
                    Connections.getInstance().unlock(this.conn);
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        return bl;
    }

    private void setEnableGenerate() {
        String string;
        boolean bl;
        String string2 = this.snapPanel.instanceNumber();
        boolean bl2 = bl = string2 != null && !string2.equals("");
        if (bl) {
            if (this.snapPanel.baselineSelected()) {
                string = this.snapPanel.baselineName();
                bl = string != null && !string.equals("");
            } else {
                string = this.snapPanel.startSnapId();
                String string3 = this.snapPanel.endSnapId();
                boolean bl3 = bl = string != null && !string.equals("") && string3 != null && !string3.equals("");
                if (bl) {
                    try {
                        int n = Integer.parseInt(string);
                        int n2 = Integer.parseInt(string3);
                        bl = n2 > n;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                }
            }
        }
        if (bl) {
            string = this.sqlIdPanel.getSelectedItemId();
            bl = string != null && !string.equals("");
        }
        this.enableGenerate(bl);
    }
}

