/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.viewers.parameters;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.display.DisplayEditableResultTable;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTable;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.viewers.parameters.ParameterUpdateAction;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class ParameterToolbarAction
implements Controller {
    private String _conn;
    private JEWTDialog dlg;
    private JCheckBox mem;
    private JCheckBox spfile;
    private String scope;
    private boolean commit = false;

    public boolean handleEvent(IdeAction ideAction, Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        IDisplay iDisplay = null;
        View view = context.getView();
        if (view instanceof XMLBasedEditor) {
            iDisplay = ((XMLBasedEditor)view).getMainUI();
        }
        if (iDisplay instanceof DisplayEditableResultTable) {
            DisplayEditableResultTable displayEditableResultTable = (DisplayEditableResultTable)iDisplay;
            this._conn = displayEditableResultTable.getConnName();
            ResultSetTable resultSetTable = displayEditableResultTable.getGrid();
            if (resultSetTable instanceof EditableResultSetTable) {
                try {
                    if (this.setScope()) {
                        EditableResultSetTable editableResultSetTable = (EditableResultSetTable)resultSetTable;
                        List list = editableResultSetTable.getGridModel().getChangedRows();
                        if (list.size() > 0) {
                            for (RaptorGridRowModel raptorGridRowModel : list) {
                                if (!raptorGridRowModel.isUpdated()) continue;
                                stringBuffer.append(ParameterUpdateAction.getSQL(raptorGridRowModel, this.scope) + "\n");
                            }
                        } else {
                            stringBuffer.append(DbaNavigatorResources.getString("NO_CHANGES"));
                        }
                        JTextArea jTextArea = new JTextArea(stringBuffer.toString());
                        jTextArea.setEditable(false);
                        MessageDialog.information(null, (Object)jTextArea, (String)"SQL", (String)"f1_showparamsql_html");
                        return true;
                    }
                }
                catch (DBException dBException) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)dBException.getLocalizedMessage(), (String)DbaNavigatorResources.getString("INVALID_SCOPE_TITLE"), null);
                    return true;
                }
            }
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    private void showDialog(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mem = new JCheckBox(DbaNavigatorResources.getString("PARAM_MEMORY"));
        this.mem.setSelected(true);
        this.spfile = new JCheckBox(DbaNavigatorResources.getString("PARAM_SPFILE"));
        jPanel.add((Component)this.mem, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        if (string.equals("SPFILE")) {
            jPanel.add((Component)this.spfile, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        }
        jPanel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        String string2 = DbaNavigatorResources.getString("PARAMETER_TITLE");
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string2, (int)10);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParameterToolbarAction.this.commit = true;
                ParameterToolbarAction.this.dlg.dispose();
            }
        });
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 200;
        int n2 = (int)dimension.getWidth() + 200;
        this.dlg.setSize(n2, n);
        this.dlg.setMinimumSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        WizardLauncher.runDialog((JDialog)this.dlg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setScope() throws DBException {
        this.commit = false;
        Connection connection = Connections.getInstance().getConnection(this._conn);
        String string = "SELECT DECODE(value, NULL, 'PFILE', 'SPFILE') Type FROM sys.v_$parameter WHERE name = 'spfile'";
        if (Connections.getInstance().lock(connection)) {
            try {
                String string2 = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string);
                this.showDialog(string2);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        if (this.commit) {
            if (this.mem.isSelected() && this.spfile.isSelected()) {
                this.scope = "BOTH";
            } else if (this.mem.isSelected()) {
                this.scope = "MEMORY";
            } else if (this.spfile.isSelected()) {
                this.scope = "SPFILE";
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("INVALID_SCOPE"), (String)DbaNavigatorResources.getString("INVALID_SCOPE_TITLE"), null);
                return false;
            }
            return true;
        }
        return false;
    }
}

