/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizSource;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp.DpImpWizMain;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class DpImpWizOptions
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JTextField _threadNumber = new JTextField(5);
    boolean _isShowGoToSummary = true;
    private JComboBox _directoriesCombo;
    private JLabel _logLabel = new JLabel(DpWizardArb.getString("EXP_LOG_FILE"));
    private JCheckBox _cb;
    private JTextField _logFile = new JTextField(15);
    private JCheckBox _cbObject;
    private JRadioButton _rbNull = new JRadioButton();
    private JRadioButton _rbSkip = new JRadioButton(DpWizardArb.getString("IMP_SKIP"));
    private JRadioButton _rbAppend = new JRadioButton(DpWizardArb.getString("IMP_APPEND"));
    private JRadioButton _rbTruncate = new JRadioButton(DpWizardArb.getString("IMP_TRUNCATE"));
    private JRadioButton _rbReplace = new JRadioButton(DpWizardArb.getString("IMP_REPLACE"));
    private JCheckBox _cbOverwriteExistingDatafiles;
    private JCheckBox _cbSkipIndexes;
    private JCheckBox _cbGoToSummary = new JCheckBox();
    private ButtonGroup bg = new ButtonGroup();
    private DpExpWizSource.MetadataEnum _ddlOrBoth = DpExpWizSource.MetadataEnum.BOTH;

    public DpImpWizOptions() {
        this.buildUI();
    }

    public void buildUI() {
        this.setLayout(new GridBagLayout());
        this.add(new JLabel(DpWizardArb.getString("EXP_THREAD_LABEL")), LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START));
        this.add(this._threadNumber, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_END_LABEL2CONTROL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this._directoriesCombo = new JComboBox<String>(new String[0]);
        this.addLabelandText(jPanel, 0, this._logLabel, this._directoriesCombo);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, LayoutControl.GBC.gbc((int)0, (int)0, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        this._cb = new JCheckBox(DpWizardArb.getString("EXP_ENABLE_LOGGING"));
        TitledPane titledPane = new TitledPane((Component)this._cb, (Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.add((Component)titledPane, LayoutControl.GBC.gbc((int)0, (int)0, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        jPanel.add((Component)this._logFile, LayoutControl.GBC.gbc((int)2, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_END_LABEL2CONTROL_SUB));
        this.add(jPanel3, LayoutControl.GBC.gbc((int)0, (int)2, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START));
        this.bg.add(this._rbNull);
        this.bg.add(this._rbSkip);
        this.bg.add(this._rbAppend);
        this.bg.add(this._rbTruncate);
        this.bg.add(this._rbReplace);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.add((Component)this._rbSkip, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.PAGE_START_FULL_SUB));
        jPanel4.add((Component)this._rbAppend, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_FULL_SUB));
        jPanel4.add((Component)this._rbTruncate, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_FULL_SUB));
        jPanel4.add((Component)this._rbReplace, LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.PAGE_END_FULL_SUB));
        jPanel4.add(Box.createHorizontalGlue(), LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)jPanel4, LayoutControl.GBC.gbc((int)0, (int)0, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        jPanel5.add(Box.createHorizontalGlue(), LayoutControl.GBC.gbc((int)4, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._cbObject = new JCheckBox(DpWizardArb.getString("IMP_ACTION_ON_TABLE_EXISTS"));
        this._cbObject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DpImpWizOptions.this.setTableExistsEnabled(true);
                } else {
                    DpImpWizOptions.this.setTableExistsEnabled(false);
                }
            }
        });
        this.setTableExistsEnabled(false);
        TitledPane titledPane2 = new TitledPane((Component)this._cbObject, (Component)jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        jPanel6.add((Component)titledPane2, LayoutControl.GBC.gbc((int)0, (int)0, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        this.add(jPanel6, LayoutControl.GBC.gbc((int)0, (int)3, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START));
        this._cbOverwriteExistingDatafiles = new JCheckBox(DpWizardArb.getString("IMP_OVERWRITE_EXISTING_DATAFILES"));
        this.add(this._cbOverwriteExistingDatafiles, LayoutControl.GBC.gbc((int)0, (int)4, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_FULL));
        this._cbSkipIndexes = new JCheckBox(DpWizardArb.getString("IMP_SKIP_INDEXES"));
        this.add(this._cbSkipIndexes, LayoutControl.GBC.gbc((int)0, (int)5, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.PAGE_END_FULL));
        this.add(Box.createHorizontalGlue(), LayoutControl.GBC.gbc((int)4, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(Box.createVerticalGlue(), LayoutControl.GBC.gbc((int)0, (int)6, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
        if (this._isShowGoToSummary) {
            ResourceUtils.resButton((AbstractButton)this._cbGoToSummary, (String)StringUtils.stripMnemonic((String)UiResources.getString((String)"GOTO_SUMMARY")));
            this.add(this._cbGoToSummary, LayoutControl.GBC.gbc((int)0, (int)7, (int)4, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.PAGE_END_FULL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.LINE_START));
        }
    }

    private void setTableExistsEnabled(boolean bl) {
        if (!this._ddlOrBoth.equals((Object)DpExpWizSource.MetadataEnum.DATA) || !bl) {
            this._rbSkip.setEnabled(bl);
            this._rbReplace.setEnabled(bl);
        }
        this._rbAppend.setEnabled(bl);
        this._rbTruncate.setEnabled(bl);
    }

    private void addLabelandText(JPanel jPanel, int n, JLabel jLabel, JComponent jComponent) {
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_SUB, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        jPanel.add((Component)jComponent, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_END_CONTROL2BUTTON_SUB, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
    }

    public void onEntry(TraversableContext traversableContext) {
        this._cbGoToSummary.setSelected(false);
        ExtractListModel extractListModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        this._ddlOrBoth = (DpExpWizSource.MetadataEnum)((Object)DpWizCommon.getOrInitializeList(extractListModel, "DP_KEY_STOREMETA", (Object)DpExpWizSource.MetadataEnum.BOTH));
        this._threadNumber.setText((String)DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_THREAD_NUMBER", "1"));
        this._cb.setSelected((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_LOG_ENABLED", Boolean.TRUE));
        this._directoriesCombo.removeAllItems();
        boolean bl = false;
        String[] stringArray = DpWizCommon.getDirectories(traversableContext);
        for (String string : stringArray) {
            this._directoriesCombo.addItem(string);
            if (!string.equals("DATA_PUMP_DIR")) continue;
            bl = true;
        }
        if (bl) {
            this._directoriesCombo.setSelectedItem("DATA_PUMP_DIR");
        } else if (stringArray.length != 0) {
            this._directoriesCombo.setSelectedItem(stringArray[0]);
        }
        this._logFile.setText((String)DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_LOGFILE", "IMPORT.LOG"));
        this._cbObject.setSelected((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "IMP_ACTION_ON_TABLE_ENABLED", Boolean.FALSE));
        DpImpWizMain.ActionOnTables actionOnTables = (DpImpWizMain.ActionOnTables)((Object)DpWizCommon.getOrInitializeList(extractListModel, "IMP_ACTION_ON_TABLE_ENUM", (Object)DpImpWizMain.ActionOnTables.NULL));
        if (this._ddlOrBoth.equals((Object)DpExpWizSource.MetadataEnum.DATA)) {
            this._rbSkip.setEnabled(false);
            this._rbReplace.setEnabled(false);
        } else {
            this._rbSkip.setEnabled(this._rbAppend.isEnabled());
            this._rbReplace.setEnabled(this._rbAppend.isEnabled());
        }
        switch (actionOnTables) {
            case NULL: {
                this._rbNull.setSelected(true);
                break;
            }
            case SKIP: {
                if (!this._ddlOrBoth.equals((Object)DpExpWizSource.MetadataEnum.DATA)) {
                    this._rbSkip.setSelected(true);
                    break;
                }
                this._rbNull.setSelected(true);
                break;
            }
            case APPEND: {
                this._rbAppend.setSelected(true);
                break;
            }
            case TRUNCATE: {
                this._rbTruncate.setSelected(true);
                break;
            }
            case REPLACE: {
                if (!this._ddlOrBoth.equals((Object)DpExpWizSource.MetadataEnum.DATA)) {
                    this._rbReplace.setSelected(true);
                    break;
                }
                this._rbNull.setSelected(true);
            }
        }
        String string = (String)extractListModel.getPropertyValue("DP_KEY_BRANCH");
        if (string.equals("IMP_FULL")) {
            this._cbOverwriteExistingDatafiles.setVisible(true);
        } else {
            this._cbOverwriteExistingDatafiles.setVisible(false);
        }
        this._cbOverwriteExistingDatafiles.setSelected((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "IMP_OVERWRIGHT_DATAFILES", Boolean.FALSE));
        this._cbSkipIndexes.setSelected((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "IMP_SKIP_INDEXES", Boolean.FALSE));
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ExtractListModel extractListModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        int n = -1;
        try {
            n = Integer.parseInt(this._threadNumber.getText());
        }
        catch (NumberFormatException numberFormatException) {
            throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", numberFormatException.getLocalizedMessage()), DpWizardArb.getString("IMP_EXCEPTION_OCCURRED"));
        }
        extractListModel.setProperty("DP_EXP_THREAD_NUMBER", (Object)this._threadNumber.getText());
        Boolean bl = Boolean.FALSE;
        if (this._cb.isSelected()) {
            bl = Boolean.TRUE;
        }
        extractListModel.setProperty("DP_EXP_LOG_ENABLED", (Object)bl);
        extractListModel.setProperty("DP_EXP_LOGFILE", (Object)this._logFile.getText());
        Object object = this._directoriesCombo.getSelectedItem();
        if (object != null) {
            extractListModel.setProperty("DP_EXP_LOGDIR", (Object)object.toString());
        }
        bl = Boolean.FALSE;
        if (this._cbObject.isSelected()) {
            bl = Boolean.TRUE;
        }
        extractListModel.setProperty("IMP_ACTION_ON_TABLE_ENABLED", (Object)bl);
        DpImpWizMain.ActionOnTables actionOnTables = DpImpWizMain.ActionOnTables.NULL;
        if (this._ddlOrBoth.equals((Object)DpExpWizSource.MetadataEnum.DATA)) {
            if (this._rbAppend.isSelected()) {
                actionOnTables = DpImpWizMain.ActionOnTables.APPEND;
            } else if (this._rbTruncate.isSelected()) {
                actionOnTables = DpImpWizMain.ActionOnTables.TRUNCATE;
            }
        } else if (this._rbSkip.isSelected()) {
            actionOnTables = DpImpWizMain.ActionOnTables.SKIP;
        } else if (this._rbAppend.isSelected()) {
            actionOnTables = DpImpWizMain.ActionOnTables.APPEND;
        } else if (this._rbTruncate.isSelected()) {
            actionOnTables = DpImpWizMain.ActionOnTables.TRUNCATE;
        } else if (this._rbReplace.isSelected()) {
            actionOnTables = DpImpWizMain.ActionOnTables.REPLACE;
        }
        extractListModel.setProperty("IMP_ACTION_ON_TABLE_ENUM", (Object)actionOnTables);
        bl = Boolean.FALSE;
        if (this._cbOverwriteExistingDatafiles.isSelected()) {
            bl = Boolean.TRUE;
        }
        extractListModel.setProperty("IMP_OVERWRIGHT_DATAFILES", (Object)bl);
        bl = Boolean.FALSE;
        if (this._cbSkipIndexes.isSelected()) {
            bl = Boolean.TRUE;
        }
        extractListModel.setProperty("IMP_SKIP_INDEXES", (Object)bl);
    }

    public String getExitTransition() {
        if (this._cbGoToSummary.isSelected()) {
            return "SUMMARY";
        }
        return null;
    }
}

