/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.help.HelpUtils;
import oracle.ide.help.Helpable;
import oracle.ide.layout.ViewId;
import oracle.ide.log.Href;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekHelper;
import oracle.ide.peek.Peekable;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.ide.webbrowser.BrowserRunner;

public class RunLogPage
extends MessagePage
implements Helpable {
    private static final String RUN_LOG_PAGE = "RunLogPage";
    private static final String WLS_ERROR_STRING = HelpUtils.substituteMacros((String)"${WLS_ERROR_TOC_URL}");
    private static final String ORACLE_ERROR_STRING = HelpUtils.substituteMacros((String)"${ORACLE_ERROR_URL_FRAGMENT}");
    private static final char EOL = '\n';
    private static final int TERMINATE_CMD_ID = Ide.findOrCreateCmdID((String)"TERMINATE_CMD_ID");
    private static final int STACK_TRACES_CMD_ID = Ide.findOrCreateCmdID((String)"STACK_TRACES_CMD_ID");
    private static Controller controller;
    private List stackFrames;
    private boolean uiInitialized;
    private JPanel southPanel;
    private JTextField textField;
    private OutputStreamWriter writer;
    private String name;
    private Workspace workspace;
    private Project project;
    private String tooltip;
    private String titleName;
    private HelpInfo helpInfo;
    private volatile boolean runProcessStarted;
    private volatile RunProcess runProcessAlive;
    private volatile RunProcess runProcessPreparing;
    private boolean needNewLine;
    private boolean dontForceOutput;
    private boolean wasClosedByUser;
    private static WeakHashMap<RunLogPage, Object> allPages;
    private Component topComponent;
    private static int systemInColor;
    private static SimpleAttributeSet systemInAttributeSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RunLogPage makePage(RunProcess runProcess, boolean create) {
        WeakHashMap<RunLogPage, Object> weakHashMap = allPages;
        synchronized (weakHashMap) {
            RunLogPage page = null;
            for (RunLogPage p : allPages.keySet()) {
                if (!runProcess.reuseLogPage(p)) continue;
                page = p;
                break;
            }
            if (page != null) {
                page.setStuff(runProcess);
            } else if (create) {
                RunLogPage page1 = new RunLogPage(runProcess, runProcess.getShortLabel(), runProcess.getIcon());
                if (!runProcess.isPreparingLabel) {
                    page = page1;
                    allPages.put(page, null);
                }
            }
            return page;
        }
    }

    protected RunLogPage(RunProcess runProcess, String name, Icon icon) {
        super(new ViewId(RUN_LOG_PAGE, name), icon, false);
        this.name = name;
        this.setStuff(runProcess);
        this.stackFrames = new ArrayList();
        this.dontForceOutput = false;
        LogManager.getLogManager().addPage((LogPage)this);
        if (controller == null) {
            controller = RunLogPage.makeController();
            IdeAction actionTerminate = IdeAction.get((int)TERMINATE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)RunMgrArb.getString((int)10)), null, (Integer)StringUtils.getMnemonicKeyCode((String)RunMgrArb.getString((int)10)), null, null, (boolean)true);
            actionTerminate.addController(controller);
            IdeAction actionStackTraces = IdeAction.get((int)STACK_TRACES_CMD_ID, null, (String)StringUtils.stripMnemonic((String)RunMgrArb.getString((int)12)), null, (Integer)StringUtils.getMnemonicKeyCode((String)RunMgrArb.getString((int)12)), null, null, (boolean)true);
            actionStackTraces.addController(controller);
            LogManager.getLogManager().getContextMenu().addContextMenuListener(RunLogPage.makeContextMenuListener());
        }
    }

    private static Controller makeController() {
        return new Controller(){

            public boolean handleEvent(IdeAction action, Context context) {
                int cmdId = action.getCommandId();
                if (cmdId == TERMINATE_CMD_ID) {
                    RunLogPage runLogPage = (RunLogPage)((Object)action.getValue("UserData"));
                    if (runLogPage != null) {
                        runLogPage.terminate();
                    }
                    action.putValue("UserData", null);
                    return true;
                }
                if (cmdId == STACK_TRACES_CMD_ID) {
                    RunLogPage runLogPage = (RunLogPage)((Object)action.getValue("UserData"));
                    if (runLogPage != null) {
                        runLogPage.showStackTracesDialog();
                    }
                    action.putValue("UserData", null);
                    return true;
                }
                return false;
            }

            public boolean update(IdeAction action, Context context) {
                int cmdId = action.getCommandId();
                if (cmdId == TERMINATE_CMD_ID) {
                    RunLogPage runLogPage = (RunLogPage)((Object)action.getValue("UserData"));
                    if (runLogPage != null) {
                        action.setEnabled(runLogPage.canTerminate());
                    } else {
                        action.setEnabled(false);
                    }
                    return true;
                }
                if (cmdId == STACK_TRACES_CMD_ID) {
                    RunLogPage runLogPage = (RunLogPage)((Object)action.getValue("UserData"));
                    if (runLogPage != null) {
                        action.setEnabled(runLogPage.canShowStackTracesDialog());
                    } else {
                        action.setEnabled(false);
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private static ContextMenuListener makeContextMenuListener() {
        return new ContextMenuListener(){

            public void menuWillShow(ContextMenu popup) {
                View view;
                Context context;
                if (popup != null && (context = popup.getContext()) != null && (view = context.getView()) instanceof RunLogPage) {
                    RunLogPage runLogPage = (RunLogPage)view;
                    IdeAction actionTerminate = IdeAction.find((int)TERMINATE_CMD_ID);
                    actionTerminate.putValue("UserData", (Object)runLogPage);
                    actionTerminate.updateAction(context);
                    JMenuItem menuItemTerminate = popup.createMenuItem((ToggleAction)actionTerminate);
                    popup.add((Component)menuItemTerminate, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
                    IdeAction actionStackTraces = IdeAction.find((int)STACK_TRACES_CMD_ID);
                    actionStackTraces.putValue("UserData", (Object)runLogPage);
                    actionStackTraces.updateAction(context);
                    JMenuItem menuItemStackTraces = popup.createMenuItem((ToggleAction)actionStackTraces);
                    popup.add((Component)menuItemStackTraces, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
                }
            }

            public void menuWillHide(ContextMenu popup) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }
        };
    }

    protected void setStuff(RunProcess runProcess) {
        this.workspace = runProcess.getWorkspace();
        this.project = runProcess.getProject();
        this.tooltip = runProcess.getToolTipText();
        this.titleName = runProcess.getShortLabelWithPrefix();
        this.helpInfo = runProcess.getHelpInfo();
        EnvironOptions _environOptions = Ide.getEnvironOptions();
        if (_environOptions.isSaveLogToFile()) {
            URL preffix = _environOptions.getLogFilePrefix();
            String dirName = preffix == null || preffix.getPath().length() == 0 ? Ide.getWorkDirectory() : URLFileSystem.getPlatformPathName((URL)preffix).trim();
            String fn = this.titleName.trim();
            int index = fn.lastIndexOf(46);
            if (index != -1) {
                fn = fn.substring(0, index);
            }
            File fname = new File(dirName, fn.replaceAll("[^A-Za-z0-9]", "_"));
            this.setLogFileName(fname.getPath());
        }
    }

    public Component getBottomComponent() {
        return this.southPanel;
    }

    public Component getGUI() {
        if (!this.uiInitialized) {
            this.uiInitialized = true;
            this.southPanel = new JPanel(new BorderLayout());
            this.southPanel.setVisible(false);
            JLabel label = new JLabel(RunMgrArb.getString((int)8));
            this.southPanel.add((Component)label, "West");
            this.textField = new JTextField();
            this.textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RunLogPage.this.textField != null && RunLogPage.this.writer != null) {
                        String s = RunLogPage.this.textField.getText() + "\n";
                        RunLogPage.this.textField.setText("");
                        try {
                            StyledMessage styledMessage = new StyledMessage((AttributeSet)RunLogPage.getSystemInAttributeSet(), s);
                            RunLogPage.this.log(styledMessage);
                            RunLogPage.this.writer.write(s);
                            RunLogPage.this.writer.flush();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.southPanel.add((Component)this.textField, "Center");
        }
        return super.getGUI();
    }

    private static synchronized SimpleAttributeSet getSystemInAttributeSet() {
        if (systemInAttributeSet == null) {
            systemInAttributeSet = new SimpleAttributeSet();
        }
        EnvironOptions environOptions = Ide.getEnvironOptions();
        if (systemInColor == 0 || systemInColor != environOptions.getLogSystemInColor()) {
            systemInColor = environOptions.getLogSystemInColor();
            StyleConstants.setForeground(systemInAttributeSet, new Color(systemInColor));
        }
        return systemInAttributeSet;
    }

    protected MessagePage.CustomTextPane createStyledTextPane() {
        return new PeekableTextPane();
    }

    public Context getContext(EventObject event) {
        Workspaces workspaces;
        List list;
        Context context = Context.newIdeContext((View)this, (EventObject)event);
        if (this.workspace != Ide.getDefaultWorkspace() && this.project != Ide.getDefaultProject() && (list = (workspaces = Ide.getWorkspaces()).getListOfChildren()) != null && list.contains(this.workspace)) {
            context.setWorkspace(this.workspace);
            if (this.workspace.containsChild((Element)this.project)) {
                context.setProject(this.project);
            }
        }
        return context;
    }

    public String getName() {
        return this.name;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Project getProject() {
        return this.project;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public String getToolTip() {
        if (this.runProcessStarted && this.runProcessAlive == null) {
            return RunMgrArb.format((int)9, (Object)this.tooltip);
        }
        return this.tooltip;
    }

    public String getTitleName() {
        return this.titleName;
    }

    public HelpInfo getHelpInfo() {
        if (this.helpInfo != null) {
            return this.helpInfo;
        }
        return super.getHelpInfo();
    }

    public boolean isProcessAlive() {
        return this.runProcessAlive != null;
    }

    public RunProcess getRunProcess() {
        if (this.runProcessAlive != null) {
            return this.runProcessAlive;
        }
        if (this.runProcessPreparing != null) {
            return this.runProcessPreparing;
        }
        return null;
    }

    public void log(Object msg) {
        if (msg instanceof String) {
            String s = (String)msg;
            this.needNewLine = s.length() > 0 && !s.endsWith("\n");
        } else if (msg instanceof StringBuffer) {
            String s = msg.toString();
            this.needNewLine = s.length() > 0 && !s.endsWith("\n");
        }
        super.log(msg, !this.dontForceOutput);
    }

    public void logWithoutShow(Object msg) {
        if (msg instanceof String) {
            String s = (String)msg;
            this.needNewLine = !s.endsWith("\n");
        }
        super.logMsg(msg);
    }

    public void setDontForceOutput(boolean dfo) {
        this.dontForceOutput = dfo;
    }

    public boolean getDontForceOutput() {
        return this.dontForceOutput;
    }

    protected void appendToTextComponent(String msg, int maxLogLines) {
        super.appendToTextComponent(msg, maxLogLines);
        this.lookForStackFrames(msg.length());
        this.lookForOracleErrorMessages(msg.length());
    }

    protected void deleteFromStartOfTextComponent(int linesToDelete, int offset) {
        this.removeStackFrames(offset);
        super.deleteFromStartOfTextComponent(linesToDelete, offset);
    }

    protected void clearTextComponent() {
        super.clearTextComponent();
        this.clearStackFrames();
    }

    private void lookForOracleErrorMessages(int appendedLength) {
        block9: {
            HashSet<String> errorPrefixes = new HashSet<String>();
            errorPrefixes.add("ORA");
            errorPrefixes.add("BEA");
            errorPrefixes.add("ADFC");
            try {
                if (appendedLength <= 0) break block9;
                String documentText = this.getText();
                int documentLength = documentText.length();
                try {
                    int index = documentLength - appendedLength;
                    if (index < 0) {
                        index = 0;
                    }
                    String line = documentText.substring(index, documentLength);
                    Pattern errorNumber = Pattern.compile("[A-Z]{3}-\\d{5}");
                    Matcher matcher = errorNumber.matcher(line);
                    index = 0;
                    while (matcher.find(index)) {
                        int endpos;
                        int startpos = matcher.start();
                        while (startpos - 1 > 0 && Character.isLetter(line.codePointAt(startpos - 1))) {
                            --startpos;
                        }
                        for (endpos = matcher.end(); endpos < line.length() && Character.isDigit(line.codePointAt(endpos)); ++endpos) {
                        }
                        String errorCode = new String(line.substring(startpos, endpos));
                        String errorPrefix = errorCode.substring(0, errorCode.indexOf(45));
                        if (!errorPrefixes.contains(errorPrefix)) {
                            index = matcher.end();
                            continue;
                        }
                        URL tmpURL = null;
                        tmpURL = errorCode.indexOf("BEA-") != -1 ? new URL(WLS_ERROR_STRING) : new URL(ORACLE_ERROR_STRING + errorCode);
                        final URL codeURL = tmpURL;
                        SimpleAttributeSet as = new SimpleAttributeSet(Href.getDefaultAttributeSet());
                        StyleConstants.setBold(as, true);
                        Href errorHyperLink = new Href(errorCode, codeURL, as){

                            public void go() {
                                BrowserRunner.getBrowserRunner().runBrowserOnURL(codeURL, null, null);
                            }
                        };
                        errorHyperLink.setStartOffset(documentLength - appendedLength + startpos);
                        errorHyperLink.setEndOffset(documentLength - appendedLength + endpos);
                        this.addHref(errorHyperLink);
                        index = matcher.end();
                    }
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    private void lookForStackFrames(int appendedLength) {
        block9: {
            Debugger debugger = Debugger.getDebugger();
            if (debugger != null) {
                try {
                    if (appendedLength <= 0) break block9;
                    String documentText = this.getText();
                    int documentLength = documentText.length();
                    int bol = documentLength - appendedLength;
                    bol = bol <= 0 ? 0 : this.getBeginningOfLine(documentText, bol);
                    while (bol < documentLength) {
                        int eol = documentText.indexOf(10, bol);
                        if (eol == -1) {
                            eol = documentLength;
                        }
                        try {
                            String line = documentText.substring(bol, eol);
                            if (line.length() > 0 && debugger.isStackTraceLine(line)) {
                                String stackTraceLine = new String(line);
                                int start = this.skipWhitespace(documentText, documentLength, bol);
                                if (documentText.startsWith("at ", start)) {
                                    start += 3;
                                }
                                int lengthOfHRef = documentText.indexOf(40, start) - start;
                                String text = new String(documentText.substring(start, eol));
                                StackFrame stackFrame = new StackFrame(text, stackTraceLine, start, lengthOfHRef, documentText);
                                this.stackFrames.add(stackFrame);
                                super.addHref(stackFrame._href);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        bol = eol + 1;
                    }
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void removeStackFrames(int offset) {
        for (int i = this.stackFrames.size() - 1; i >= 0; --i) {
            StackFrame stackFrame = (StackFrame)this.stackFrames.get(i);
            if (stackFrame._href.getStartOffset() >= offset) continue;
            this.stackFrames.remove(i);
        }
    }

    private void clearStackFrames() {
        this.stackFrames.clear();
    }

    private int getBeginningOfLine(String documentText, int offset) {
        int bol;
        if (offset > 0) {
            --offset;
        }
        bol = (bol = documentText.lastIndexOf(10, offset)) == -1 ? 0 : ++bol;
        return bol;
    }

    private int skipWhitespace(String documentText, int documentLength, int offset) {
        while (offset < documentLength && Character.isWhitespace(documentText.charAt(offset))) {
            ++offset;
        }
        return offset;
    }

    private boolean canTerminate() {
        RunProcess runProcess = this.getRunProcess();
        return runProcess != null && runProcess.canTerminate();
    }

    private void terminate() {
        RunProcess runProcess = this.getRunProcess();
        if (runProcess != null && runProcess.canTerminate()) {
            runProcess.terminate();
        }
    }

    private boolean canShowStackTracesDialog() {
        return !this.stackFrames.isEmpty();
    }

    private void showStackTracesDialog() {
        StackFrame stackFrame;
        StackTracesPanel panel = new StackTracesPanel(this.stackFrames);
        String title = RunMgrArb.getString((int)14);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getFirstComponent(), (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setResizable(true);
        dlg.setOKButtonText(RunMgrArb.getString((int)15));
        dlg.setOKButtonEnabled(panel.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_deb_stacktracesdlg_html");
        if (WizardLauncher.runDialog((JDialog)dlg) && (stackFrame = panel.getSelectedStackFrame()) != null) {
            stackFrame.showStackFrameSourceCode();
        }
    }

    public void showPage() {
        this.requestShow();
    }

    public void setNorthComponent(Component northComponent) {
        this.setTopComponent(northComponent);
    }

    public void setTopComponent(Component topComponent) {
        this.topComponent = topComponent;
    }

    public Component getTopComponent() {
        if (this.topComponent == null) {
            return super.getTopComponent();
        }
        return this.topComponent;
    }

    void logMessageFromRunner(Object msg) {
        if (msg instanceof String && this.needNewLine) {
            msg = "\n" + msg;
        }
        this.logWithoutShow(msg);
    }

    void allowInput(RunProcess runProcess, final OutputStream stdin) {
        runProcess.doUI(new Runnable(){

            @Override
            public void run() {
                if (stdin != null) {
                    RunLogPage.this.writer = new OutputStreamWriter(stdin);
                    RunLogPage.this.southPanel.setVisible(true);
                } else {
                    RunLogPage.this.writer = null;
                    RunLogPage.this.southPanel.setVisible(false);
                }
            }
        });
    }

    boolean preparing(RunProcess runProcess) {
        if (runProcess.getUseContainerLogPage() && runProcess.getContainer() != null) {
            return true;
        }
        if (this.runProcessPreparing != null) {
            return false;
        }
        this.runProcessPreparing = runProcess;
        this.updateToolTipText();
        IdeAction actionTerminate = IdeAction.find((int)TERMINATE_CMD_ID);
        actionTerminate.putValue("UserData", (Object)this);
        actionTerminate.updateAction(null);
        return true;
    }

    boolean finishedPreparing(RunProcess runProcess) {
        if (this.runProcessPreparing == runProcess) {
            this.runProcessPreparing = null;
            this.updateToolTipText();
        }
        return true;
    }

    boolean started(RunProcess runProcess) {
        if (runProcess.getUseContainerLogPage() && runProcess.getContainer() != null) {
            return true;
        }
        if (this.runProcessAlive != null) {
            return false;
        }
        this.runProcessStarted = true;
        this.runProcessAlive = runProcess;
        this.updateToolTipText();
        return true;
    }

    void finished(RunProcess runProcess) {
        if (this.runProcessAlive == runProcess) {
            this.runProcessAlive = null;
            this.updateToolTipText();
            if (this.wasClosedByUser) {
                this.removePage();
            }
        }
    }

    public void show() {
        super.show();
        this.wasClosedByUser = false;
    }

    public void close() {
        super.close();
        if (this.runProcessAlive == null) {
            this.removePage();
        }
        this.wasClosedByUser = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePage() {
        this.clearAll();
        WeakHashMap<RunLogPage, Object> weakHashMap = allPages;
        synchronized (weakHashMap) {
            allPages.remove((Object)this);
        }
    }

    public static URL getURLFromStackTraceLine(String stackTraceLine) {
        try {
            int openParen = stackTraceLine.indexOf(40);
            if (openParen != -1) {
                int closeParen;
                int space = stackTraceLine.lastIndexOf(32, openParen);
                int dot = stackTraceLine.lastIndexOf(46, openParen);
                int colon = stackTraceLine.indexOf(58, openParen);
                if (space != -1 && dot != -1 && colon != -1 && dot > space + 1 && colon > openParen + 1 && (closeParen = stackTraceLine.indexOf(41, colon)) != -1 && closeParen > colon + 1) {
                    String lineNumber = stackTraceLine.substring(colon + 1, closeParen);
                    String filename = stackTraceLine.substring(openParen + 1, colon);
                    if (!filename.startsWith(File.separator)) {
                        return null;
                    }
                    URL url = URLFactory.newFileURL((String)filename);
                    url = URLFactory.replaceRefPart((URL)url, (String)lineNumber);
                    return url;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        allPages = new WeakHashMap();
    }

    private class PeekableTextPane
    extends MessagePage.CustomTextPane
    implements Peekable {
        private PeekableTextPane() {
            super((MessagePage)RunLogPage.this);
        }

        public Peek peek(Point p) {
            CodePeek peek;
            block6: {
                peek = null;
                SwingUtilities.convertPointFromScreen(p, (Component)((Object)this));
                int offset = this.getUI().viewToModel((JTextComponent)((Object)this), p);
                Href href = RunLogPage.this.findHrefByOffset(offset);
                if (href instanceof StackFrameHref) {
                    try {
                        Rectangle rect = this.getUI().modelToView((JTextComponent)((Object)this), href.getStartOffset());
                        rect.add(this.getUI().modelToView((JTextComponent)((Object)this), href.getEndOffset()));
                        String sfLine = ((StackFrameHref)href).getStackTraceLine();
                        URL urlWithLine = null;
                        Debugger debugger = Debugger.getDebugger();
                        if (debugger != null) {
                            urlWithLine = debugger.parseStackTraceLine(RunLogPage.this.workspace, RunLogPage.this.project, sfLine);
                        }
                        if (urlWithLine == null) break block6;
                        int line = 1;
                        try {
                            String ref = urlWithLine.getRef();
                            line = Integer.parseInt(ref);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        URL url = URLFactory.replaceRefPart((URL)urlWithLine, null);
                        int pad = 4;
                        String text = PeekHelper.getPeekText((URL)url, (int)(--line), (int)4);
                        peek = PeekHelper.createCodePeek((JComponent)((Object)this), (String)url.getFile(), (String)text, (String)URLFileSystem.getFileName((URL)url), (Rectangle)rect);
                        line = line < 4 ? line : 4;
                        PeekHelper.addHighlight((CodePeek)peek, (int)line, (String)"caret-line-highlight");
                        peek.showPeek();
                    }
                    catch (BadLocationException e) {
                        peek = null;
                    }
                }
            }
            return peek;
        }
    }

    private class StackFrameHref
    extends Href {
        private String stackTraceLine;

        public StackFrameHref(String hrefText, String stackTraceLine) {
            super(hrefText, null);
            this.stackTraceLine = stackTraceLine;
        }

        public void go() {
            Debugger debugger = Debugger.getDebugger();
            if (debugger != null) {
                URL urlForNonJavaStackTraceLines = RunLogPage.getURLFromStackTraceLine(this.stackTraceLine);
                if (urlForNonJavaStackTraceLines != null) {
                    debugger.showSourceFileForStackTraceLine(RunLogPage.this.workspace, RunLogPage.this.project, urlForNonJavaStackTraceLines);
                } else {
                    debugger.showSourceFileForStackTraceLine(RunLogPage.this.workspace, RunLogPage.this.project, this.stackTraceLine);
                }
            }
        }

        public String getStackTraceLine() {
            return this.stackTraceLine;
        }
    }

    private static final class StackTracesPanel
    extends JPanel
    implements TreeSelectionListener {
        private JEWTDialog dlg;
        private JTree tree;

        StackTracesPanel(List stackFrames) {
            super(new GridBagLayout());
            TreeModel treeModel = this.buildTree(stackFrames);
            this.tree = new JTree(treeModel);
            JScrollPane scrollPane = new JScrollPane(this.tree);
            this.tree.setScrollsOnExpand(false);
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    this.setIcon(null);
                    return this;
                }
            });
            this.tree.addTreeSelectionListener(this);
            this.add((Component)scrollPane, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            final int lastExceptionRow = treeModel.getChildCount(treeModel.getRoot()) - 1;
            this.tree.expandRow(lastExceptionRow);
            final int topFrameRow = lastExceptionRow + 1;
            this.tree.setSelectionRow(topFrameRow);
            this.tree.addComponentListener(new ComponentAdapter(){
                boolean done = false;

                @Override
                public void componentResized(ComponentEvent e) {
                    if (!this.done) {
                        this.done = true;
                        StackTracesPanel.this.tree.scrollRowToVisible(0);
                        StackTracesPanel.this.tree.scrollRowToVisible(lastExceptionRow);
                        StackTracesPanel.this.tree.scrollRowToVisible(topFrameRow);
                        StackTracesPanel.this.tree.removeComponentListener(this);
                    }
                }
            });
        }

        private TreeModel buildTree(List stackFrames) {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
            int lastExceptionID = -1;
            DefaultMutableTreeNode exceptionNode = null;
            int hotLinksSize = stackFrames.size();
            for (int i = 0; i < hotLinksSize; ++i) {
                StackFrame stackFrame = (StackFrame)stackFrames.get(i);
                if (stackFrame._exceptionID != lastExceptionID) {
                    exceptionNode = new DefaultMutableTreeNode(stackFrame._exception);
                    rootNode.add(exceptionNode);
                    exceptionNode.add(new DefaultMutableTreeNode(stackFrame));
                    lastExceptionID = stackFrame._exceptionID;
                    continue;
                }
                exceptionNode.add(new DefaultMutableTreeNode(stackFrame));
            }
            return new DefaultTreeModel(rootNode);
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
        }

        private boolean canOk() {
            return this.getSelectedStackFrame() != null;
        }

        private StackFrame getSelectedStackFrame() {
            DefaultMutableTreeNode node;
            Object o;
            TreePath treePath = this.tree.getSelectionPath();
            if (treePath != null && (o = (node = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof StackFrame) {
                return (StackFrame)o;
            }
            return null;
        }

        private Component getFirstComponent() {
            return this.tree;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.dlg != null) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }
    }

    class StackFrame {
        String _stackTraceLine;
        Href _href;
        String _text;
        String _exception;
        int _exceptionID;

        StackFrame(String text, String stackTraceLine, int startOffset, int lengthOfHRef, String documentText) {
            block7: {
                this._stackTraceLine = stackTraceLine.intern();
                String hrefText = text.substring(0, lengthOfHRef);
                this._href = new StackFrameHref(hrefText, this._stackTraceLine);
                this._href.setStartOffset(startOffset);
                this._text = text;
                try {
                    int i = RunLogPage.this.getBeginningOfLine(documentText, startOffset);
                    while (i > 0 && documentText.startsWith("\tat ", i)) {
                        i = RunLogPage.this.getBeginningOfLine(documentText, i - 1);
                    }
                    int eol = documentText.indexOf(10, i);
                    if (eol == -1) {
                        eol = documentText.length();
                    }
                    this._exception = new String(documentText.substring(i, eol)).intern();
                    this._exceptionID = i;
                    if (!this._exception.trim().equals("]")) break block7;
                    while (i > 0) {
                        if (documentText.startsWith("[SOAPException", i = RunLogPage.this.getBeginningOfLine(documentText, i - 1))) {
                            this._exception = new String(documentText.substring(i, eol)).intern();
                        } else if (!documentText.startsWith("\tat ", i)) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this._text;
        }

        public void showStackFrameSourceCode() {
            Debugger debugger = Debugger.getDebugger();
            if (debugger != null) {
                debugger.showSourceFileForStackTraceLine(RunLogPage.this.workspace, RunLogPage.this.project, this._stackTraceLine);
            }
        }
    }
}

