/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.util.ResourceUtils;

final class StarterFactoryChoiceDialog
extends JPanel {
    private JEWTDialog dlg;
    private JList list;
    private Object targetKey;
    private static Map previouslyChosen = new HashMap();

    static int showStarterFactoryChoiceDialog(Node target, Displayable[] displayables) {
        StarterFactoryChoiceDialog panel = new StarterFactoryChoiceDialog(target, displayables);
        String title = RunMgrArb.getString((int)16);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.list, (String)title);
        panel.setJEWTDialog(dlg);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_run_starttarget_html");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            return panel.ok();
        }
        return -1;
    }

    private StarterFactoryChoiceDialog(Node target, Displayable[] displayables) {
        super(new GridBagLayout());
        Object prev;
        this.targetKey = target.getURL();
        JLabel label = new JLabel();
        String text = RunMgrArb.format((int)17, (Object)target.getShortLabel());
        int columns = 50;
        int rows = text.length() / columns + 1;
        JTextArea textArea = new JTextArea(text, rows, columns);
        textArea.setBackground(label.getBackground());
        textArea.setFont(label.getFont());
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        this.list = new JList<Displayable>(displayables);
        int maxVisible = displayables.length + 1;
        if (this.list.getVisibleRowCount() > maxVisible) {
            this.list.setVisibleRowCount(maxVisible);
        }
        this.list.setSelectionMode(0);
        int index = 0;
        if (!previouslyChosen.isEmpty() && (prev = previouslyChosen.get(this.targetKey)) != null) {
            int size = displayables.length;
            for (int i = 0; i < size; ++i) {
                if (!prev.equals(displayables[i].toString())) continue;
                index = i;
                break;
            }
        }
        this.list.setSelectedIndex(index);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Displayable) {
                    Displayable displayable = (Displayable)value;
                    this.setIcon(displayable.getIcon());
                    this.setToolTipText(displayable.getToolTipText());
                }
                return this;
            }
        });
        ResourceUtils.resLabel((JLabel)label, (Component)this.list, (String)RunMgrArb.getString((int)18));
        JScrollPane scrollPane = new JScrollPane(this.list);
        int y = 0;
        this.add((Component)textArea, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)label, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StarterFactoryChoiceDialog.this.dlg.setOKButtonEnabled(StarterFactoryChoiceDialog.this.canOk());
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
                    StarterFactoryChoiceDialog.this.dlg.hide();
                }
            }
        });
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
        dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        return this.list.getSelectedIndex() != -1;
    }

    private int ok() {
        previouslyChosen.put(this.targetKey, this.list.getSelectedValue().toString());
        return this.list.getSelectedIndex();
    }
}

