/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.RunProcessLifecycleListener;
import oracle.javatools.data.HashStructure;

public final class RunnerHook {
    private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension/runner", "runner-hook");
    private static HashStructureHook hashStructureHook;
    private static Map<String, ToolDescription<RunProcessLifecycleListener>> lifeCycleListeners;
    private static Map<String, ToolDescription<Navigable>> launchNavigables;
    private static Map<String, ToolDescription<Navigable>> toolNavigables;
    private static Map<String, ToolDescription<Navigable>> macroNavigables;
    private static Set<String> _emittedErrors;

    static synchronized void addLifecycleListener(RunProcessLifecycleListener listener) {
        RunnerHook.primeHook();
        RunnerHook.addTool(listener, lifeCycleListeners, Category.LIFE_CYCLE_LISTENER);
    }

    static synchronized void removeLifecycleListener(RunProcessLifecycleListener listener) {
        if (lifeCycleListeners != null) {
            RunnerHook.removeTool(listener, lifeCycleListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<RunProcessLifecycleListener> getLifecycleListeners(Workspace workspace, Project project) {
        Class<RunnerHook> clazz = RunnerHook.class;
        synchronized (RunnerHook.class) {
            RunnerHook.primeHook();
            ArrayList copy = new ArrayList(lifeCycleListeners.values());
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return new ArrayList<RunProcessLifecycleListener>(RunnerHook.getTools(copy, workspace, project));
        }
    }

    static synchronized void addLaunchNavigable(Navigable navigable) {
        RunnerHook.primeHook();
        RunnerHook.addTool(navigable, launchNavigables, Category.LAUNCH_NAVIGABLE);
    }

    static synchronized void removeLaunchNavigable(Navigable navigable) {
        if (launchNavigables != null) {
            RunnerHook.removeTool(navigable, launchNavigables);
        }
    }

    static synchronized void addToolNavigable(Navigable navigable) {
        RunnerHook.primeHook();
        RunnerHook.addTool(navigable, toolNavigables, Category.TOOL_NAVIGABLE);
    }

    static synchronized void removeToolNavigable(Navigable navigable) {
        if (toolNavigables != null) {
            RunnerHook.removeTool(navigable, toolNavigables);
        }
    }

    static List<Navigable> getMacroNavigables(Workspace workspace, Project project) {
        return RunnerHook.getNavigables(workspace, project, macroNavigables);
    }

    static List<Navigable> getLaunchNavigables(Workspace workspace, Project project) {
        return RunnerHook.getNavigables(workspace, project, launchNavigables);
    }

    static List<Navigable> getToolNavigables(Workspace workspace, Project project) {
        return RunnerHook.getNavigables(workspace, project, toolNavigables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Navigable> getNavigables(Workspace workspace, Project project, Map<String, ToolDescription<Navigable>> navigables) {
        Class<RunnerHook> clazz = RunnerHook.class;
        synchronized (RunnerHook.class) {
            RunnerHook.primeHook();
            ArrayList copy = new ArrayList(navigables.values());
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return new ArrayList<Navigable>(RunnerHook.getTools(copy, workspace, project));
        }
    }

    private static void primeLifeCycleListeners() {
        if (lifeCycleListeners == null) {
            lifeCycleListeners = new LinkedHashMap<String, ToolDescription<RunProcessLifecycleListener>>();
        }
    }

    private static void primeLaunchNavigables() {
        if (launchNavigables == null) {
            launchNavigables = new LinkedHashMap<String, ToolDescription<Navigable>>();
        }
    }

    private static void primeToolNavigables() {
        if (toolNavigables == null) {
            toolNavigables = new LinkedHashMap<String, ToolDescription<Navigable>>();
        }
    }

    private static void primeMacroNavigables() {
        if (macroNavigables == null) {
            macroNavigables = new LinkedHashMap<String, ToolDescription<Navigable>>();
        }
    }

    private static <T> void addTool(T tool, Map<String, ToolDescription<T>> knownTools, Category category) {
        if (tool == null) {
            assert (tool != null);
            return;
        }
        ToolDescription desc = new ToolDescription(tool, category, Integer.toString(System.identityHashCode(tool)));
        if (!knownTools.containsKey(desc.getKey())) {
            knownTools.put(desc.getKey(), desc);
        } else {
            RunnerHook.logDuplicateTool(desc.getKey(), category, null);
        }
    }

    private static <T> void removeTool(T tool, Map<String, ToolDescription<T>> knownTools) {
        if (tool == null) {
            assert (tool != null);
            return;
        }
        String key = Integer.toString(System.identityHashCode(tool));
        knownTools.remove(key);
    }

    private static <T> List<T> getTools(List<ToolDescription<T>> copy, Workspace workspace, Project project) {
        ArrayList<T> list = new ArrayList<T>(copy.size());
        for (ToolDescription<T> desc : copy) {
            T tool;
            if (!((ToolDescription)desc).rulesApply(workspace, project) || (tool = desc.getTool()) == null) continue;
            list.add(tool);
        }
        return list;
    }

    private static synchronized void primeHook() {
        if (hashStructureHook == null) {
            RunnerHook.primeLifeCycleListeners();
            RunnerHook.primeLaunchNavigables();
            RunnerHook.primeToolNavigables();
            RunnerHook.primeMacroNavigables();
            hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(HOOK_NAME);
            if (hashStructureHook == null) {
                return;
            }
            hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    this.addItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    this.addItemsFromHook(e.getCombinedHashStructure());
                }

                private void addItemsFromHook(HashStructure hashStructure) {
                    RunnerHook.addToolsFromHook(hashStructure, Category.LIFE_CYCLE_LISTENER);
                    RunnerHook.addToolsFromHook(hashStructure, Category.LAUNCH_NAVIGABLE);
                    RunnerHook.addToolsFromHook(hashStructure, Category.TOOL_NAVIGABLE);
                    RunnerHook.addToolsFromHook(hashStructure, Category.MACRO_NAVIGABLE);
                }
            });
        }
    }

    private static synchronized void addToolsFromHook(HashStructure hashStructure, Category category) {
        List definitions = hashStructure.getAsList(category.toString());
        if (definitions != null && definitions.size() > 0) {
            block6: for (Object definition : definitions) {
                HashStructure defHash = (HashStructure)definition;
                String rule = RunnerHook.getRuleFromHash(defHash, category);
                String className = RunnerHook.getClassNameFromHash(defHash, category);
                String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                if (!RunnerHook.isMissingRule(rule, className, category.name(), extensionId) && !RunnerHook.isValidRule(rule, className, category.name(), extensionId)) continue;
                switch (category) {
                    default: {
                        assert (false);
                        continue block6;
                    }
                    case LIFE_CYCLE_LISTENER: {
                        RunnerHook.addTool(defHash, category, lifeCycleListeners);
                        continue block6;
                    }
                    case LAUNCH_NAVIGABLE: {
                        RunnerHook.addTool(defHash, category, launchNavigables);
                        continue block6;
                    }
                    case TOOL_NAVIGABLE: {
                        RunnerHook.addTool(defHash, category, toolNavigables);
                        continue block6;
                    }
                    case MACRO_NAVIGABLE: 
                }
                RunnerHook.addTool(defHash, category, macroNavigables);
            }
        }
    }

    private static String getClassNameFromHash(HashStructure defHash, Category category) {
        String className = null;
        switch (category) {
            case LAUNCH_NAVIGABLE: 
            case TOOL_NAVIGABLE: 
            case MACRO_NAVIGABLE: {
                className = defHash.getString("parent-panel/traversable-class/#text");
                break;
            }
            case LIFE_CYCLE_LISTENER: {
                className = defHash.getString("class");
            }
        }
        if (className == null && HashStructureHook.getExtensionId((HashStructure)defHash) != null) {
            className = "extension " + HashStructureHook.getExtensionId((HashStructure)defHash);
        }
        return className;
    }

    private static boolean isMissingRule(String rule, String className, String category, String extensionId) {
        if (rule == null || rule.trim().length() == 0) {
            RunnerHook.ruleError("Missing", className, category, extensionId);
            return true;
        }
        return false;
    }

    private static boolean isValidRule(String rule, String className, String category, String extensionId) {
        RuleEngine engine = RuleEngine.getInstance();
        Rule engineRule = engine.getRule(rule);
        HashSet<String> acceptedRules = new HashSet<String>(2);
        acceptedRules.add("project-has-techscope");
        acceptedRules.add("always-enabled");
        acceptedRules.add("project-content-has-contents");
        if (engineRule == null || !engineRule.matchesType(acceptedRules)) {
            RunnerHook.ruleError("Invalid", className, category, extensionId);
            return false;
        }
        return true;
    }

    private static void ruleError(String prefix, String className, String category, String extensionId) {
        RunnerHook.logError(prefix + " rule attribute in " + className + " registration", category, extensionId);
    }

    private static <T> void addTool(HashStructure hashStructure, Category category, Map<String, ToolDescription<T>> tools) {
        String extensionId = HashStructureHook.getExtensionId((HashStructure)hashStructure);
        ToolDescription desc = new ToolDescription(hashStructure, extensionId, category);
        String key = desc.getKey();
        if (tools.containsKey(key)) {
            RunnerHook.logDuplicateTool(key, category, extensionId);
        }
        tools.put(key, desc);
    }

    private static void logDuplicateTool(String className, Category category, String extensionId) {
        RunnerHook.logError("Duplicate Registration: " + className, category.toString(), extensionId);
    }

    private static synchronized void logError(String msg, String category, String extensionId) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" in ");
        buf.append(category);
        if (extensionId != null) {
            buf.append(" in extension ");
            buf.append(extensionId);
        }
        if (_emittedErrors == null) {
            _emittedErrors = new HashSet<String>();
        }
        if (!_emittedErrors.contains(buf.toString())) {
            _emittedErrors.add(buf.toString());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            if (extensionId != null) {
                Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
                ExtensionLogRecord record = new ExtensionLogRecord(Level.SEVERE, buf.toString(), ext, -1);
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
            }
        }
    }

    private static String getRuleFromHash(HashStructure hash, Category category) {
        String rule = null;
        if (hash == null) {
            rule = "always-enabled";
        } else {
            switch (category) {
                case LAUNCH_NAVIGABLE: 
                case TOOL_NAVIGABLE: 
                case MACRO_NAVIGABLE: {
                    rule = hash.getString("parent-panel/rule/#text");
                    break;
                }
                case LIFE_CYCLE_LISTENER: {
                    rule = hash.getString("rule");
                    break;
                }
                default: {
                    rule = "always-enabled";
                }
            }
        }
        return rule;
    }

    private static final class ToolDescription<T> {
        private String extensionId;
        private T tool;
        private HashStructure hash;
        private Category category;
        private String key;

        private ToolDescription(HashStructure hash, String extensionId, Category category) {
            this.hash = hash;
            this.extensionId = extensionId;
            this.category = category;
        }

        private ToolDescription(T tool, Category category, String key) {
            this.tool = tool;
            this.category = category;
            this.key = key;
        }

        public String getKey() {
            if (this.key == null) {
                switch (this.category) {
                    default: {
                        assert (false) : "Unknown category in getKey()";
                        break;
                    }
                    case LIFE_CYCLE_LISTENER: {
                        this.key = ToolDescription.getAttributeValue(this.hash, "class", this.category, this.extensionId);
                        break;
                    }
                    case LAUNCH_NAVIGABLE: 
                    case TOOL_NAVIGABLE: 
                    case MACRO_NAVIGABLE: {
                        this.key = ToolDescription.getAttributeValue(this.hash, "parent-panel", this.category, this.extensionId);
                    }
                }
            }
            return this.key;
        }

        public synchronized T getTool() {
            if (this.tool == null) {
                ClassLoader classLoader = ToolDescription.getClassLoader(this.extensionId);
                switch (this.category) {
                    default: {
                        assert (false) : "Unknown category in getTool()";
                        return null;
                    }
                    case LIFE_CYCLE_LISTENER: {
                        String classValue = ToolDescription.getAttributeValue(this.hash, "class", this.category, this.extensionId);
                        MetaClass metaClass = new MetaClass(classLoader, classValue);
                        try {
                            this.tool = metaClass.newInstance();
                        }
                        catch (Exception ex) {
                            RunnerHook.logError("Failed to create Tool from class " + classValue, this.category.toString(), this.extensionId);
                        }
                        break;
                    }
                    case LAUNCH_NAVIGABLE: 
                    case TOOL_NAVIGABLE: 
                    case MACRO_NAVIGABLE: {
                        Navigable parentPanel = this.getPanel("parent-panel", classLoader);
                        if (parentPanel != null) {
                            List<Navigable> childPanels = this.getChildPanels(classLoader);
                            for (Navigable childPanel : childPanels) {
                                parentPanel.addChildNavigable(childPanel);
                            }
                        }
                        this.tool = parentPanel;
                    }
                }
            }
            return this.tool;
        }

        private List<Navigable> getChildPanels(ClassLoader classLoader) {
            List list = this.hash.getAsList("child-panel");
            ArrayList<Navigable> childPanels = new ArrayList<Navigable>();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    HashStructure childHash;
                    Navigable childPanel;
                    Object object = list.get(i);
                    if (!(object instanceof HashStructure) || (childPanel = this.getNavigable(childHash = (HashStructure)object, classLoader)) == null) continue;
                    childPanels.add(childPanel);
                }
            }
            return childPanels;
        }

        private Navigable getPanel(String name, ClassLoader classLoader) {
            Object object;
            if (this.hash.containsKey(name) && (object = this.hash.getObject(name)) instanceof HashStructure) {
                HashStructure panelHash = (HashStructure)object;
                return this.getNavigable(panelHash, classLoader);
            }
            return null;
        }

        private Navigable getNavigable(HashStructure hash, ClassLoader classLoader) {
            String traversableClass = ToolDescription.getAttributeValue(hash, "traversable-class/#text", this.category, this.extensionId);
            if (traversableClass != null) {
                MetaClass metaClass = new MetaClass(classLoader, traversableClass);
                try {
                    Class clazz = metaClass.toClass();
                    String label = ToolDescription.getAttributeValue(hash, "label/#text", this.category, this.extensionId);
                    return new Navigable(label, clazz);
                }
                catch (Exception ex) {
                    RunnerHook.logError("Failed to create Class for class " + traversableClass, this.category.toString(), this.extensionId);
                }
            }
            return null;
        }

        private static String getAttributeValue(HashStructure hash, String name, Category category, String extensionId) {
            String value = hash.getString(name, null);
            if (value == null || value.trim().length() == 0) {
                RunnerHook.logError("Missing attribute " + name, category.toString(), extensionId);
            }
            return value;
        }

        private static ClassLoader getClassLoader(String extensionId) {
            ClassLoader loader = null;
            if (extensionId != null) {
                loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
            }
            if (loader == null) {
                loader = RunnerHook.class.getClass().getClassLoader();
            }
            return loader;
        }

        private boolean rulesApply(Workspace workspace, Project project) {
            String rule = RunnerHook.getRuleFromHash(this.hash, this.category);
            if (rule != null && rule.trim().length() > 0) {
                RuleEngine engine = RuleEngine.getInstance();
                if (engine.getRule(rule) != null) {
                    Context context = new Context(workspace, project);
                    return engine.evaluateRule(rule, context);
                }
                return false;
            }
            return true;
        }
    }

    private static enum Category {
        LAUNCH_NAVIGABLE{

            public String toString() {
                return "run-configuration-launch-navigable";
            }
        }
        ,
        TOOL_NAVIGABLE{

            public String toString() {
                return "run-configuration-tool-navigable";
            }
        }
        ,
        MACRO_NAVIGABLE{

            public String toString() {
                return "run-configuration-macro-navigable";
            }
        }
        ,
        LIFE_CYCLE_LISTENER{

            public String toString() {
                return "life-cycle-listener";
            }
        };

    }
}

