/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.StarterFactory;
import oracle.ide.runner.StarterFactoryDescription;
import oracle.ide.runner.StarterFactoryProvider;
import oracle.ide.util.Assert;
import oracle.ideimpl.runner.RunnerUtils;
import oracle.ideimpl.runner.StarterFactoryDescriptionImpl;
import oracle.ideimpl.runner.StarterFactoryWrapper;
import oracle.javatools.data.HashStructure;

public class StarterFactoryHook {
    private static final ElementName HOOKNAME = new ElementName("http://xmlns.oracle.com/ide/extension/runner", "starter-factory-hook");
    private HashStructureHook hashStructureHook;
    private static final String starterFactoryElementName = "starter-factory";
    private static final String starterFactoryProviderElementName = "starter-factory-provider";
    private Map<String, StarterFactoryDescription> _starterFactories;
    private static List<StarterFactoryProviderDescription> _starterFactoryProviders;
    private Set<String> _errors;

    public synchronized void registerStarterFactory(Class targetClass, StarterFactory starterFactory) {
        if (targetClass == null || starterFactory == null) {
            assert (targetClass != null && starterFactory != null) : "targetClass and starterFactory cannot be null in registerStarterFactory call";
            return;
        }
        this.primeHook();
        String key = StarterFactoryHook.getStarterFactoryKey(targetClass, starterFactory);
        if (this._starterFactories.containsKey(key)) {
            String targetClassName = targetClass.getName();
            String factoryClassName = starterFactory.getClass().getName();
            this.logDuplicateFactory(targetClassName, factoryClassName);
        } else {
            StarterFactoryDescriptionImpl desc = new StarterFactoryDescriptionImpl(targetClass, starterFactory, key);
            this._starterFactories.put(key, desc);
        }
    }

    public synchronized boolean unRegisterStarterFactory(Class targetClass, StarterFactory starterFactory) {
        if (targetClass == null || starterFactory == null) {
            assert (targetClass != null && starterFactory != null) : "targetClass and starterFactory cannot be null in registerStarterFactory call";
            return false;
        }
        if (this._starterFactories == null) {
            return false;
        }
        String key = StarterFactoryHook.getStarterFactoryKey(targetClass, starterFactory);
        return this._starterFactories.remove(key) != null;
    }

    private static String getStarterFactoryKey(Class targetClass, StarterFactory starterFactory) {
        if (targetClass != null && starterFactory != null) {
            return targetClass.getName() + " " + System.identityHashCode(starterFactory);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public AbstractStarterFactory[] getStarterFactoriesForTarget(Project project, Node targetNode, Class targetClass, boolean exactTargetClass, Class starterFactoryClass) {
        if (targetClass == null && targetNode == null) {
            if ($assertionsDisabled) return new AbstractStarterFactory[0];
            if (targetClass != null) return new AbstractStarterFactory[0];
            if (targetNode != null) return new AbstractStarterFactory[0];
            throw new AssertionError((Object)"targetClass and targetNode cannot both be null in getStarterFactoriesForTarget call");
        }
        if (targetClass == null) {
            targetClass = targetNode.getClass();
        }
        ArrayList<AbstractStarterFactory> list = new ArrayList<AbstractStarterFactory>();
        int x = 0;
        while (x < 10) {
            list.clear();
            this.getStarterFactories(project, targetNode, targetClass, exactTargetClass);
            Class<StarterFactoryHook> clazz = StarterFactoryHook.class;
            // MONITORENTER : oracle.ideimpl.runner.StarterFactoryHook.class
            ArrayList<StarterFactoryDescription> copy = new ArrayList<StarterFactoryDescription>(this._starterFactories.values());
            int factoryCount = this._starterFactories.size();
            // MONITOREXIT : clazz
            for (StarterFactoryDescription desc : copy) {
                StarterFactory tool;
                if (!desc.areRulesSatisfied(project, targetNode) || !desc.isAcceptableTarget(targetClass, exactTargetClass) || !desc.isAcceptableProject(project) || !desc.isAcceptableNode(project, targetNode) || !desc.isAcceptableStarterFactory(starterFactoryClass) || (tool = desc.getStarterFactory()) == null) continue;
                AbstractStarterFactory abstractStarterFactory = tool instanceof AbstractStarterFactory ? (AbstractStarterFactory)tool : new StarterFactoryWrapper(tool);
                list.add(0, abstractStarterFactory);
            }
            clazz = StarterFactoryHook.class;
            // MONITORENTER : oracle.ideimpl.runner.StarterFactoryHook.class
            if (factoryCount == this._starterFactories.size()) {
                // MONITOREXIT : clazz
                return list.toArray(new AbstractStarterFactory[list.size()]);
            }
            // MONITOREXIT : clazz
            ++x;
        }
        return list.toArray(new AbstractStarterFactory[list.size()]);
    }

    public synchronized boolean hasStarterFactoryForTarget(Class targetClass, Class starterFactoryClass) {
        if (targetClass == null) {
            assert (targetClass != null) : "targetClass cannot be null in hasStarterFactoryForTarget call";
            return false;
        }
        this.primeHook();
        for (StarterFactoryDescription starterFactoryDescription : this._starterFactories.values()) {
            if (!starterFactoryDescription.isAcceptableTarget(targetClass, false)) continue;
            if (starterFactoryDescription.hasInitializedStarterFactory()) {
                if (!starterFactoryDescription.isAcceptableStarterFactory(starterFactoryClass)) continue;
                return true;
            }
            return true;
        }
        for (StarterFactoryProviderDescription starterFactoryProviderDescription : _starterFactoryProviders) {
            if (starterFactoryProviderDescription.hasInitializedProvider() || !starterFactoryProviderDescription.isAcceptableTarget(targetClass, false)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean enableRunDebugActions(Context context, Class starterFactoryClass) {
        if (context == null) {
            assert (context != null) : "context cannot be null in enableRunDebugActions call";
            return false;
        }
        Node node = RunProcess.getContextNodeForRun(context);
        if (node == null) {
            return false;
        }
        Project project = context.getProject();
        if (node == project) {
            return true;
        }
        Class<?> targetClass = node.getClass();
        this.primeHook();
        for (StarterFactoryDescription starterFactoryDescription : this._starterFactories.values()) {
            if (!starterFactoryDescription.areRulesSatisfied(project, node) || !starterFactoryDescription.isAcceptableTarget(targetClass, false)) continue;
            if (starterFactoryDescription.hasInitializedStarterFactory()) {
                AbstractStarterFactory abstractStarterFactory;
                StarterFactory starterFactory;
                if (!starterFactoryDescription.isAcceptableStarterFactory(starterFactoryClass) || (starterFactory = starterFactoryDescription.getStarterFactory()) == null || !(abstractStarterFactory = starterFactory instanceof AbstractStarterFactory ? (AbstractStarterFactory)starterFactory : new StarterFactoryWrapper(starterFactory)).enableRunDebugActions(context)) continue;
                return true;
            }
            return true;
        }
        for (StarterFactoryProviderDescription starterFactoryProviderDescription : _starterFactoryProviders) {
            if (starterFactoryProviderDescription.hasInitializedProvider() || !starterFactoryProviderDescription.isAcceptableTarget(targetClass, false)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    public Class[] getClassesWithRegisteredStarterFactory() {
        HashSet<Class> list = new HashSet<Class>();
        int x = 0;
        while (x < 10) {
            list.clear();
            this.getStarterFactories(null, null, null, false);
            Class<StarterFactoryHook> clazz = StarterFactoryHook.class;
            // MONITORENTER : oracle.ideimpl.runner.StarterFactoryHook.class
            ArrayList<StarterFactoryDescription> copy = new ArrayList<StarterFactoryDescription>(this._starterFactories.values());
            int factoryCount = this._starterFactories.size();
            // MONITOREXIT : clazz
            for (StarterFactoryDescription desc : copy) {
                Class targetClass = desc.getTargetClass();
                if (targetClass == null) continue;
                list.add(targetClass);
            }
            clazz = StarterFactoryHook.class;
            // MONITORENTER : oracle.ideimpl.runner.StarterFactoryHook.class
            if (factoryCount == this._starterFactories.size()) {
                // MONITOREXIT : clazz
                return list.toArray(new Class[list.size()]);
            }
            // MONITOREXIT : clazz
            ++x;
        }
        return list.toArray(new Class[list.size()]);
    }

    protected ElementName getHookName() {
        return HOOKNAME;
    }

    protected String getStarterFactoryElementName() {
        return starterFactoryElementName;
    }

    private synchronized void primeHook() {
        if (this.hashStructureHook == null) {
            this._starterFactories = new LinkedHashMap<String, StarterFactoryDescription>();
            _starterFactoryProviders = new ArrayList<StarterFactoryProviderDescription>();
            this.hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(this.getHookName());
            if (this.hashStructureHook == null) {
                return;
            }
            this.hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    StarterFactoryHook.this.addItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    StarterFactoryHook.this.addItemsFromHook(e.getCombinedHashStructure());
                }
            });
        }
    }

    private synchronized void addItemsFromHook(HashStructure hashStructure) {
        Object desc;
        String extensionId;
        HashStructure defHash;
        List definitions = hashStructure.getAsList(this.getStarterFactoryElementName());
        if (definitions != null && definitions.size() > 0) {
            for (Object definition : definitions) {
                defHash = (HashStructure)definition;
                extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                desc = new StarterFactoryDescriptionImpl(defHash, extensionId);
                if (desc.getTargetClassName() == null || desc.getStarterFactoryClassName() == null) continue;
                this._starterFactories.put(desc.getKey(), (StarterFactoryDescription)desc);
            }
        }
        if ((definitions = hashStructure.getAsList(starterFactoryProviderElementName)) != null && definitions.size() > 0) {
            for (Object definition : definitions) {
                defHash = (HashStructure)definition;
                extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                desc = new StarterFactoryProviderDescription(defHash, extensionId);
                if (((StarterFactoryProviderDescription)desc).getTargetClassName() == null || ((StarterFactoryProviderDescription)desc).getProviderClassName() == null) continue;
                _starterFactoryProviders.add((StarterFactoryProviderDescription)desc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void getStarterFactories(Project project, Node targetNode, Class targetClass, boolean exactTargetClass) {
        this.primeHook();
        List<StarterFactoryProvider> providers = this.getStarterFactoryProviders(project, targetNode, targetClass, exactTargetClass);
        Iterator<StarterFactoryProvider> i$ = providers.iterator();
        while (i$.hasNext()) {
            StarterFactoryProvider provider = i$.next();
            List<StarterFactoryDescription> factories = provider.getNewStarterFactories();
            if (factories == null || factories.size() <= 0) continue;
            Class<StarterFactoryHook> clazz = StarterFactoryHook.class;
            // MONITORENTER : oracle.ideimpl.runner.StarterFactoryHook.class
            for (StarterFactoryDescription desc : factories) {
                this._starterFactories.put(desc.getKey(), desc);
            }
            // MONITOREXIT : clazz
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private List<StarterFactoryProvider> getStarterFactoryProviders(Project project, Node targetNode, Class targetClass, boolean exactTargetClass) {
        ArrayList<StarterFactoryProvider> providers = new ArrayList<StarterFactoryProvider>();
        this.primeHook();
        int x = 0;
        while (x < 10) {
            providers.clear();
            Class<StarterFactoryHook> clazz = StarterFactoryHook.class;
            // MONITORENTER : oracle.ideimpl.runner.StarterFactoryHook.class
            ArrayList<StarterFactoryProviderDescription> copy = new ArrayList<StarterFactoryProviderDescription>(_starterFactoryProviders);
            int factoryCount = _starterFactoryProviders.size();
            // MONITOREXIT : clazz
            for (StarterFactoryProviderDescription desc : copy) {
                if (!desc.areRulesSatisfied(project, targetNode) || !desc.isAcceptableTarget(targetClass, exactTargetClass)) continue;
                providers.add(desc.getProvider());
            }
            clazz = StarterFactoryHook.class;
            // MONITORENTER : oracle.ideimpl.runner.StarterFactoryHook.class
            if (factoryCount == _starterFactoryProviders.size()) {
                // MONITOREXIT : clazz
                return providers;
            }
            // MONITOREXIT : clazz
            ++x;
        }
        return providers;
    }

    private void logDuplicateFactory(String targetClassName, String factoryClassName) {
        String errorMsg = "Duplicate registration, target-class: " + targetClassName + ", class: " + factoryClassName;
        this.logError(errorMsg, this.getStarterFactoryElementName(), null);
    }

    private synchronized void logError(String msg, String category, String extensionId) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" in ");
        buf.append(category);
        if (extensionId != null) {
            buf.append(" in extension ");
            buf.append(extensionId);
        }
        if (this._errors == null) {
            this._errors = new HashSet<String>();
        }
        if (!this._errors.contains(buf.toString())) {
            this._errors.add(buf.toString());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            if (extensionId != null) {
                Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
                ExtensionLogRecord record = new ExtensionLogRecord(Level.SEVERE, buf.toString(), ext, -1);
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
            }
        }
    }

    static boolean isInstanceOf(Class derivedClass, String parentName) {
        if (derivedClass == null) {
            return false;
        }
        for (Class clazz = derivedClass; clazz != null; clazz = clazz.getSuperclass()) {
            if (clazz.getName().equals(parentName)) {
                return true;
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces == null) continue;
            for (Class<?> interfaceClazz : interfaces) {
                if (!StarterFactoryHook.isInstanceOf(interfaceClazz, parentName)) continue;
                return true;
            }
        }
        return false;
    }

    private class StarterFactoryProviderDescription {
        private String extensionId;
        private StarterFactoryProvider provider;
        private String providerClassName;
        private String targetClassName;
        private HashStructure hash;

        protected StarterFactoryProviderDescription(HashStructure hash, String extensionId) {
            this.extensionId = extensionId;
            this.hash = hash;
        }

        protected boolean hasInitializedProvider() {
            return this.provider != null;
        }

        protected String getTargetClassName() {
            if (this.targetClassName == null) {
                this.targetClassName = this.getAttributeValue("target-class");
            }
            return this.targetClassName;
        }

        protected String getProviderClassName() {
            if (this.providerClassName == null) {
                this.providerClassName = this.getAttributeValue("class");
            }
            return this.providerClassName;
        }

        protected synchronized StarterFactoryProvider getProvider() {
            if (this.provider == null) {
                ClassLoader classLoader = this.getClassLoader(this.extensionId);
                MetaClass metaClass = new MetaClass(classLoader, this.getProviderClassName());
                try {
                    this.provider = (StarterFactoryProvider)metaClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                    StarterFactoryHook.this.logError("Failed to create Tool from class " + this.getProviderClassName(), StarterFactoryHook.starterFactoryProviderElementName, this.extensionId);
                }
            }
            return this.provider;
        }

        protected boolean areRulesSatisfied(Project project, Node node) {
            return RunnerUtils.areRulesSatisfied(this.getAttributeValue("rule"), project, node);
        }

        private String getAttributeValue(String name) {
            String value = this.hash.getString(name, null);
            if (value == null || value.trim().length() == 0) {
                StarterFactoryHook.this.logError("Missing attribute " + name, StarterFactoryHook.starterFactoryProviderElementName, this.extensionId);
            }
            return value;
        }

        private ClassLoader getClassLoader(String extensionId) {
            ClassLoader loader = null;
            if (extensionId != null) {
                loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
            }
            if (loader == null) {
                loader = StarterFactoryHook.class.getClass().getClassLoader();
            }
            return loader;
        }

        private boolean isAcceptableTarget(Class targetClass, boolean exactTargetClass) {
            String registeredTargetClassName = this.getTargetClassName();
            if (exactTargetClass) {
                return targetClass.getName().equals(registeredTargetClassName);
            }
            return StarterFactoryHook.isInstanceOf(targetClass, registeredTargetClassName);
        }
    }
}

