/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.palette2.AbstractPaletteObjectBuilder;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;
import oracle.javatools.util.ModelUtil;

public class DefaultPaletteSection
extends PaletteSection {
    public static final String SECTION_SECTIONID = "sectiomId";
    private HashMap sectionData = new HashMap();
    private CopyOnWriteArrayList<PaletteItem> paletteItems = new CopyOnWriteArrayList();
    private List<PaletteItem> sortedItems = null;
    private String name;
    private String cachedToString = null;

    @Deprecated
    public DefaultPaletteSection() {
        this((String)null, (String)null);
    }

    @Deprecated
    public DefaultPaletteSection(String name, String sectionId) {
        this(new Builder(name, sectionId));
    }

    private DefaultPaletteSection(Builder builder) {
        this.setName(builder.name);
        this.sectionData.putAll(builder.data);
    }

    @Override
    public synchronized Object getData(Object key) {
        return this.sectionData.get(key);
    }

    protected synchronized void setData(Object key, Object data) {
        this.sectionData.put(key, data);
        if (ModelUtil.areEqual((Object)key, (Object)SECTION_SECTIONID)) {
            this.cachedToString = null;
        }
    }

    public PaletteItem getItem(String itemId) {
        for (PaletteItem item : this.getPaletteItems()) {
            if (!ModelUtil.areEqual((Object)itemId, (Object)item.getItemId())) continue;
            return item;
        }
        return null;
    }

    public synchronized void addItem(PaletteItem item) {
        if (null == item) {
            return;
        }
        if (this.paletteItems.addIfAbsent(item)) {
            this.sortedItems = null;
            this.cachedToString = null;
        }
    }

    public synchronized void removeItem(PaletteItem item) {
        if (null == item) {
            return;
        }
        if (this.paletteItems.remove(item)) {
            this.cachedToString = null;
            if (null != this.sortedItems) {
                this.sortedItems.remove(item);
            }
        }
    }

    protected synchronized void removeAllItems() {
        this.paletteItems.clear();
        this.sortedItems = null;
    }

    @Override
    public synchronized Collection<PaletteItem> getItems() {
        return new ArrayList<PaletteItem>(this.getItemsImpl());
    }

    public List<PaletteItem> getPaletteItems() {
        return Collections.unmodifiableList(this.paletteItems);
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    protected synchronized void setName(String name) {
        this.name = name;
        this.cachedToString = null;
    }

    public synchronized String toString() {
        if (null != this.cachedToString) {
            return this.cachedToString;
        }
        StringBuilder temp = new StringBuilder(String.format("DefaulSection[ name=%s, sectionId=%s ] \n", String.valueOf(this.getName()), String.valueOf(this.getData(SECTION_SECTIONID))));
        Collection<PaletteItem> items = this.getItems();
        for (PaletteItem item : items) {
            temp.append(item);
        }
        this.cachedToString = temp.toString();
        return this.cachedToString;
    }

    @Override
    public boolean equals(Object obj) {
        return String.valueOf(this).equals(String.valueOf(obj));
    }

    @Override
    public int hashCode() {
        return String.valueOf(this).hashCode();
    }

    private Collection<? extends PaletteItem> getItemsImpl() {
        if (null != this.sortedItems) {
            return this.sortedItems;
        }
        this.sortedItems = new ArrayList<PaletteItem>(this.getPaletteItems());
        Collections.sort(this.sortedItems, new Comparator<PaletteItem>(){

            @Override
            public int compare(PaletteItem p1, PaletteItem p2) {
                int result;
                String s2;
                float value1 = 0.0f;
                float value2 = 0.0f;
                String s1 = (String)p1.getData("weight");
                if (s1 != null && s1.length() > 0) {
                    value1 = Float.parseFloat(s1.trim());
                }
                if ((s2 = (String)p2.getData("weight")) != null && s2.length() > 0) {
                    value2 = Float.parseFloat(s2.trim());
                }
                if ((result = Float.compare(value1, value2)) == 0) {
                    result = String.CASE_INSENSITIVE_ORDER.compare(p1.getName(), p2.getName());
                }
                return result;
            }
        });
        return Collections.unmodifiableList(this.sortedItems);
    }

    public static class Builder
    extends AbstractPaletteObjectBuilder<DefaultPaletteSection> {
        private final String name;

        public Builder(String name, String sectionId) {
            this.name = name;
            this.data(DefaultPaletteSection.SECTION_SECTIONID, sectionId);
        }

        @Override
        protected DefaultPaletteSection doBuild() {
            return new DefaultPaletteSection(this);
        }
    }
}

