/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette2;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.palette2.PaletteSection;
import oracle.javatools.util.ModelUtil;

public abstract class PaletteGroup {
    public static final String LIST_LAYOUT = "list";
    public static final String ICON_LAYOUT = "icon";
    public static final String ICON_LAYOUT_WITH_BOTTOM_LABELS = "icon-bottom-label";
    public static final String DEFAULT_LAYOUT = "icon-bottom-label";

    public abstract Collection<PaletteSection> getSections();

    public abstract String getName();

    public abstract String getDescription();

    public abstract Icon getIcon();

    public abstract Object getData(Object var1);

    public abstract boolean isVisible(Context var1);

    public String getLayout() {
        return this.getDefaultLayout();
    }

    public String getDefaultLayout() {
        return "icon-bottom-label";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PaletteGroup)) {
            return false;
        }
        PaletteGroup that = (PaletteGroup)object;
        if (!ModelUtil.areEqual((Object)this.getName(), (Object)that.getName())) {
            return false;
        }
        if (!ModelUtil.areEqual((Object)this.getDescription(), (Object)that.getDescription())) {
            return false;
        }
        return false != ModelUtil.areEqual(new ArrayList<PaletteSection>(this.getSections()), new ArrayList<PaletteSection>(that.getSections()));
    }

    public int hashCode() {
        int PRIME = 37;
        int result = super.hashCode();
        String name = this.getName();
        result = 37 * result + (null == name ? 0 : name.hashCode());
        String description = this.getDescription();
        result = 37 * result + (null == description ? 0 : description.hashCode());
        Collection<PaletteSection> groups = this.getSections();
        result = 37 * result + (null == groups ? 0 : groups.hashCode());
        return result;
    }

    public boolean isEmpty() {
        Collection<PaletteSection> sections = this.getSections();
        if (null == sections || sections.isEmpty()) {
            return true;
        }
        for (PaletteSection section : sections) {
            if (section.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        for (PaletteSection section : this.getSections()) {
            section.dispose();
        }
    }
}

