/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette2;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import oracle.ide.palette2.PaletteGroup;
import oracle.javatools.util.ModelUtil;

public abstract class PalettePage {
    public abstract Collection<PaletteGroup> getGroups();

    public abstract String getName();

    public abstract String getDescription();

    public abstract Icon getIcon();

    public abstract Object getData(Object var1);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PalettePage)) {
            return false;
        }
        PalettePage that = (PalettePage)object;
        if (!ModelUtil.areEqual((Object)this.getName(), (Object)that.getName())) {
            return false;
        }
        if (!ModelUtil.areEqual((Object)this.getDescription(), (Object)that.getDescription())) {
            return false;
        }
        return false != ModelUtil.areEqual(new ArrayList<PaletteGroup>(this.getGroups()), new ArrayList<PaletteGroup>(that.getGroups()));
    }

    public int hashCode() {
        int PRIME = 37;
        int result = super.hashCode();
        String name = this.getName();
        result = 37 * result + (null == name ? 0 : name.hashCode());
        String description = this.getDescription();
        result = 37 * result + (null == description ? 0 : description.hashCode());
        Collection<PaletteGroup> groups = this.getGroups();
        result = 37 * result + (null == groups ? 0 : groups.hashCode());
        return result;
    }

    public boolean isEmpty() {
        Collection<PaletteGroup> myGroups = this.getGroups();
        if (null == myGroups || myGroups.isEmpty()) {
            return true;
        }
        for (PaletteGroup group : myGroups) {
            if (group.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        for (PaletteGroup group : this.getGroups()) {
            group.dispose();
        }
    }
}

