/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.config.IdeSettings;
import oracle.ide.model.Node;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette2.DefaultPaletteGroup;
import oracle.ide.palette2.DefaultPalettePage;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePageContext;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ideimpl.palette2.DeclaredGroup;
import oracle.ideimpl.palette2.DeclaredItem;
import oracle.ideimpl.palette2.DeclaredPage;
import oracle.ideimpl.palette2.DeclaredPageProvider;
import oracle.ideimpl.palette2.DeclaredSection;
import oracle.ideimpl.palette2.PaletteHook;
import oracle.javatools.data.PropertyStorage;

public class DeclaredPages
extends PalettePages {
    private static final String DECLAREDPROVIDER_ID = DeclaredPageProvider.class.getName();
    private static final DefaultPalettePage.ShowForTypeRecord NULL_SHOW_FOR_TYPE_RECORD = new DefaultPalettePage.ShowForTypeRecord(null);
    protected List<PalettePagesListener> palettePagesListeners;
    protected List<PalettePage> palettePages = new ArrayList<PalettePage>();
    private PalettePage _preferredPage;

    public DeclaredPages(Context context) {
        URL url = null;
        Node node = context.getNode();
        if (node != null) {
            url = context.getNode().getURL();
        }
        if (url == null) {
            return;
        }
        String pageType = DeclaredPages.getSuffix(url);
        String[] keys = TechnologyScopeConfiguration.getInstance((PropertyStorage)context.getProject()).getTechnologyScope().getTechnologyKeys();
        int nuScopes = keys != null ? keys.length : 0;
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        PaletteHook hook = (PaletteHook)registry.getHook(PaletteHook.NAME);
        List<DeclaredPage> dclPages = hook.getPages();
        if (dclPages != null) {
            for (DeclaredPage dclPage : dclPages) {
                List<String> technologyScopes = dclPage.getTechnologyScopes();
                if (dclPage.getShowForTypes() != null || dclPage.getType() != null) {
                    DefaultPalettePage.ShowForTypeRecord rec = this._getShowForTypeRecord(dclPage, pageType);
                    if (rec.docType == null) continue;
                    if (nuScopes == 0 || technologyScopes == null) {
                        this.addPage(dclPage, this._isPreferredPage(rec, pageType));
                        continue;
                    }
                    if (!this._checkTechnologyScopes(keys, technologyScopes)) continue;
                    this.addPage(dclPage, this._isPreferredPage(rec, pageType));
                    continue;
                }
                if (nuScopes > 0 && technologyScopes != null) {
                    if (!this._checkTechnologyScopes(keys, technologyScopes)) continue;
                    this.addPage(dclPage, false);
                    continue;
                }
                String pageContext = dclPage.getPageContext();
                if (pageContext == null || pageContext.length() <= 0) continue;
                try {
                    ClassLoader cl = registry.getClassLoader(dclPage.getExtensionId());
                    PalettePageContext dclContext = (PalettePageContext)cl.loadClass(pageContext).newInstance();
                    if (!dclContext.showPage(context)) continue;
                    this.addPage(dclPage, dclContext.isPreferred(context));
                }
                catch (Exception ex) {
                    registry.getLogger().log(Level.SEVERE, "Trying to load/instantiate palette page context", ex);
                }
            }
        }
    }

    @Override
    public Collection<PalettePage> getPages() {
        return Collections.unmodifiableList(this.palettePages);
    }

    @Override
    public PaletteItem getItem(String providerId, String itemId) {
        PaletteItem paletteItem;
        block2: {
            PalettePage palettePage;
            DefaultPalettePage defPage;
            if (providerId == null || providerId.length() == 0 || itemId == null || itemId.length() == 0) {
                return null;
            }
            paletteItem = null;
            if (!providerId.equals(DECLAREDPROVIDER_ID)) break block2;
            Iterator<PalettePage> i$ = this.palettePages.iterator();
            while (i$.hasNext() && (paletteItem = (defPage = (DefaultPalettePage)(palettePage = i$.next())).getItem(itemId)) == null) {
            }
        }
        return paletteItem;
    }

    @Override
    public PalettePage getPreferredPage() {
        return this._preferredPage;
    }

    @Override
    public void addPalettePagesListener(PalettePagesListener listener) {
        if (this.palettePagesListeners == null) {
            this.palettePagesListeners = new ArrayList<PalettePagesListener>();
        }
        if (!this.palettePagesListeners.contains(listener)) {
            this.palettePagesListeners.add(listener);
        }
    }

    @Override
    public void removePalettePagesListener(PalettePagesListener listener) {
        if (this.palettePagesListeners != null) {
            this.palettePagesListeners.remove(listener);
        }
    }

    private void addPage(DeclaredPage dclPage, boolean asPreferredPage) {
        try {
            Collection<DeclaredGroup> groups;
            DefaultPalettePage page = (DefaultPalettePage)new DeclaredPage.PageBuilder(dclPage).build();
            if (asPreferredPage && this._preferredPage == null) {
                this._preferredPage = page;
            }
            if ((groups = dclPage.getGroups()) != null) {
                for (DeclaredGroup dclGroup : groups) {
                    DefaultPaletteGroup dfltGroup = (DefaultPaletteGroup)new DeclaredGroup.GroupBuilder(dclGroup).build();
                    page.addGroup(dfltGroup);
                    Collection<DeclaredSection> sections = dclGroup.getSections();
                    if (sections == null) continue;
                    for (DeclaredSection dclSection : sections) {
                        DefaultPaletteSection dfltSection = (DefaultPaletteSection)new DeclaredSection.SectionBuilder(dclSection).build();
                        dfltGroup.addSection(dfltSection);
                        Collection<DeclaredItem> items = dclSection.getItems();
                        if (items == null) continue;
                        for (DeclaredItem dclItem : items) {
                            dfltSection.addItem((PaletteItem)new DeclaredItem.ItemBuilder(dclItem).providerId(DECLAREDPROVIDER_ID).build());
                        }
                    }
                }
            }
            this.palettePages.add(page);
        }
        catch (Exception e) {
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    static String getSuffix(URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        int period = suffix.lastIndexOf(".");
        if (period != -1) {
            return suffix.substring(period + 1);
        }
        return "";
    }

    static boolean isCorrectNode(String suffix, String type) {
        if (suffix == null || suffix.isEmpty() || type == null || type.isEmpty()) {
            return false;
        }
        IdeSettings ideSettings = Ide.getSettings();
        if (ideSettings == null) {
            return false;
        }
        String nodeType1 = FileTypesRecognizer.getClassNameForExtension((String)type);
        if (nodeType1 == null) {
            return false;
        }
        String nodeType2 = FileTypesRecognizer.getClassNameForExtension((String)suffix);
        return nodeType1.equals(nodeType2);
    }

    private DefaultPalettePage.ShowForTypeRecord _getShowForTypeRecord(DeclaredPage dclPage, String pageType) {
        List<DefaultPalettePage.ShowForTypeRecord> types = dclPage.getShowForTypes();
        if (types == null) {
            types.add(new DefaultPalettePage.ShowForTypeRecord(dclPage.getType()));
        }
        for (DefaultPalettePage.ShowForTypeRecord type : types) {
            if (!DeclaredPages.isCorrectNode(type.docType, pageType)) continue;
            return type;
        }
        return NULL_SHOW_FOR_TYPE_RECORD;
    }

    private boolean _checkTechnologyScopes(String[] keys, List<String> technologyScopes) {
        if (technologyScopes == null) {
            return false;
        }
        List<String> keyList = Arrays.asList(keys);
        for (String scope : technologyScopes) {
            if (!keyList.contains(scope)) continue;
            return true;
        }
        return false;
    }

    private boolean _isPreferredPage(DefaultPalettePage.ShowForTypeRecord rec, String pageType) {
        if (rec.docType.equals(pageType)) {
            return rec.asPreferredPage;
        }
        return false;
    }
}

