/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import oracle.ide.palette2.PaletteItem;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.ideimpl.palette2.PaletteAugmentedSection;

public class SearchSection
extends PaletteAugmentedSection {
    public static final String SECTION_SECTIONID = "sectiomId";
    private HashMap sectionData = new HashMap();
    private List<PaletteAugmentedItem> paletteItems = new ArrayList<PaletteAugmentedItem>();
    private String name;

    public SearchSection() {
    }

    public SearchSection(String name, String sectionId) {
        if (name != null && name.length() > 0) {
            this.setName(name);
        }
        if (sectionId != null && sectionId.length() > 0) {
            this.setData(SECTION_SECTIONID, sectionId);
        }
    }

    @Override
    public boolean usesAugmentedItem() {
        return true;
    }

    @Override
    public Object getData(Object key) {
        Object data = this.sectionData.get(key);
        return data;
    }

    @Override
    protected void setData(Object key, Object data) {
        this.sectionData.put(key, data);
    }

    @Override
    public PaletteItem getItem(String itemId) {
        PaletteItem paletteItem = null;
        for (PaletteAugmentedItem iterItem : this.paletteItems) {
            PaletteItem pItem = iterItem.getPaletteItem();
            String defId = pItem.getItemId();
            if (defId == null || !defId.equals(itemId)) continue;
            paletteItem = pItem;
            break;
        }
        return paletteItem;
    }

    @Override
    public void addItem(PaletteItem item) {
    }

    @Override
    public void insertItem(PaletteItem item, String beforeItemId) {
    }

    @Override
    public void addItem(PaletteItem item, String pageName, String groupName) {
        for (PaletteAugmentedItem iterItem : this.paletteItems) {
            PaletteItem pItem = iterItem.getPaletteItem();
            if (!pItem.equals(item)) continue;
            return;
        }
        PaletteAugmentedItem augItem = new PaletteAugmentedItem(item, pageName, groupName);
        this.paletteItems.add(augItem);
    }

    @Override
    public void insertItem(PaletteItem item, String pageName, String groupName, String beforeItemId) {
    }

    @Override
    public boolean removeItem(PaletteItem item) {
        if (item == null || !(item instanceof PaletteItem)) {
            return false;
        }
        for (PaletteAugmentedItem iterItem : this.paletteItems) {
            PaletteItem pItem = iterItem.getPaletteItem();
            if (!pItem.equals(item)) continue;
            return this.paletteItems.remove(iterItem);
        }
        return false;
    }

    @Override
    protected void removeAllItems() {
        this.paletteItems.clear();
    }

    @Override
    public Collection<PaletteAugmentedItem> getAugmentedItems(boolean reverseOrder) {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                PaletteAugmentedItem a1 = (PaletteAugmentedItem)o1;
                PaletteAugmentedItem a2 = (PaletteAugmentedItem)o2;
                PaletteItem p1 = a1.getPaletteItem();
                PaletteItem p2 = a2.getPaletteItem();
                String s1 = p1.getName();
                String s2 = p2.getName();
                return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
            }
        };
        Collections.sort(this.paletteItems, comparator);
        return Collections.unmodifiableList(this.paletteItems);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SearchSection) {
            return this.equalsImpl((SearchSection)obj);
        }
        return false;
    }

    private boolean equalsImpl(SearchSection section) {
        String thisSectionId = (String)this.getData(SECTION_SECTIONID);
        String pageSectionId = (String)section.getData(SECTION_SECTIONID);
        return this.name.equals(section.getName()) && thisSectionId.equals(pageSectionId);
    }
}

