/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import java.util.Date;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;

public class Status
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String url;
    private String path;
    private NodeKind nodeKind;
    private long revision;
    private long lastChangedRevision;
    private long lastChangedDate;
    private String lastCommitAuthor;
    private Kind textStatus;
    private Kind propStatus;
    private boolean locked;
    private boolean copied;
    private boolean switched;
    private boolean fileExternal;
    private boolean isConflicted;
    private Kind repositoryTextStatus;
    private Kind repositoryPropStatus;
    private Lock localLock;
    private Lock reposLock;
    private long reposLastCmtRevision = -1L;
    private long reposLastCmtDate = 0L;
    private NodeKind reposKind = NodeKind.none;
    private String reposLastCmtAuthor;
    private String changelist;

    public Status(String path, String url, NodeKind nodeKind, long revision, long lastChangedRevision, long lastChangedDate, String lastCommitAuthor, Kind textStatus, Kind propStatus, Kind repositoryTextStatus, Kind repositoryPropStatus, boolean locked, boolean copied, boolean isConflicted, boolean switched, boolean fileExternal, Lock localLock, Lock reposLock, long reposLastCmtRevision, long reposLastCmtDate, NodeKind reposKind, String reposLastCmtAuthor, String changelist) {
        this.path = path;
        this.url = url;
        this.nodeKind = nodeKind != null ? nodeKind : NodeKind.unknown;
        this.revision = revision;
        this.lastChangedRevision = lastChangedRevision;
        this.lastChangedDate = lastChangedDate;
        this.lastCommitAuthor = lastCommitAuthor;
        this.textStatus = textStatus;
        this.propStatus = propStatus;
        this.locked = locked;
        this.copied = copied;
        this.isConflicted = isConflicted;
        this.repositoryTextStatus = repositoryTextStatus;
        this.repositoryPropStatus = repositoryPropStatus;
        this.switched = switched;
        this.fileExternal = fileExternal;
        this.localLock = localLock;
        this.reposLock = reposLock;
        this.reposLastCmtRevision = reposLastCmtRevision;
        this.reposLastCmtDate = reposLastCmtDate;
        this.reposKind = reposKind;
        this.reposLastCmtAuthor = reposLastCmtAuthor;
        this.changelist = changelist;
    }

    public String getPath() {
        return this.path;
    }

    public Revision.Number getRevision() {
        return Revision.createNumber(this.revision);
    }

    public long getRevisionNumber() {
        return this.revision;
    }

    public Date getLastChangedDate() {
        return Status.microsecondsToDate(this.lastChangedDate);
    }

    public long getLastChangedDateMicros() {
        return this.lastChangedDate;
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    public Kind getTextStatus() {
        return this.textStatus;
    }

    public String getTextStatusDescription() {
        return this.textStatus.toString();
    }

    public Kind getPropStatus() {
        return this.propStatus;
    }

    public String getPropStatusDescription() {
        return this.propStatus.toString();
    }

    public Kind getRepositoryTextStatus() {
        return this.repositoryTextStatus;
    }

    public Kind getRepositoryPropStatus() {
        return this.repositoryPropStatus;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public String getUrl() {
        return this.url;
    }

    public Revision.Number getLastChangedRevision() {
        return Revision.createNumber(this.lastChangedRevision);
    }

    public long getLastChangedRevisionNumber() {
        return this.lastChangedRevision;
    }

    public NodeKind getNodeKind() {
        return this.nodeKind;
    }

    public boolean isSwitched() {
        return this.switched;
    }

    public boolean isFileExternal() {
        return this.fileExternal;
    }

    public boolean isManaged() {
        Kind status = this.getTextStatus();
        return status != Kind.unversioned && status != Kind.none && status != Kind.ignored;
    }

    public boolean hasRemote() {
        return this.isManaged() && this.getTextStatus() != Kind.added;
    }

    public boolean isAdded() {
        return this.getTextStatus() == Kind.added;
    }

    public boolean isDeleted() {
        return this.getTextStatus() == Kind.deleted;
    }

    public boolean isMerged() {
        return this.getTextStatus() == Kind.merged;
    }

    public boolean isIgnored() {
        return this.getTextStatus() == Kind.ignored;
    }

    public boolean isModified() {
        return this.getTextStatus() == Kind.modified;
    }

    public Lock getLocalLock() {
        return this.localLock;
    }

    public Lock getReposLock() {
        return this.reposLock;
    }

    public Revision.Number getReposLastCmtRevision() {
        return Revision.createNumber(this.reposLastCmtRevision);
    }

    public long getReposLastCmtRevisionNumber() {
        return this.reposLastCmtRevision;
    }

    public Date getReposLastCmtDate() {
        return Status.microsecondsToDate(this.reposLastCmtDate);
    }

    public long getReposLastCmtDateMicros() {
        return this.reposLastCmtDate;
    }

    public NodeKind getReposKind() {
        return this.reposKind;
    }

    public String getReposLastCmtAuthor() {
        return this.reposLastCmtAuthor;
    }

    public String getChangelist() {
        return this.changelist;
    }

    public boolean isConflicted() {
        return this.isConflicted;
    }

    private static Date microsecondsToDate(long micros) {
        return micros == 0L ? null : new Date(micros / 1000L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        none("non-svn"),
        unversioned("unversioned"),
        normal("normal"),
        added("added"),
        missing("missing"),
        deleted("deleted"),
        replaced("replaced"),
        modified("modified"),
        merged("merged"),
        conflicted("conflicted"),
        ignored("ignored"),
        obstructed("obstructed"),
        external("external"),
        incomplete("incomplete");

        private String description;

        private Kind(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

