/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.Workspace;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.PropertyStorage;

public class Scope {
    private Workspace workspace;
    private WorkingSet workingSet;
    private Project project;
    private URL url;

    public Scope(Workspace workspace) {
        this(workspace, null);
    }

    public Scope(Workspace workspace, WorkingSet workingSet) {
        if (workspace == null) {
            throw new IllegalArgumentException("null workspace");
        }
        this.workspace = workspace;
        this.workingSet = workingSet;
    }

    public Scope(Project project) {
        this(project, null);
    }

    public Scope(Project project, URL url) {
        if (project == null) {
            throw new IllegalArgumentException("null project");
        }
        this.project = project;
        this.url = url;
    }

    public Collection<Project> getProjects() {
        if (this.workspace != null) {
            if (this.workingSet != null) {
                Collection projects = this.workspace.projects();
                ArrayList<Project> filtered = new ArrayList<Project>();
                for (Project project : projects) {
                    if (!this.workingSet.isIncluded(project)) continue;
                    filtered.add(project);
                }
                return Collections.unmodifiableCollection(filtered);
            }
            return this.workspace.projects();
        }
        return Collections.singleton(this.project);
    }

    public boolean isIncluded(Project project, URL url) {
        if (this.url != null) {
            return this.url.equals(url);
        }
        return this.isIncluded(project, ProjectContent.getInstance((PropertyStorage)project).getAllContents(), url);
    }

    public boolean isIncluded(Project project, ContentSet content, URL url) {
        if (this.url != null) {
            return this.url.equals(url);
        }
        if (this.workingSet != null) {
            return this.isIncluded(project, content.toRelativePath(url));
        }
        return this.getProjects().contains(project);
    }

    private boolean isIncluded(Project project, String relativePath) {
        if (this.workingSet != null) {
            PatternFilters patternFilters = this.workingSet.getPatternFilters(project);
            return patternFilters == null || patternFilters.isIncluded(relativePath);
        }
        return true;
    }
}

