/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency.index;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.ProgressIndicator;
import oracle.ide.dependency.Reference;
import oracle.ide.dependency.ReferenceProvider;
import oracle.ide.dependency.Scope;
import oracle.ide.dependency.index.IndexReference;
import oracle.ide.index.DataCollector;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.dependency.index.DependencyCollector;
import oracle.ideimpl.index.IndexingContextImpl;

public abstract class IndexReferenceProvider
implements ReferenceProvider {
    protected abstract Collection<QueryCriteria> getReferenceCriteria(Context var1, Declaration var2);

    protected ContentSet getContentSet(Context context, Project project, Declaration declaration) {
        return null;
    }

    @Override
    public boolean canGetReference(Context context) {
        return false;
    }

    @Override
    public Reference getReference(Context context) {
        return null;
    }

    @Override
    public boolean canGetReferences(Context context, Node node) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Collection<? extends Reference> getReferences(Context context, Node node) throws InterruptedException {
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        if (workspace != null && project != null) {
            Index index = IndexManager.getIndexManager().getIndex(workspace, project);
            index.lock();
            DependencyCollector dc = new DependencyCollector();
            IndexingContextImpl ic = new IndexingContextImpl(workspace, project);
            ic.setFilterKey((Object)"dependency.reference");
            ic.startIndexing();
            try {
                ic.index(node.getURL(), -1L, (DataCollector)dc);
            }
            finally {
                ic.endIndexing();
            }
            Collection<IndexReference> collection = Collections.unmodifiableCollection(dc.getReferences());
            index.unlock();
            index.release();
            return collection;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            index.unlock();
                            throw throwable;
                        }
                        catch (LockFailedException e) {
                            DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to get references for " + URLFileSystem.getPlatformPathName((URL)node.getURL()), e);
                            index.release();
                        }
                    }
                    catch (Throwable throwable2) {
                        index.release();
                        throw throwable2;
                    }
                }
            }
        }
        return Collections.emptySet();
    }

    @Override
    public boolean canFindReferences(Context context, Scope scope, Declaration declaration) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends Reference> findReferences(Context context, Scope scope, Declaration declaration, ProgressIndicator progress) throws InterruptedException {
        ArrayList<IndexReference> references = new ArrayList<IndexReference>();
        Workspace workspace = context.getWorkspace();
        if (workspace != null) {
            for (Project project : scope.getProjects()) {
                ContentSet content = this.getContentSet(context, project, declaration);
                Index index = content == null ? IndexManager.getIndexManager().getIndex(workspace, project) : IndexManager.getIndexManager().getIndex(workspace, project, content);
                try {
                    index.lock();
                    try {
                        for (QueryCriteria criteria : this.getReferenceCriteria(context, declaration)) {
                            URL[] urls;
                            for (URL url : urls = this.get(index, progress, criteria)) {
                                if (!scope.isIncluded(project, content, url)) continue;
                                DependencyCollector dc = new DependencyCollector();
                                IndexingContextImpl ic = new IndexingContextImpl(workspace, project);
                                ic.setFilterKey((Object)"dependency.reference");
                                ic.startIndexing();
                                try {
                                    ic.index(url, -1L, (DataCollector)dc);
                                }
                                finally {
                                    ic.endIndexing();
                                }
                                Collection<IndexReference> urlReferences = dc.getReferences();
                                Iterator<IndexReference> iterator = urlReferences.iterator();
                                while (iterator.hasNext()) {
                                    IndexReference reference = iterator.next();
                                    if (this.verify(context, reference, declaration)) continue;
                                    iterator.remove();
                                }
                                references.addAll(urlReferences);
                            }
                        }
                    }
                    finally {
                        index.unlock();
                    }
                }
                catch (LockFailedException e) {
                    DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to find references", e);
                }
                finally {
                    index.release();
                }
            }
        }
        return Collections.unmodifiableCollection(references);
    }

    protected boolean verify(Context context, IndexReference reference, Declaration declaration) throws InterruptedException {
        return reference.isReferenceTo(context, declaration);
    }

    private URL[] get(Index index, ProgressIndicator progressIndicator, QueryCriteria criteria) throws InterruptedException {
        URL[] results = null;
        try {
            BackgroundTask query = index.query(criteria);
            while (!progressIndicator.isCanceled()) {
                if (progressIndicator != null) {
                    progressIndicator.setProgressText(query.getProgressText());
                    progressIndicator.setProgress(query.getProgress());
                }
                try {
                    results = (URL[])query.get(200L, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (InterruptedException e) {
                    query.cancel();
                    throw e;
                }
                catch (CancellationException ce) {
                    break;
                }
                catch (TimeoutException te) {
                }
            }
            if (progressIndicator.isCanceled()) {
                query.cancel();
            }
        }
        catch (ExecutionException e) {
            DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to find references", e);
        }
        catch (RejectedExecutionException e) {
            // empty catch block
        }
        return results == null ? new URL[]{} : results;
    }
}

