/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.clipboard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.resource.DialogsBundle;
import oracle.javatools.util.SwingUtils;

public class ClipboardStackDialog {
    private JList _bufferList;
    private JTextArea _contentTextArea;
    private DefaultListModel _model;
    private DismissableJEWTDialog _dialog;

    public ClipboardStack.Entry runDialog() {
        int selectedIndex;
        boolean b;
        ClipboardStack.Entry ret = null;
        JLabel headerLabel = new JLabel();
        this.createModel();
        this._bufferList = new JList(this._model){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setTransferHandler(new ListTransferHandler());
            }
        };
        this._bufferList.getSelectionModel().setSelectionMode(0);
        this.resLabel(headerLabel, this._bufferList, DialogsBundle.getBundle().getString("CS_BUFFERS"));
        this._bufferList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean okEnabled = false;
                int selectedIndex = ClipboardStackDialog.this._bufferList.getSelectedIndex();
                if (selectedIndex != -1) {
                    ClipboardStack.Entry selectedElement = (ClipboardStack.Entry)ClipboardStackDialog.this._model.getElementAt(selectedIndex);
                    Transferable tt = selectedElement.getTransferable();
                    String value = "";
                    try {
                        value = (String)tt.getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    ClipboardStackDialog.this._contentTextArea.setText(value);
                    ClipboardStackDialog.this._contentTextArea.setCaretPosition(0);
                    okEnabled = true;
                }
                ClipboardStackDialog.this._dialog.setOKButtonEnabled(okEnabled);
            }
        });
        this._bufferList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ClipboardStackDialog.this._dialog.dismiss();
                }
            }
        });
        this._bufferList.setCellRenderer(new BufferListRenderer());
        JLabel detailLabel = new JLabel();
        this._contentTextArea = new JTextArea();
        this._contentTextArea.setEditable(false);
        JScrollPane contentScrollPane = new JScrollPane(this._contentTextArea);
        this.resLabel(detailLabel, this._contentTextArea, DialogsBundle.getBundle().getString("CS_CONTENT"));
        JPanel panel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)headerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        panel.add((Component)new JScrollPane(this._bufferList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        panel.add((Component)detailLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        panel.add((Component)contentScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        panel.setPreferredSize(new Dimension(400, 300));
        HelpUtils.setHelpID((JComponent)panel, (String)"f1_extended_paste_html");
        this._dialog = new DismissableJEWTDialog();
        this._dialog.setContent(panel);
        this._dialog.setResizable(true);
        if (this._model.size() > 0) {
            this._bufferList.setSelectedIndex(0);
        }
        if ((b = this.doInvoke(new JEWTDialogInvoker(){

            @Override
            public boolean doIt() {
                return ClipboardStackDialog.this._dialog.runDialog();
            }
        })) && (selectedIndex = this._bufferList.getSelectedIndex()) != -1) {
            ClipboardStack.Entry selectedElement;
            ret = selectedElement = (ClipboardStack.Entry)this._model.getElementAt(selectedIndex);
        }
        return ret;
    }

    private void resLabel(JLabel label, Component labelFor, String labelText) {
        label.setText(StringUtils.stripMnemonic((String)labelText));
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)labelText));
        label.setLabelFor(labelFor);
    }

    private boolean doInvoke(JEWTDialogInvoker invoker) {
        if (EventQueue.isDispatchThread()) {
            invoker.run();
        } else {
            try {
                EventQueue.invokeAndWait(invoker);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return invoker.getResponse();
    }

    private void createModel() {
        this._model = new DefaultListModel();
        for (ClipboardStack.Entry entry : ClipboardStack.getContent()) {
            this._model.addElement(entry);
        }
    }

    private class ListTransferHandler
    extends TransferHandler {
        private ListTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            ClipboardStack.Entry entry = (ClipboardStack.Entry)ClipboardStackDialog.this._bufferList.getSelectedValue();
            if (entry == null) {
                return null;
            }
            return entry.getTransferable();
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private class BufferListRenderer
    extends DefaultListCellRenderer {
        private Font _italicFont;
        private Font _normalFont;

        private BufferListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this._normalFont == null) {
                this._normalFont = label.getFont();
                this._italicFont = this._normalFont.deriveFont(2);
            }
            if (value instanceof ClipboardStack.Entry) {
                ClipboardStack.Entry entry = (ClipboardStack.Entry)value;
                if (entry.getName().trim().length() == 0) {
                    label.setFont(this._italicFont);
                    label.setText(DialogsBundle.getBundle().getString("CS_WHITESPACE"));
                } else {
                    label.setFont(this._normalFont);
                    label.setText(entry.getName());
                }
            }
            return label;
        }
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog {
        public DismissableJEWTDialog() {
            super(SwingUtils.getMainWindow(), DialogsBundle.getBundle().getString("CS_PASTE"), 7);
        }

        private void dismiss() {
            this.dismissDialog(false);
        }
    }

    private abstract class JEWTDialogInvoker
    implements Runnable {
        private boolean m_response;

        private JEWTDialogInvoker() {
        }

        @Override
        public void run() {
            this.m_response = this.doIt();
        }

        public boolean getResponse() {
            return this.m_response;
        }

        public abstract boolean doIt();
    }
}

