/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.io.File;
import javax.swing.UIManager;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.controls.completionfield.FileSystemFieldInsightProvider;

public class FileField
extends CompletionTextField {
    private final FileSystemFieldInsightProvider m_provider;
    private boolean _validateExistingFile = false;

    public FileField() {
        this(false);
    }

    public FileField(boolean onlyDirectories) {
        this.getPopupHandler().setAlignWithField(true);
        this.getPopupHandler().setCompletionBackground(UIManager.getColor("TextField.background"));
        this.m_provider = new FileSystemFieldInsightProvider();
        this.m_provider.setOnlyDirectories(onlyDirectories);
        this.getPopupHandler().registerInsightProvider(this.m_provider);
    }

    public final void setValidateExistingFile(boolean validateExistingFile) {
        this._validateExistingFile = validateExistingFile;
    }

    public final boolean isValidateExistingFile() {
        return this._validateExistingFile;
    }

    public void setOnlyDirectories(boolean onlyDirectories) {
        this.m_provider.setOnlyDirectories(onlyDirectories);
    }

    public final boolean isOnlyDirectories() {
        return this.m_provider.isOnlyDirectories();
    }

    public FieldInsightProvider getInsightProvider() {
        return this.m_provider;
    }

    @Override
    protected boolean isTextValid() {
        if (!this.isValidateExistingFile()) {
            return true;
        }
        return this.isOnlyDirectories() ? new File(this.getText().trim()).isDirectory() : new File(this.getText().trim()).exists();
    }
}

