/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public final class JMenuSorter {
    private static final Adapter ADAPTER = new Adapter();

    private JMenuSorter() {
    }

    public static boolean isSorted(JMenu menu) {
        MenuListener[] menuListeners;
        if (menu != null && (menuListeners = menu.getMenuListeners()) != null) {
            for (int i = 0; i < menuListeners.length; ++i) {
                if (menuListeners[i] != ADAPTER) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerJMenu(JMenu menu) {
        menu.addMenuListener(ADAPTER);
        menu.getPopupMenu().addContainerListener(ADAPTER);
    }

    public static void unregisterJMenu(JMenu menu) {
        menu.removeMenuListener(ADAPTER);
        menu.getPopupMenu().removeContainerListener(ADAPTER);
    }

    public static void registerExclusionGroup(JMenu menu, Component component) {
        ADAPTER.addExclusion(menu, component);
    }

    public static void unregisterExclusionGroup(JMenu menu, Component component) {
        ADAPTER.removeExclusion(menu, component);
    }

    private static final class Adapter
    implements ContainerListener,
    MenuListener,
    Comparator {
        private static final String MENU_SORTED_PROPERTY = "menuSorted";
        private static final boolean SORT_SUBMENUS_BEFORE_ITEMS = false;
        private final Map exclusionMap = new HashMap();

        private Adapter() {
        }

        public void addExclusion(JMenu menu, Component c) {
            HashSet<Component> exclusions = (HashSet<Component>)this.exclusionMap.get(menu);
            if (exclusions == null) {
                exclusions = new HashSet<Component>();
                this.exclusionMap.put(menu, exclusions);
            }
            exclusions.add(c);
        }

        public void removeExclusion(JMenu menu, Component c) {
            Set exclusions = (Set)this.exclusionMap.get(menu);
            if (exclusions == null || !exclusions.remove(c)) {
                throw new IllegalArgumentException("No such registered menu sorting exclusion");
            }
            if (exclusions.isEmpty()) {
                this.exclusionMap.remove(menu);
            }
        }

        @Override
        public void componentAdded(ContainerEvent event) {
            JPopupMenu jPopupMenu = (JPopupMenu)event.getSource();
            JMenu menu = (JMenu)jPopupMenu.getInvoker();
            menu.putClientProperty(MENU_SORTED_PROPERTY, null);
        }

        @Override
        public void componentRemoved(ContainerEvent event) {
        }

        @Override
        public void menuSelected(MenuEvent event) {
            JMenu menu = (JMenu)event.getSource();
            if (!Boolean.TRUE.equals(menu.getClientProperty(MENU_SORTED_PROPERTY))) {
                this.sortMenuGroups(menu);
                menu.putClientProperty(MENU_SORTED_PROPERTY, Boolean.TRUE);
            }
        }

        @Override
        public void menuCanceled(MenuEvent event) {
        }

        @Override
        public void menuDeselected(MenuEvent event) {
        }

        public int compare(Object o1, Object o2) {
            Component comp1 = (Component)o1;
            Component comp2 = (Component)o2;
            Comparable c1 = this.getComparable(comp1);
            Comparable c2 = this.getComparable(comp2);
            return c1.compareTo(c2);
        }

        private void sortMenuGroups(JMenu menu) {
            Component[] components = menu.getMenuComponents();
            if (components.length < 2) {
                return;
            }
            menu.removeAll();
            ArrayList<Component> group = new ArrayList<Component>();
            for (int i = 0; i < components.length; ++i) {
                boolean isLastItem;
                Component component = components[i];
                boolean isSeparator = component instanceof JSeparator;
                boolean bl = isLastItem = i == components.length - 1;
                if (!isSeparator || isLastItem) {
                    group.add(component);
                }
                if (isSeparator || isLastItem) {
                    if (group.size() > 1 && !this.isExcluded(menu, group)) {
                        Collections.sort(group, this);
                    }
                    Iterator it = group.iterator();
                    while (it.hasNext()) {
                        menu.add((Component)it.next());
                    }
                    group.clear();
                }
                if (!isSeparator) continue;
                menu.add(component);
            }
        }

        private boolean isExcluded(JMenu menu, Collection c) {
            Set exclusions = (Set)this.exclusionMap.get(menu);
            if (exclusions != null) {
                for (Object next : c) {
                    if (!exclusions.contains(next)) continue;
                    return true;
                }
            }
            return false;
        }

        private Comparable getComparable(Component c) {
            if (c instanceof AbstractButton) {
                return ((AbstractButton)c).getText();
            }
            return "";
        }

        private boolean isSubMenu(Component c) {
            return c instanceof JMenu && !((JMenu)c).isTopLevelMenu();
        }
    }
}

