/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.javatools.resource.DialogsBundle;

public class DetailDialog
extends JEWTDialog {
    private JPanel m_subPanel;
    private Component m_realContent;
    private Component m_detailContent;
    private ButtonBar m_detailButtonBar;
    private String m_detailsHiddenButtonText = null;
    private String m_detailsShownButtonText = null;
    private int m_buttonAlignment = 4;
    private static final GridBagConstraints TOP_CONSTRAINTS = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0);
    private static final GridBagConstraints MIDDLE_CONSTRAINTS = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0);
    private static final GridBagConstraints BOTTOM_CONSTRAINTS = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
    private JButton m_detailsButton = new JButton();
    private JLabel m_detailsStatusLabel = null;
    private JPanel m_detailsManagementPanel;
    private boolean m_detailsVisible = false;
    public static final int BUTTON_DETAILS = 16;

    private static void resButton(AbstractButton button, String resKey) {
        String labelText = ResourceBundle.getBundle(DialogsBundle.class.getName()).getString(resKey);
        DetailDialog.resButtonCustomText(button, labelText);
    }

    private static void resButtonCustomText(AbstractButton button, String buttonText) {
        button.setText(StringUtils.stripMnemonic((String)buttonText));
        button.setMnemonic(StringUtils.getMnemonicKeyCode((String)buttonText));
    }

    public DetailDialog(Dialog owner, String title, int buttonMask) {
        super(owner, title, DetailDialog.adjustButtonMask(buttonMask));
        DetailDialog.resButton(this.m_detailsButton, "DD_DETAILS_COLLAPSED");
        this.initializeButton(buttonMask);
    }

    public DetailDialog(Frame owner, String title, int buttonMask) {
        super(owner, title, DetailDialog.adjustButtonMask(buttonMask));
        DetailDialog.resButton(this.m_detailsButton, "DD_DETAILS_COLLAPSED");
        this.initializeButton(buttonMask);
    }

    public void setContent(Component c) {
        if (this.m_realContent != null) {
            this.m_subPanel.remove(this.m_realContent);
        }
        this.m_realContent = c;
        if (this.m_realContent != null) {
            this.m_subPanel.add(this.m_realContent, TOP_CONSTRAINTS);
            String helpTopicId = HelpUtils.getHelpID((Component)this.m_realContent);
            if (helpTopicId != null) {
                this.setHelpTopicId(helpTopicId);
            }
            this.m_subPanel.invalidate();
            this.m_subPanel.validate();
            super.setContent((Component)this.m_subPanel);
        } else {
            super.setContent(null);
        }
    }

    private void initializeButton(int buttonMask) {
        if ((buttonMask & 0x10) != 0) {
            this.m_detailButtonBar.add((Component)this.m_detailsButton);
            this.m_detailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DetailDialog.this.setDetailVisible(!DetailDialog.this.m_detailsVisible);
                }
            });
            this.m_detailsButton.setName("details");
        } else {
            this.m_detailsVisible = true;
        }
    }

    public boolean hasVisibleDetails() {
        return this.m_detailContent != null && this.m_detailsVisible;
    }

    public void setDetailsStatusLabel(JLabel statusLabel) {
        if (this.m_detailsStatusLabel != null) {
            this.m_detailsManagementPanel.remove(this.m_detailsStatusLabel);
        }
        if (statusLabel != null) {
            this.m_detailsStatusLabel = statusLabel;
            this.m_detailsManagementPanel.add(this.m_detailsStatusLabel);
        }
        this.m_detailsManagementPanel.repaint();
    }

    public void setButtonTextWhenDetailsHidden(String textWhenDetailsHidden, boolean showByDefault) {
        this.m_detailsHiddenButtonText = textWhenDetailsHidden;
        if (showByDefault) {
            DetailDialog.resButtonCustomText(this.m_detailsButton, textWhenDetailsHidden);
        }
    }

    public void setButtonTextWhenDetailsShown(String textWhenDetailsShown, boolean showByDefault) {
        this.m_detailsShownButtonText = textWhenDetailsShown;
        if (showByDefault) {
            DetailDialog.resButtonCustomText(this.m_detailsButton, textWhenDetailsShown);
        }
    }

    public void setDetailsButtonEnabled(boolean enabled) {
        this.m_detailsButton.setEnabled(enabled);
    }

    private static int adjustButtonMask(int originalMask) {
        if ((originalMask & 0x10) != 0) {
            return originalMask - 16;
        }
        return originalMask;
    }

    public static DetailDialog createDetailDialog(Component owner, String title, int buttonMask) {
        DetailDialog d = null;
        while (owner != null) {
            if (owner instanceof Dialog) {
                d = new DetailDialog((Dialog)owner, title, buttonMask);
                break;
            }
            if (owner instanceof Frame) {
                d = new DetailDialog((Frame)owner, title, buttonMask);
                break;
            }
            owner = SwingUtilities.getWindowAncestor(owner);
        }
        if (d == null) {
            d = new DetailDialog((Frame)null, title, buttonMask);
        }
        return d;
    }

    protected void dialogInit() {
        super.dialogInit();
        this.m_subPanel = new JPanel();
        this.m_subPanel.setLayout(new GridBagLayout());
        this.m_detailsManagementPanel = new JPanel(new FlowLayout(0));
        this.m_detailButtonBar = new ButtonBar();
        this.m_detailButtonBar.setAlignment(this.m_buttonAlignment);
        this.m_detailsManagementPanel.add((Component)this.m_detailButtonBar);
        if (this.m_detailsStatusLabel != null) {
            this.m_detailsManagementPanel.add(this.m_detailsStatusLabel);
        }
        this.m_subPanel.add((Component)this.m_detailsManagementPanel, MIDDLE_CONSTRAINTS);
    }

    public void setButtonAlignment(int buttonAlignment) {
        Assert.check((buttonAlignment == 2 || buttonAlignment == 4 || buttonAlignment == 0 ? 1 : 0) != 0);
        this.m_buttonAlignment = buttonAlignment;
        this.m_detailButtonBar.setAlignment(this.m_buttonAlignment);
        this.m_detailButtonBar.repaint();
    }

    public void setDetailContent(Component content) {
        if (this.m_detailContent != null) {
            this.m_subPanel.remove(this.m_detailContent);
        }
        this.m_detailContent = content;
        if (content != null) {
            this.m_subPanel.add(this.m_detailContent, BOTTOM_CONSTRAINTS);
            this.m_detailContent.setVisible(this.m_detailsVisible);
            this.m_subPanel.revalidate();
        }
    }

    public void setDetailVisible(final boolean isVisible) {
        if (this.isShowing()) {
            this._setDetailVisible(isVisible);
            return;
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                DetailDialog.this._setDetailVisible(isVisible);
                DetailDialog.this.removeWindowListener(this);
            }
        });
    }

    private void _setDetailVisible(boolean isVisible) {
        if (this.m_detailContent != null && this.m_detailsVisible != isVisible) {
            this.m_detailsVisible = isVisible;
            this.m_detailContent.setVisible(isVisible);
            if (isVisible) {
                if (this.m_detailsShownButtonText == null) {
                    DetailDialog.resButton(this.m_detailsButton, "DD_DETAILS_EXPANDED");
                } else {
                    DetailDialog.resButtonCustomText(this.m_detailsButton, this.m_detailsShownButtonText);
                }
                JComponent jComponent = GraphicsUtils.focusComponentOrChild((Component)this.m_detailContent, (boolean)true);
            } else if (this.m_detailsHiddenButtonText == null) {
                DetailDialog.resButton(this.m_detailsButton, "DD_DETAILS_COLLAPSED");
            } else {
                DetailDialog.resButtonCustomText(this.m_detailsButton, this.m_detailsHiddenButtonText);
            }
            this.pack();
        }
    }

    public void setHelpTopicId(String helpTopicId) {
        HelpUtils.setHelpID((JComponent)this.m_subPanel, (String)helpTopicId);
    }
}

