/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorOverviewTipProvider;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.ui.overview.Overview;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.util.Disposable;

public final class BasicEditorOverview
extends Overview<Integer, BasicEditorOverviewMark>
implements Disposable {
    private BasicEditorPane editor;
    private DocumentL documentL = new DocumentL();
    private PropertyChangeL propertyChangeL = new PropertyChangeL();
    private CodeExpansionL foldingL = new CodeExpansionL();
    private Set<BasicEditorOverviewMark> autoRemoveMarks = new HashSet<BasicEditorOverviewMark>();
    private Timer timer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicEditorOverview.this.sizeChange();
            BasicEditorOverview.this.autoRemove();
        }
    });

    public BasicEditorOverview(BasicEditorPane editor) {
        this(editor, true);
    }

    public BasicEditorOverview(BasicEditorPane editor, boolean isDefaultOverviewForEditor) {
        super((Number)0, (Number)(editor.getRowForLine(editor.getLineCount()) - 1));
        this.timer.setRepeats(false);
        this.editor = editor;
        this.setInfoTipProvider(new BasicEditorOverviewTipProvider(editor));
        if (isDefaultOverviewForEditor) {
            editor.putProperty("overview", (Object)this);
        }
        editor.getDocument().addDocumentListener(this.documentL);
        editor.addPropertyChangeListener("code-folding-margin", this.propertyChangeL);
        editor.addPropertyChangeListener("document", this.propertyChangeL);
    }

    public void dispose() {
        this.timer.stop();
        this.editor.getDocument().removeDocumentListener(this.documentL);
        this.editor.removePropertyChangeListener(this.propertyChangeL);
        if (this.foldingL.model != null) {
            this.foldingL.model.removeCodeFoldingModelListener(this.foldingL);
        }
        if (this.foldingL.margin != null) {
            this.foldingL.margin.removeCodeExpansionListener(this.foldingL);
        }
        this.foldingL.model = null;
        this.foldingL.margin = null;
        for (BasicEditorOverviewMark mark : this.getMarks()) {
            mark.dispose();
        }
    }

    private void sizeChange() {
        try {
            int line = this.editor.getLineCount();
            int row = this.editor.getRowForLine(line);
            this.setEnd(row - 1);
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    private void autoRemove() {
        ArrayList<BasicEditorOverviewMark> removeMarks = null;
        for (BasicEditorOverviewMark mark : this.autoRemoveMarks) {
            if (mark.getStartOffset() != mark.getEndOffset()) continue;
            if (removeMarks == null) {
                removeMarks = new ArrayList<BasicEditorOverviewMark>();
            }
            removeMarks.add(mark);
        }
        if (removeMarks != null) {
            for (BasicEditorOverviewMark mark : removeMarks) {
                this.removeMark(mark);
            }
        }
    }

    public void rebuild() {
        this.sizeChange();
        super.rebuild();
    }

    private void update() {
        this.timer.restart();
    }

    public Collection<BasicEditorOverviewMark> removeMarks(Object group) {
        Collection marks = super.removeMarks(group);
        for (BasicEditorOverviewMark mark : marks) {
            mark.dispose();
        }
        return marks;
    }

    public void removeMark(BasicEditorOverviewMark overviewMark) {
        super.removeMark((OverviewMark)overviewMark);
        overviewMark.dispose();
        this.autoRemoveMarks.remove(overviewMark);
    }

    public void addMark(BasicEditorOverviewMark mark) {
        super.addMark((OverviewMark)mark);
        if (mark.isAutoRemove()) {
            this.autoRemoveMarks.add(mark);
        }
    }

    private class DocumentL
    implements DocumentListener {
        private DocumentL() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            BasicEditorOverview.this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BasicEditorOverview.this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class CodeExpansionL
    implements CodeFoldingModelListener,
    CodeExpansionListener {
        private CodeFoldingModel model;
        private CodeFoldingMargin margin;

        private CodeExpansionL() {
        }

        @Override
        public void structureChanged(CodeFoldingModelEvent event) {
            BasicEditorOverview.this.update();
        }

        @Override
        public void codeExpanded(CodeExpansionEvent event) {
            BasicEditorOverview.this.update();
        }

        @Override
        public void codeCollapsed(CodeExpansionEvent event) {
            BasicEditorOverview.this.update();
        }
    }

    private class PropertyChangeL
    implements PropertyChangeListener {
        private PropertyChangeL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("code-folding-margin")) {
                if (BasicEditorOverview.this.foldingL.model != null) {
                    BasicEditorOverview.this.foldingL.model.removeCodeFoldingModelListener(BasicEditorOverview.this.foldingL);
                }
                if (BasicEditorOverview.this.foldingL.margin != null) {
                    BasicEditorOverview.this.foldingL.margin.removeCodeExpansionListener(BasicEditorOverview.this.foldingL);
                }
                if (evt.getNewValue() instanceof CodeFoldingMargin) {
                    CodeFoldingMargin codeFoldingMargin = (CodeFoldingMargin)evt.getNewValue();
                    codeFoldingMargin.getModel().addCodeFoldingModelListener(BasicEditorOverview.this.foldingL);
                    codeFoldingMargin.addCodeExpansionListener(BasicEditorOverview.this.foldingL);
                    BasicEditorOverview.this.foldingL.model = codeFoldingMargin.getModel();
                    BasicEditorOverview.this.foldingL.margin = codeFoldingMargin;
                    BasicEditorOverview.this.update();
                }
            } else if (evt.getPropertyName().equals("document")) {
                if (evt.getOldValue() != null) {
                    ((Document)evt.getOldValue()).removeDocumentListener(BasicEditorOverview.this.documentL);
                }
                BasicEditorOverview.this.editor.getDocument().addDocumentListener(BasicEditorOverview.this.documentL);
                BasicEditorOverview.this.update();
            }
        }
    }
}

